/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.MessageSchema;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TopicConfig;
import org.openmetadata.client.model.TopicSampleData;
/**
 * CreateTopic
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class CreateTopic {
  /**
   * Gets or Sets cleanupPolicies
   */
  public enum CleanupPoliciesEnum {
    DELETE("delete"),
    COMPACT("compact");

    private String value;

    CleanupPoliciesEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static CleanupPoliciesEnum fromValue(String text) {
      for (CleanupPoliciesEnum b : CleanupPoliciesEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("cleanupPolicies")
  private List<CleanupPoliciesEnum> cleanupPolicies = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("extension")
  private Object extension = null;

  @JsonProperty("maximumMessageSize")
  private Integer maximumMessageSize = null;

  @JsonProperty("messageSchema")
  private MessageSchema messageSchema = null;

  @JsonProperty("minimumInSyncReplicas")
  private Integer minimumInSyncReplicas = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("owner")
  private EntityReference owner = null;

  @JsonProperty("partitions")
  private Integer partitions = null;

  @JsonProperty("replicationFactor")
  private Integer replicationFactor = null;

  @JsonProperty("retentionSize")
  private Double retentionSize = null;

  @JsonProperty("retentionTime")
  private Double retentionTime = null;

  @JsonProperty("sampleData")
  private TopicSampleData sampleData = null;

  @JsonProperty("service")
  private EntityReference service = null;

  @JsonProperty("tags")
  private List<TagLabel> tags = null;

  @JsonProperty("topicConfig")
  private TopicConfig topicConfig = null;

  public CreateTopic cleanupPolicies(List<CleanupPoliciesEnum> cleanupPolicies) {
    this.cleanupPolicies = cleanupPolicies;
    return this;
  }

  public CreateTopic addCleanupPoliciesItem(CleanupPoliciesEnum cleanupPoliciesItem) {
    if (this.cleanupPolicies == null) {
      this.cleanupPolicies = new ArrayList<CleanupPoliciesEnum>();
    }
    this.cleanupPolicies.add(cleanupPoliciesItem);
    return this;
  }

   /**
   * Get cleanupPolicies
   * @return cleanupPolicies
  **/
  @Schema(description = "")
  public List<CleanupPoliciesEnum> getCleanupPolicies() {
    return cleanupPolicies;
  }

  public void setCleanupPolicies(List<CleanupPoliciesEnum> cleanupPolicies) {
    this.cleanupPolicies = cleanupPolicies;
  }

  public CreateTopic description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @Schema(description = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public CreateTopic displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @Schema(description = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public CreateTopic extension(Object extension) {
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @Schema(description = "")
  public Object getExtension() {
    return extension;
  }

  public void setExtension(Object extension) {
    this.extension = extension;
  }

  public CreateTopic maximumMessageSize(Integer maximumMessageSize) {
    this.maximumMessageSize = maximumMessageSize;
    return this;
  }

   /**
   * Get maximumMessageSize
   * @return maximumMessageSize
  **/
  @Schema(description = "")
  public Integer getMaximumMessageSize() {
    return maximumMessageSize;
  }

  public void setMaximumMessageSize(Integer maximumMessageSize) {
    this.maximumMessageSize = maximumMessageSize;
  }

  public CreateTopic messageSchema(MessageSchema messageSchema) {
    this.messageSchema = messageSchema;
    return this;
  }

   /**
   * Get messageSchema
   * @return messageSchema
  **/
  @Schema(description = "")
  public MessageSchema getMessageSchema() {
    return messageSchema;
  }

  public void setMessageSchema(MessageSchema messageSchema) {
    this.messageSchema = messageSchema;
  }

  public CreateTopic minimumInSyncReplicas(Integer minimumInSyncReplicas) {
    this.minimumInSyncReplicas = minimumInSyncReplicas;
    return this;
  }

   /**
   * Get minimumInSyncReplicas
   * @return minimumInSyncReplicas
  **/
  @Schema(description = "")
  public Integer getMinimumInSyncReplicas() {
    return minimumInSyncReplicas;
  }

  public void setMinimumInSyncReplicas(Integer minimumInSyncReplicas) {
    this.minimumInSyncReplicas = minimumInSyncReplicas;
  }

  public CreateTopic name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CreateTopic owner(EntityReference owner) {
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @Schema(description = "")
  public EntityReference getOwner() {
    return owner;
  }

  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }

  public CreateTopic partitions(Integer partitions) {
    this.partitions = partitions;
    return this;
  }

   /**
   * Get partitions
   * @return partitions
  **/
  @Schema(required = true, description = "")
  public Integer getPartitions() {
    return partitions;
  }

  public void setPartitions(Integer partitions) {
    this.partitions = partitions;
  }

  public CreateTopic replicationFactor(Integer replicationFactor) {
    this.replicationFactor = replicationFactor;
    return this;
  }

   /**
   * Get replicationFactor
   * @return replicationFactor
  **/
  @Schema(description = "")
  public Integer getReplicationFactor() {
    return replicationFactor;
  }

  public void setReplicationFactor(Integer replicationFactor) {
    this.replicationFactor = replicationFactor;
  }

  public CreateTopic retentionSize(Double retentionSize) {
    this.retentionSize = retentionSize;
    return this;
  }

   /**
   * Get retentionSize
   * @return retentionSize
  **/
  @Schema(description = "")
  public Double getRetentionSize() {
    return retentionSize;
  }

  public void setRetentionSize(Double retentionSize) {
    this.retentionSize = retentionSize;
  }

  public CreateTopic retentionTime(Double retentionTime) {
    this.retentionTime = retentionTime;
    return this;
  }

   /**
   * Get retentionTime
   * @return retentionTime
  **/
  @Schema(description = "")
  public Double getRetentionTime() {
    return retentionTime;
  }

  public void setRetentionTime(Double retentionTime) {
    this.retentionTime = retentionTime;
  }

  public CreateTopic sampleData(TopicSampleData sampleData) {
    this.sampleData = sampleData;
    return this;
  }

   /**
   * Get sampleData
   * @return sampleData
  **/
  @Schema(description = "")
  public TopicSampleData getSampleData() {
    return sampleData;
  }

  public void setSampleData(TopicSampleData sampleData) {
    this.sampleData = sampleData;
  }

  public CreateTopic service(EntityReference service) {
    this.service = service;
    return this;
  }

   /**
   * Get service
   * @return service
  **/
  @Schema(required = true, description = "")
  public EntityReference getService() {
    return service;
  }

  public void setService(EntityReference service) {
    this.service = service;
  }

  public CreateTopic tags(List<TagLabel> tags) {
    this.tags = tags;
    return this;
  }

  public CreateTopic addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<TagLabel>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @Schema(description = "")
  public List<TagLabel> getTags() {
    return tags;
  }

  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }

  public CreateTopic topicConfig(TopicConfig topicConfig) {
    this.topicConfig = topicConfig;
    return this;
  }

   /**
   * Get topicConfig
   * @return topicConfig
  **/
  @Schema(description = "")
  public TopicConfig getTopicConfig() {
    return topicConfig;
  }

  public void setTopicConfig(TopicConfig topicConfig) {
    this.topicConfig = topicConfig;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateTopic createTopic = (CreateTopic) o;
    return Objects.equals(this.cleanupPolicies, createTopic.cleanupPolicies) &&
        Objects.equals(this.description, createTopic.description) &&
        Objects.equals(this.displayName, createTopic.displayName) &&
        Objects.equals(this.extension, createTopic.extension) &&
        Objects.equals(this.maximumMessageSize, createTopic.maximumMessageSize) &&
        Objects.equals(this.messageSchema, createTopic.messageSchema) &&
        Objects.equals(this.minimumInSyncReplicas, createTopic.minimumInSyncReplicas) &&
        Objects.equals(this.name, createTopic.name) &&
        Objects.equals(this.owner, createTopic.owner) &&
        Objects.equals(this.partitions, createTopic.partitions) &&
        Objects.equals(this.replicationFactor, createTopic.replicationFactor) &&
        Objects.equals(this.retentionSize, createTopic.retentionSize) &&
        Objects.equals(this.retentionTime, createTopic.retentionTime) &&
        Objects.equals(this.sampleData, createTopic.sampleData) &&
        Objects.equals(this.service, createTopic.service) &&
        Objects.equals(this.tags, createTopic.tags) &&
        Objects.equals(this.topicConfig, createTopic.topicConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cleanupPolicies, description, displayName, extension, maximumMessageSize, messageSchema, minimumInSyncReplicas, name, owner, partitions, replicationFactor, retentionSize, retentionTime, sampleData, service, tags, topicConfig);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateTopic {\n");
    
    sb.append("    cleanupPolicies: ").append(toIndentedString(cleanupPolicies)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    maximumMessageSize: ").append(toIndentedString(maximumMessageSize)).append("\n");
    sb.append("    messageSchema: ").append(toIndentedString(messageSchema)).append("\n");
    sb.append("    minimumInSyncReplicas: ").append(toIndentedString(minimumInSyncReplicas)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    partitions: ").append(toIndentedString(partitions)).append("\n");
    sb.append("    replicationFactor: ").append(toIndentedString(replicationFactor)).append("\n");
    sb.append("    retentionSize: ").append(toIndentedString(retentionSize)).append("\n");
    sb.append("    retentionTime: ").append(toIndentedString(retentionTime)).append("\n");
    sb.append("    sampleData: ").append(toIndentedString(sampleData)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    topicConfig: ").append(toIndentedString(topicConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
