/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
/**
 * CsvImportResult
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class CsvImportResult {
  @JsonProperty("abortReason")
  private String abortReason = null;

  @JsonProperty("dryRun")
  private Boolean dryRun = null;

  @JsonProperty("importResultsCsv")
  private String importResultsCsv = null;

  @JsonProperty("numberOfRowsFailed")
  private Integer numberOfRowsFailed = null;

  @JsonProperty("numberOfRowsPassed")
  private Integer numberOfRowsPassed = null;

  @JsonProperty("numberOfRowsProcessed")
  private Integer numberOfRowsProcessed = null;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    SUCCESS("success"),
    FAILURE("failure"),
    ABORTED("aborted"),
    PARTIALSUCCESS("partialSuccess");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("status")
  private StatusEnum status = null;

  public CsvImportResult abortReason(String abortReason) {
    this.abortReason = abortReason;
    return this;
  }

   /**
   * Get abortReason
   * @return abortReason
  **/
  @Schema(description = "")
  public String getAbortReason() {
    return abortReason;
  }

  public void setAbortReason(String abortReason) {
    this.abortReason = abortReason;
  }

  public CsvImportResult dryRun(Boolean dryRun) {
    this.dryRun = dryRun;
    return this;
  }

   /**
   * Get dryRun
   * @return dryRun
  **/
  @Schema(description = "")
  public Boolean isDryRun() {
    return dryRun;
  }

  public void setDryRun(Boolean dryRun) {
    this.dryRun = dryRun;
  }

  public CsvImportResult importResultsCsv(String importResultsCsv) {
    this.importResultsCsv = importResultsCsv;
    return this;
  }

   /**
   * Get importResultsCsv
   * @return importResultsCsv
  **/
  @Schema(description = "")
  public String getImportResultsCsv() {
    return importResultsCsv;
  }

  public void setImportResultsCsv(String importResultsCsv) {
    this.importResultsCsv = importResultsCsv;
  }

  public CsvImportResult numberOfRowsFailed(Integer numberOfRowsFailed) {
    this.numberOfRowsFailed = numberOfRowsFailed;
    return this;
  }

   /**
   * Get numberOfRowsFailed
   * @return numberOfRowsFailed
  **/
  @Schema(description = "")
  public Integer getNumberOfRowsFailed() {
    return numberOfRowsFailed;
  }

  public void setNumberOfRowsFailed(Integer numberOfRowsFailed) {
    this.numberOfRowsFailed = numberOfRowsFailed;
  }

  public CsvImportResult numberOfRowsPassed(Integer numberOfRowsPassed) {
    this.numberOfRowsPassed = numberOfRowsPassed;
    return this;
  }

   /**
   * Get numberOfRowsPassed
   * @return numberOfRowsPassed
  **/
  @Schema(description = "")
  public Integer getNumberOfRowsPassed() {
    return numberOfRowsPassed;
  }

  public void setNumberOfRowsPassed(Integer numberOfRowsPassed) {
    this.numberOfRowsPassed = numberOfRowsPassed;
  }

  public CsvImportResult numberOfRowsProcessed(Integer numberOfRowsProcessed) {
    this.numberOfRowsProcessed = numberOfRowsProcessed;
    return this;
  }

   /**
   * Get numberOfRowsProcessed
   * @return numberOfRowsProcessed
  **/
  @Schema(description = "")
  public Integer getNumberOfRowsProcessed() {
    return numberOfRowsProcessed;
  }

  public void setNumberOfRowsProcessed(Integer numberOfRowsProcessed) {
    this.numberOfRowsProcessed = numberOfRowsProcessed;
  }

  public CsvImportResult status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @Schema(description = "")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CsvImportResult csvImportResult = (CsvImportResult) o;
    return Objects.equals(this.abortReason, csvImportResult.abortReason) &&
        Objects.equals(this.dryRun, csvImportResult.dryRun) &&
        Objects.equals(this.importResultsCsv, csvImportResult.importResultsCsv) &&
        Objects.equals(this.numberOfRowsFailed, csvImportResult.numberOfRowsFailed) &&
        Objects.equals(this.numberOfRowsPassed, csvImportResult.numberOfRowsPassed) &&
        Objects.equals(this.numberOfRowsProcessed, csvImportResult.numberOfRowsProcessed) &&
        Objects.equals(this.status, csvImportResult.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(abortReason, dryRun, importResultsCsv, numberOfRowsFailed, numberOfRowsPassed, numberOfRowsProcessed, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CsvImportResult {\n");
    
    sb.append("    abortReason: ").append(toIndentedString(abortReason)).append("\n");
    sb.append("    dryRun: ").append(toIndentedString(dryRun)).append("\n");
    sb.append("    importResultsCsv: ").append(toIndentedString(importResultsCsv)).append("\n");
    sb.append("    numberOfRowsFailed: ").append(toIndentedString(numberOfRowsFailed)).append("\n");
    sb.append("    numberOfRowsPassed: ").append(toIndentedString(numberOfRowsPassed)).append("\n");
    sb.append("    numberOfRowsProcessed: ").append(toIndentedString(numberOfRowsProcessed)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
