/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
/**
 * EntitiesCount
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class EntitiesCount {
  @JsonProperty("dashboardCount")
  private Integer dashboardCount = null;

  @JsonProperty("mlmodelCount")
  private Integer mlmodelCount = null;

  @JsonProperty("pipelineCount")
  private Integer pipelineCount = null;

  @JsonProperty("servicesCount")
  private Integer servicesCount = null;

  @JsonProperty("tableCount")
  private Integer tableCount = null;

  @JsonProperty("teamCount")
  private Integer teamCount = null;

  @JsonProperty("testSuiteCount")
  private Integer testSuiteCount = null;

  @JsonProperty("topicCount")
  private Integer topicCount = null;

  @JsonProperty("userCount")
  private Integer userCount = null;

  public EntitiesCount dashboardCount(Integer dashboardCount) {
    this.dashboardCount = dashboardCount;
    return this;
  }

   /**
   * Get dashboardCount
   * @return dashboardCount
  **/
  @Schema(description = "")
  public Integer getDashboardCount() {
    return dashboardCount;
  }

  public void setDashboardCount(Integer dashboardCount) {
    this.dashboardCount = dashboardCount;
  }

  public EntitiesCount mlmodelCount(Integer mlmodelCount) {
    this.mlmodelCount = mlmodelCount;
    return this;
  }

   /**
   * Get mlmodelCount
   * @return mlmodelCount
  **/
  @Schema(description = "")
  public Integer getMlmodelCount() {
    return mlmodelCount;
  }

  public void setMlmodelCount(Integer mlmodelCount) {
    this.mlmodelCount = mlmodelCount;
  }

  public EntitiesCount pipelineCount(Integer pipelineCount) {
    this.pipelineCount = pipelineCount;
    return this;
  }

   /**
   * Get pipelineCount
   * @return pipelineCount
  **/
  @Schema(description = "")
  public Integer getPipelineCount() {
    return pipelineCount;
  }

  public void setPipelineCount(Integer pipelineCount) {
    this.pipelineCount = pipelineCount;
  }

  public EntitiesCount servicesCount(Integer servicesCount) {
    this.servicesCount = servicesCount;
    return this;
  }

   /**
   * Get servicesCount
   * @return servicesCount
  **/
  @Schema(description = "")
  public Integer getServicesCount() {
    return servicesCount;
  }

  public void setServicesCount(Integer servicesCount) {
    this.servicesCount = servicesCount;
  }

  public EntitiesCount tableCount(Integer tableCount) {
    this.tableCount = tableCount;
    return this;
  }

   /**
   * Get tableCount
   * @return tableCount
  **/
  @Schema(description = "")
  public Integer getTableCount() {
    return tableCount;
  }

  public void setTableCount(Integer tableCount) {
    this.tableCount = tableCount;
  }

  public EntitiesCount teamCount(Integer teamCount) {
    this.teamCount = teamCount;
    return this;
  }

   /**
   * Get teamCount
   * @return teamCount
  **/
  @Schema(description = "")
  public Integer getTeamCount() {
    return teamCount;
  }

  public void setTeamCount(Integer teamCount) {
    this.teamCount = teamCount;
  }

  public EntitiesCount testSuiteCount(Integer testSuiteCount) {
    this.testSuiteCount = testSuiteCount;
    return this;
  }

   /**
   * Get testSuiteCount
   * @return testSuiteCount
  **/
  @Schema(description = "")
  public Integer getTestSuiteCount() {
    return testSuiteCount;
  }

  public void setTestSuiteCount(Integer testSuiteCount) {
    this.testSuiteCount = testSuiteCount;
  }

  public EntitiesCount topicCount(Integer topicCount) {
    this.topicCount = topicCount;
    return this;
  }

   /**
   * Get topicCount
   * @return topicCount
  **/
  @Schema(description = "")
  public Integer getTopicCount() {
    return topicCount;
  }

  public void setTopicCount(Integer topicCount) {
    this.topicCount = topicCount;
  }

  public EntitiesCount userCount(Integer userCount) {
    this.userCount = userCount;
    return this;
  }

   /**
   * Get userCount
   * @return userCount
  **/
  @Schema(description = "")
  public Integer getUserCount() {
    return userCount;
  }

  public void setUserCount(Integer userCount) {
    this.userCount = userCount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EntitiesCount entitiesCount = (EntitiesCount) o;
    return Objects.equals(this.dashboardCount, entitiesCount.dashboardCount) &&
        Objects.equals(this.mlmodelCount, entitiesCount.mlmodelCount) &&
        Objects.equals(this.pipelineCount, entitiesCount.pipelineCount) &&
        Objects.equals(this.servicesCount, entitiesCount.servicesCount) &&
        Objects.equals(this.tableCount, entitiesCount.tableCount) &&
        Objects.equals(this.teamCount, entitiesCount.teamCount) &&
        Objects.equals(this.testSuiteCount, entitiesCount.testSuiteCount) &&
        Objects.equals(this.topicCount, entitiesCount.topicCount) &&
        Objects.equals(this.userCount, entitiesCount.userCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dashboardCount, mlmodelCount, pipelineCount, servicesCount, tableCount, teamCount, testSuiteCount, topicCount, userCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EntitiesCount {\n");
    
    sb.append("    dashboardCount: ").append(toIndentedString(dashboardCount)).append("\n");
    sb.append("    mlmodelCount: ").append(toIndentedString(mlmodelCount)).append("\n");
    sb.append("    pipelineCount: ").append(toIndentedString(pipelineCount)).append("\n");
    sb.append("    servicesCount: ").append(toIndentedString(servicesCount)).append("\n");
    sb.append("    tableCount: ").append(toIndentedString(tableCount)).append("\n");
    sb.append("    teamCount: ").append(toIndentedString(teamCount)).append("\n");
    sb.append("    testSuiteCount: ").append(toIndentedString(testSuiteCount)).append("\n");
    sb.append("    topicCount: ").append(toIndentedString(topicCount)).append("\n");
    sb.append("    userCount: ").append(toIndentedString(userCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
