/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TermReference;
/**
 * GlossaryTerm
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class GlossaryTerm {
  @JsonProperty("changeDescription")
  private ChangeDescription changeDescription = null;

  @JsonProperty("children")
  private List<EntityReference> children = null;

  @JsonProperty("deleted")
  private Boolean deleted = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("disabled")
  private Boolean disabled = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("extension")
  private Object extension = null;

  @JsonProperty("followers")
  private List<EntityReference> followers = null;

  @JsonProperty("fullyQualifiedName")
  private String fullyQualifiedName = null;

  @JsonProperty("glossary")
  private EntityReference glossary = null;

  @JsonProperty("href")
  private String href = null;

  @JsonProperty("id")
  private UUID id = null;

  @JsonProperty("mutuallyExclusive")
  private Boolean mutuallyExclusive = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("owner")
  private EntityReference owner = null;

  @JsonProperty("parent")
  private EntityReference parent = null;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static ProviderEnum fromValue(String text) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("provider")
  private ProviderEnum provider = null;

  @JsonProperty("references")
  private List<TermReference> references = null;

  @JsonProperty("relatedTerms")
  private List<EntityReference> relatedTerms = null;

  @JsonProperty("reviewers")
  private List<EntityReference> reviewers = null;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    DRAFT("Draft"),
    APPROVED("Approved"),
    DEPRECATED("Deprecated");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("synonyms")
  private List<String> synonyms = null;

  @JsonProperty("tags")
  private List<TagLabel> tags = null;

  @JsonProperty("updatedAt")
  private Long updatedAt = null;

  @JsonProperty("updatedBy")
  private String updatedBy = null;

  @JsonProperty("usageCount")
  private Integer usageCount = null;

  @JsonProperty("version")
  private Double version = null;

  public GlossaryTerm changeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @Schema(description = "")
  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }

  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }

  public GlossaryTerm children(List<EntityReference> children) {
    this.children = children;
    return this;
  }

  public GlossaryTerm addChildrenItem(EntityReference childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<EntityReference>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @Schema(description = "")
  public List<EntityReference> getChildren() {
    return children;
  }

  public void setChildren(List<EntityReference> children) {
    this.children = children;
  }

  public GlossaryTerm deleted(Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @Schema(description = "")
  public Boolean isDeleted() {
    return deleted;
  }

  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }

  public GlossaryTerm description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @Schema(required = true, description = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public GlossaryTerm disabled(Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

   /**
   * Get disabled
   * @return disabled
  **/
  @Schema(description = "")
  public Boolean isDisabled() {
    return disabled;
  }

  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }

  public GlossaryTerm displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @Schema(description = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public GlossaryTerm extension(Object extension) {
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @Schema(description = "")
  public Object getExtension() {
    return extension;
  }

  public void setExtension(Object extension) {
    this.extension = extension;
  }

  public GlossaryTerm followers(List<EntityReference> followers) {
    this.followers = followers;
    return this;
  }

  public GlossaryTerm addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<EntityReference>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @Schema(description = "")
  public List<EntityReference> getFollowers() {
    return followers;
  }

  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }

  public GlossaryTerm fullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @Schema(description = "")
  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }

  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }

  public GlossaryTerm glossary(EntityReference glossary) {
    this.glossary = glossary;
    return this;
  }

   /**
   * Get glossary
   * @return glossary
  **/
  @Schema(required = true, description = "")
  public EntityReference getGlossary() {
    return glossary;
  }

  public void setGlossary(EntityReference glossary) {
    this.glossary = glossary;
  }

  public GlossaryTerm href(String href) {
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @Schema(description = "")
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public GlossaryTerm id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(required = true, description = "")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public GlossaryTerm mutuallyExclusive(Boolean mutuallyExclusive) {
    this.mutuallyExclusive = mutuallyExclusive;
    return this;
  }

   /**
   * Get mutuallyExclusive
   * @return mutuallyExclusive
  **/
  @Schema(description = "")
  public Boolean isMutuallyExclusive() {
    return mutuallyExclusive;
  }

  public void setMutuallyExclusive(Boolean mutuallyExclusive) {
    this.mutuallyExclusive = mutuallyExclusive;
  }

  public GlossaryTerm name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public GlossaryTerm owner(EntityReference owner) {
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @Schema(description = "")
  public EntityReference getOwner() {
    return owner;
  }

  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }

  public GlossaryTerm parent(EntityReference parent) {
    this.parent = parent;
    return this;
  }

   /**
   * Get parent
   * @return parent
  **/
  @Schema(description = "")
  public EntityReference getParent() {
    return parent;
  }

  public void setParent(EntityReference parent) {
    this.parent = parent;
  }

  public GlossaryTerm provider(ProviderEnum provider) {
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @Schema(description = "")
  public ProviderEnum getProvider() {
    return provider;
  }

  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }

  public GlossaryTerm references(List<TermReference> references) {
    this.references = references;
    return this;
  }

  public GlossaryTerm addReferencesItem(TermReference referencesItem) {
    if (this.references == null) {
      this.references = new ArrayList<TermReference>();
    }
    this.references.add(referencesItem);
    return this;
  }

   /**
   * Get references
   * @return references
  **/
  @Schema(description = "")
  public List<TermReference> getReferences() {
    return references;
  }

  public void setReferences(List<TermReference> references) {
    this.references = references;
  }

  public GlossaryTerm relatedTerms(List<EntityReference> relatedTerms) {
    this.relatedTerms = relatedTerms;
    return this;
  }

  public GlossaryTerm addRelatedTermsItem(EntityReference relatedTermsItem) {
    if (this.relatedTerms == null) {
      this.relatedTerms = new ArrayList<EntityReference>();
    }
    this.relatedTerms.add(relatedTermsItem);
    return this;
  }

   /**
   * Get relatedTerms
   * @return relatedTerms
  **/
  @Schema(description = "")
  public List<EntityReference> getRelatedTerms() {
    return relatedTerms;
  }

  public void setRelatedTerms(List<EntityReference> relatedTerms) {
    this.relatedTerms = relatedTerms;
  }

  public GlossaryTerm reviewers(List<EntityReference> reviewers) {
    this.reviewers = reviewers;
    return this;
  }

  public GlossaryTerm addReviewersItem(EntityReference reviewersItem) {
    if (this.reviewers == null) {
      this.reviewers = new ArrayList<EntityReference>();
    }
    this.reviewers.add(reviewersItem);
    return this;
  }

   /**
   * Get reviewers
   * @return reviewers
  **/
  @Schema(description = "")
  public List<EntityReference> getReviewers() {
    return reviewers;
  }

  public void setReviewers(List<EntityReference> reviewers) {
    this.reviewers = reviewers;
  }

  public GlossaryTerm status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @Schema(description = "")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public GlossaryTerm synonyms(List<String> synonyms) {
    this.synonyms = synonyms;
    return this;
  }

  public GlossaryTerm addSynonymsItem(String synonymsItem) {
    if (this.synonyms == null) {
      this.synonyms = new ArrayList<String>();
    }
    this.synonyms.add(synonymsItem);
    return this;
  }

   /**
   * Get synonyms
   * @return synonyms
  **/
  @Schema(description = "")
  public List<String> getSynonyms() {
    return synonyms;
  }

  public void setSynonyms(List<String> synonyms) {
    this.synonyms = synonyms;
  }

  public GlossaryTerm tags(List<TagLabel> tags) {
    this.tags = tags;
    return this;
  }

  public GlossaryTerm addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<TagLabel>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @Schema(description = "")
  public List<TagLabel> getTags() {
    return tags;
  }

  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }

  public GlossaryTerm updatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @Schema(description = "")
  public Long getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }

  public GlossaryTerm updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @Schema(description = "")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  public GlossaryTerm usageCount(Integer usageCount) {
    this.usageCount = usageCount;
    return this;
  }

   /**
   * Get usageCount
   * @return usageCount
  **/
  @Schema(description = "")
  public Integer getUsageCount() {
    return usageCount;
  }

  public void setUsageCount(Integer usageCount) {
    this.usageCount = usageCount;
  }

  public GlossaryTerm version(Double version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @Schema(description = "")
  public Double getVersion() {
    return version;
  }

  public void setVersion(Double version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GlossaryTerm glossaryTerm = (GlossaryTerm) o;
    return Objects.equals(this.changeDescription, glossaryTerm.changeDescription) &&
        Objects.equals(this.children, glossaryTerm.children) &&
        Objects.equals(this.deleted, glossaryTerm.deleted) &&
        Objects.equals(this.description, glossaryTerm.description) &&
        Objects.equals(this.disabled, glossaryTerm.disabled) &&
        Objects.equals(this.displayName, glossaryTerm.displayName) &&
        Objects.equals(this.extension, glossaryTerm.extension) &&
        Objects.equals(this.followers, glossaryTerm.followers) &&
        Objects.equals(this.fullyQualifiedName, glossaryTerm.fullyQualifiedName) &&
        Objects.equals(this.glossary, glossaryTerm.glossary) &&
        Objects.equals(this.href, glossaryTerm.href) &&
        Objects.equals(this.id, glossaryTerm.id) &&
        Objects.equals(this.mutuallyExclusive, glossaryTerm.mutuallyExclusive) &&
        Objects.equals(this.name, glossaryTerm.name) &&
        Objects.equals(this.owner, glossaryTerm.owner) &&
        Objects.equals(this.parent, glossaryTerm.parent) &&
        Objects.equals(this.provider, glossaryTerm.provider) &&
        Objects.equals(this.references, glossaryTerm.references) &&
        Objects.equals(this.relatedTerms, glossaryTerm.relatedTerms) &&
        Objects.equals(this.reviewers, glossaryTerm.reviewers) &&
        Objects.equals(this.status, glossaryTerm.status) &&
        Objects.equals(this.synonyms, glossaryTerm.synonyms) &&
        Objects.equals(this.tags, glossaryTerm.tags) &&
        Objects.equals(this.updatedAt, glossaryTerm.updatedAt) &&
        Objects.equals(this.updatedBy, glossaryTerm.updatedBy) &&
        Objects.equals(this.usageCount, glossaryTerm.usageCount) &&
        Objects.equals(this.version, glossaryTerm.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeDescription, children, deleted, description, disabled, displayName, extension, followers, fullyQualifiedName, glossary, href, id, mutuallyExclusive, name, owner, parent, provider, references, relatedTerms, reviewers, status, synonyms, tags, updatedAt, updatedBy, usageCount, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GlossaryTerm {\n");
    
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    glossary: ").append(toIndentedString(glossary)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    mutuallyExclusive: ").append(toIndentedString(mutuallyExclusive)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    parent: ").append(toIndentedString(parent)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    references: ").append(toIndentedString(references)).append("\n");
    sb.append("    relatedTerms: ").append(toIndentedString(relatedTerms)).append("\n");
    sb.append("    reviewers: ").append(toIndentedString(reviewers)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    synonyms: ").append(toIndentedString(synonyms)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    usageCount: ").append(toIndentedString(usageCount)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
