/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
/**
 * ImageList
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class ImageList {
  @JsonProperty("image")
  private String image = null;

  @JsonProperty("image192")
  private String image192 = null;

  @JsonProperty("image24")
  private String image24 = null;

  @JsonProperty("image32")
  private String image32 = null;

  @JsonProperty("image48")
  private String image48 = null;

  @JsonProperty("image512")
  private String image512 = null;

  @JsonProperty("image72")
  private String image72 = null;

  public ImageList image(String image) {
    this.image = image;
    return this;
  }

   /**
   * Get image
   * @return image
  **/
  @Schema(description = "")
  public String getImage() {
    return image;
  }

  public void setImage(String image) {
    this.image = image;
  }

  public ImageList image192(String image192) {
    this.image192 = image192;
    return this;
  }

   /**
   * Get image192
   * @return image192
  **/
  @Schema(description = "")
  public String getImage192() {
    return image192;
  }

  public void setImage192(String image192) {
    this.image192 = image192;
  }

  public ImageList image24(String image24) {
    this.image24 = image24;
    return this;
  }

   /**
   * Get image24
   * @return image24
  **/
  @Schema(description = "")
  public String getImage24() {
    return image24;
  }

  public void setImage24(String image24) {
    this.image24 = image24;
  }

  public ImageList image32(String image32) {
    this.image32 = image32;
    return this;
  }

   /**
   * Get image32
   * @return image32
  **/
  @Schema(description = "")
  public String getImage32() {
    return image32;
  }

  public void setImage32(String image32) {
    this.image32 = image32;
  }

  public ImageList image48(String image48) {
    this.image48 = image48;
    return this;
  }

   /**
   * Get image48
   * @return image48
  **/
  @Schema(description = "")
  public String getImage48() {
    return image48;
  }

  public void setImage48(String image48) {
    this.image48 = image48;
  }

  public ImageList image512(String image512) {
    this.image512 = image512;
    return this;
  }

   /**
   * Get image512
   * @return image512
  **/
  @Schema(description = "")
  public String getImage512() {
    return image512;
  }

  public void setImage512(String image512) {
    this.image512 = image512;
  }

  public ImageList image72(String image72) {
    this.image72 = image72;
    return this;
  }

   /**
   * Get image72
   * @return image72
  **/
  @Schema(description = "")
  public String getImage72() {
    return image72;
  }

  public void setImage72(String image72) {
    this.image72 = image72;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ImageList imageList = (ImageList) o;
    return Objects.equals(this.image, imageList.image) &&
        Objects.equals(this.image192, imageList.image192) &&
        Objects.equals(this.image24, imageList.image24) &&
        Objects.equals(this.image32, imageList.image32) &&
        Objects.equals(this.image48, imageList.image48) &&
        Objects.equals(this.image512, imageList.image512) &&
        Objects.equals(this.image72, imageList.image72);
  }

  @Override
  public int hashCode() {
    return Objects.hash(image, image192, image24, image32, image48, image512, image72);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ImageList {\n");
    
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    image192: ").append(toIndentedString(image192)).append("\n");
    sb.append("    image24: ").append(toIndentedString(image24)).append("\n");
    sb.append("    image32: ").append(toIndentedString(image32)).append("\n");
    sb.append("    image48: ").append(toIndentedString(image48)).append("\n");
    sb.append("    image512: ").append(toIndentedString(image512)).append("\n");
    sb.append("    image72: ").append(toIndentedString(image72)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
