/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
/**
 * LdapConfiguration
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class LdapConfiguration {
  @JsonProperty("dnAdminPassword")
  private String dnAdminPassword = null;

  @JsonProperty("dnAdminPrincipal")
  private String dnAdminPrincipal = null;

  @JsonProperty("host")
  private String host = null;

  @JsonProperty("isFullDn")
  private Boolean isFullDn = null;

  @JsonProperty("keyStorePassword")
  private String keyStorePassword = null;

  @JsonProperty("keyStorePath")
  private String keyStorePath = null;

  @JsonProperty("mailAttributeName")
  private String mailAttributeName = null;

  @JsonProperty("maxPoolSize")
  private Integer maxPoolSize = null;

  @JsonProperty("port")
  private Integer port = null;

  @JsonProperty("sslEnabled")
  private Boolean sslEnabled = null;

  @JsonProperty("truststoreFormat")
  private String truststoreFormat = null;

  @JsonProperty("userBaseDN")
  private String userBaseDN = null;

  @JsonProperty("verifyCertificateHostname")
  private Boolean verifyCertificateHostname = null;

  public LdapConfiguration dnAdminPassword(String dnAdminPassword) {
    this.dnAdminPassword = dnAdminPassword;
    return this;
  }

   /**
   * Get dnAdminPassword
   * @return dnAdminPassword
  **/
  @Schema(required = true, description = "")
  public String getDnAdminPassword() {
    return dnAdminPassword;
  }

  public void setDnAdminPassword(String dnAdminPassword) {
    this.dnAdminPassword = dnAdminPassword;
  }

  public LdapConfiguration dnAdminPrincipal(String dnAdminPrincipal) {
    this.dnAdminPrincipal = dnAdminPrincipal;
    return this;
  }

   /**
   * Get dnAdminPrincipal
   * @return dnAdminPrincipal
  **/
  @Schema(required = true, description = "")
  public String getDnAdminPrincipal() {
    return dnAdminPrincipal;
  }

  public void setDnAdminPrincipal(String dnAdminPrincipal) {
    this.dnAdminPrincipal = dnAdminPrincipal;
  }

  public LdapConfiguration host(String host) {
    this.host = host;
    return this;
  }

   /**
   * Get host
   * @return host
  **/
  @Schema(required = true, description = "")
  public String getHost() {
    return host;
  }

  public void setHost(String host) {
    this.host = host;
  }

  public LdapConfiguration isFullDn(Boolean isFullDn) {
    this.isFullDn = isFullDn;
    return this;
  }

   /**
   * Get isFullDn
   * @return isFullDn
  **/
  @Schema(description = "")
  public Boolean isIsFullDn() {
    return isFullDn;
  }

  public void setIsFullDn(Boolean isFullDn) {
    this.isFullDn = isFullDn;
  }

  public LdapConfiguration keyStorePassword(String keyStorePassword) {
    this.keyStorePassword = keyStorePassword;
    return this;
  }

   /**
   * Get keyStorePassword
   * @return keyStorePassword
  **/
  @Schema(description = "")
  public String getKeyStorePassword() {
    return keyStorePassword;
  }

  public void setKeyStorePassword(String keyStorePassword) {
    this.keyStorePassword = keyStorePassword;
  }

  public LdapConfiguration keyStorePath(String keyStorePath) {
    this.keyStorePath = keyStorePath;
    return this;
  }

   /**
   * Get keyStorePath
   * @return keyStorePath
  **/
  @Schema(description = "")
  public String getKeyStorePath() {
    return keyStorePath;
  }

  public void setKeyStorePath(String keyStorePath) {
    this.keyStorePath = keyStorePath;
  }

  public LdapConfiguration mailAttributeName(String mailAttributeName) {
    this.mailAttributeName = mailAttributeName;
    return this;
  }

   /**
   * Get mailAttributeName
   * @return mailAttributeName
  **/
  @Schema(required = true, description = "")
  public String getMailAttributeName() {
    return mailAttributeName;
  }

  public void setMailAttributeName(String mailAttributeName) {
    this.mailAttributeName = mailAttributeName;
  }

  public LdapConfiguration maxPoolSize(Integer maxPoolSize) {
    this.maxPoolSize = maxPoolSize;
    return this;
  }

   /**
   * Get maxPoolSize
   * @return maxPoolSize
  **/
  @Schema(description = "")
  public Integer getMaxPoolSize() {
    return maxPoolSize;
  }

  public void setMaxPoolSize(Integer maxPoolSize) {
    this.maxPoolSize = maxPoolSize;
  }

  public LdapConfiguration port(Integer port) {
    this.port = port;
    return this;
  }

   /**
   * Get port
   * @return port
  **/
  @Schema(required = true, description = "")
  public Integer getPort() {
    return port;
  }

  public void setPort(Integer port) {
    this.port = port;
  }

  public LdapConfiguration sslEnabled(Boolean sslEnabled) {
    this.sslEnabled = sslEnabled;
    return this;
  }

   /**
   * Get sslEnabled
   * @return sslEnabled
  **/
  @Schema(description = "")
  public Boolean isSslEnabled() {
    return sslEnabled;
  }

  public void setSslEnabled(Boolean sslEnabled) {
    this.sslEnabled = sslEnabled;
  }

  public LdapConfiguration truststoreFormat(String truststoreFormat) {
    this.truststoreFormat = truststoreFormat;
    return this;
  }

   /**
   * Get truststoreFormat
   * @return truststoreFormat
  **/
  @Schema(description = "")
  public String getTruststoreFormat() {
    return truststoreFormat;
  }

  public void setTruststoreFormat(String truststoreFormat) {
    this.truststoreFormat = truststoreFormat;
  }

  public LdapConfiguration userBaseDN(String userBaseDN) {
    this.userBaseDN = userBaseDN;
    return this;
  }

   /**
   * Get userBaseDN
   * @return userBaseDN
  **/
  @Schema(required = true, description = "")
  public String getUserBaseDN() {
    return userBaseDN;
  }

  public void setUserBaseDN(String userBaseDN) {
    this.userBaseDN = userBaseDN;
  }

  public LdapConfiguration verifyCertificateHostname(Boolean verifyCertificateHostname) {
    this.verifyCertificateHostname = verifyCertificateHostname;
    return this;
  }

   /**
   * Get verifyCertificateHostname
   * @return verifyCertificateHostname
  **/
  @Schema(description = "")
  public Boolean isVerifyCertificateHostname() {
    return verifyCertificateHostname;
  }

  public void setVerifyCertificateHostname(Boolean verifyCertificateHostname) {
    this.verifyCertificateHostname = verifyCertificateHostname;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LdapConfiguration ldapConfiguration = (LdapConfiguration) o;
    return Objects.equals(this.dnAdminPassword, ldapConfiguration.dnAdminPassword) &&
        Objects.equals(this.dnAdminPrincipal, ldapConfiguration.dnAdminPrincipal) &&
        Objects.equals(this.host, ldapConfiguration.host) &&
        Objects.equals(this.isFullDn, ldapConfiguration.isFullDn) &&
        Objects.equals(this.keyStorePassword, ldapConfiguration.keyStorePassword) &&
        Objects.equals(this.keyStorePath, ldapConfiguration.keyStorePath) &&
        Objects.equals(this.mailAttributeName, ldapConfiguration.mailAttributeName) &&
        Objects.equals(this.maxPoolSize, ldapConfiguration.maxPoolSize) &&
        Objects.equals(this.port, ldapConfiguration.port) &&
        Objects.equals(this.sslEnabled, ldapConfiguration.sslEnabled) &&
        Objects.equals(this.truststoreFormat, ldapConfiguration.truststoreFormat) &&
        Objects.equals(this.userBaseDN, ldapConfiguration.userBaseDN) &&
        Objects.equals(this.verifyCertificateHostname, ldapConfiguration.verifyCertificateHostname);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dnAdminPassword, dnAdminPrincipal, host, isFullDn, keyStorePassword, keyStorePath, mailAttributeName, maxPoolSize, port, sslEnabled, truststoreFormat, userBaseDN, verifyCertificateHostname);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LdapConfiguration {\n");
    
    sb.append("    dnAdminPassword: ").append(toIndentedString(dnAdminPassword)).append("\n");
    sb.append("    dnAdminPrincipal: ").append(toIndentedString(dnAdminPrincipal)).append("\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("    isFullDn: ").append(toIndentedString(isFullDn)).append("\n");
    sb.append("    keyStorePassword: ").append(toIndentedString(keyStorePassword)).append("\n");
    sb.append("    keyStorePath: ").append(toIndentedString(keyStorePath)).append("\n");
    sb.append("    mailAttributeName: ").append(toIndentedString(mailAttributeName)).append("\n");
    sb.append("    maxPoolSize: ").append(toIndentedString(maxPoolSize)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("    sslEnabled: ").append(toIndentedString(sslEnabled)).append("\n");
    sb.append("    truststoreFormat: ").append(toIndentedString(truststoreFormat)).append("\n");
    sb.append("    userBaseDN: ").append(toIndentedString(userBaseDN)).append("\n");
    sb.append("    verifyCertificateHostname: ").append(toIndentedString(verifyCertificateHostname)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
