/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import org.openmetadata.client.model.ElasticsSearch;
import org.openmetadata.client.model.ExtraHeaders;
/**
 * OpenMetadataConnection
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class OpenMetadataConnection {
  @JsonProperty("apiVersion")
  private String apiVersion = null;

  /**
   * Gets or Sets authProvider
   */
  public enum AuthProviderEnum {
    NO_AUTH("no-auth"),
    AZURE("azure"),
    GOOGLE("google"),
    OKTA("okta"),
    AUTH0("auth0"),
    CUSTOM_OIDC("custom-oidc"),
    OPENMETADATA("openmetadata");

    private String value;

    AuthProviderEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static AuthProviderEnum fromValue(String text) {
      for (AuthProviderEnum b : AuthProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("authProvider")
  private AuthProviderEnum authProvider = null;

  @JsonProperty("clusterName")
  private String clusterName = null;

  @JsonProperty("elasticsSearch")
  private ElasticsSearch elasticsSearch = null;

  @JsonProperty("enableVersionValidation")
  private Boolean enableVersionValidation = null;

  @JsonProperty("extraHeaders")
  private ExtraHeaders extraHeaders = null;

  @JsonProperty("forceEntityOverwriting")
  private Boolean forceEntityOverwriting = null;

  @JsonProperty("hostPort")
  private String hostPort = null;

  @JsonProperty("includeDashboards")
  private Boolean includeDashboards = null;

  @JsonProperty("includeDatabaseServices")
  private Boolean includeDatabaseServices = null;

  @JsonProperty("includeGlossaryTerms")
  private Boolean includeGlossaryTerms = null;

  @JsonProperty("includeMessagingServices")
  private Boolean includeMessagingServices = null;

  @JsonProperty("includeMlModels")
  private Boolean includeMlModels = null;

  @JsonProperty("includePipelineServices")
  private Boolean includePipelineServices = null;

  @JsonProperty("includePipelines")
  private Boolean includePipelines = null;

  @JsonProperty("includePolicy")
  private Boolean includePolicy = null;

  @JsonProperty("includeTables")
  private Boolean includeTables = null;

  @JsonProperty("includeTags")
  private Boolean includeTags = null;

  @JsonProperty("includeTeams")
  private Boolean includeTeams = null;

  @JsonProperty("includeTopics")
  private Boolean includeTopics = null;

  @JsonProperty("includeUsers")
  private Boolean includeUsers = null;

  @JsonProperty("limitRecords")
  private Integer limitRecords = null;

  @JsonProperty("secretsManagerCredentials")
  private Object secretsManagerCredentials = null;

  /**
   * Gets or Sets secretsManagerProvider
   */
  public enum SecretsManagerProviderEnum {
    NOOP("noop"),
    MANAGED_AWS("managed-aws"),
    AWS("aws"),
    MANAGED_AWS_SSM("managed-aws-ssm"),
    AWS_SSM("aws-ssm"),
    IN_MEMORY("in-memory");

    private String value;

    SecretsManagerProviderEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static SecretsManagerProviderEnum fromValue(String text) {
      for (SecretsManagerProviderEnum b : SecretsManagerProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("secretsManagerProvider")
  private SecretsManagerProviderEnum secretsManagerProvider = null;

  @JsonProperty("securityConfig")
  private Object securityConfig = null;

  @JsonProperty("sslConfig")
  private Object sslConfig = null;

  @JsonProperty("supportsDataInsightExtraction")
  private Boolean supportsDataInsightExtraction = null;

  @JsonProperty("supportsElasticSearchReindexingExtraction")
  private Boolean supportsElasticSearchReindexingExtraction = null;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    OPENMETADATA("OpenMetadata");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("type")
  private TypeEnum type = null;

  /**
   * Gets or Sets verifySSL
   */
  public enum VerifySSLEnum {
    NO_SSL("no-ssl"),
    IGNORE("ignore"),
    VALIDATE("validate");

    private String value;

    VerifySSLEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static VerifySSLEnum fromValue(String text) {
      for (VerifySSLEnum b : VerifySSLEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("verifySSL")
  private VerifySSLEnum verifySSL = null;

  public OpenMetadataConnection apiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return this;
  }

   /**
   * Get apiVersion
   * @return apiVersion
  **/
  @Schema(description = "")
  public String getApiVersion() {
    return apiVersion;
  }

  public void setApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
  }

  public OpenMetadataConnection authProvider(AuthProviderEnum authProvider) {
    this.authProvider = authProvider;
    return this;
  }

   /**
   * Get authProvider
   * @return authProvider
  **/
  @Schema(description = "")
  public AuthProviderEnum getAuthProvider() {
    return authProvider;
  }

  public void setAuthProvider(AuthProviderEnum authProvider) {
    this.authProvider = authProvider;
  }

  public OpenMetadataConnection clusterName(String clusterName) {
    this.clusterName = clusterName;
    return this;
  }

   /**
   * Get clusterName
   * @return clusterName
  **/
  @Schema(description = "")
  public String getClusterName() {
    return clusterName;
  }

  public void setClusterName(String clusterName) {
    this.clusterName = clusterName;
  }

  public OpenMetadataConnection elasticsSearch(ElasticsSearch elasticsSearch) {
    this.elasticsSearch = elasticsSearch;
    return this;
  }

   /**
   * Get elasticsSearch
   * @return elasticsSearch
  **/
  @Schema(description = "")
  public ElasticsSearch getElasticsSearch() {
    return elasticsSearch;
  }

  public void setElasticsSearch(ElasticsSearch elasticsSearch) {
    this.elasticsSearch = elasticsSearch;
  }

  public OpenMetadataConnection enableVersionValidation(Boolean enableVersionValidation) {
    this.enableVersionValidation = enableVersionValidation;
    return this;
  }

   /**
   * Get enableVersionValidation
   * @return enableVersionValidation
  **/
  @Schema(description = "")
  public Boolean isEnableVersionValidation() {
    return enableVersionValidation;
  }

  public void setEnableVersionValidation(Boolean enableVersionValidation) {
    this.enableVersionValidation = enableVersionValidation;
  }

  public OpenMetadataConnection extraHeaders(ExtraHeaders extraHeaders) {
    this.extraHeaders = extraHeaders;
    return this;
  }

   /**
   * Get extraHeaders
   * @return extraHeaders
  **/
  @Schema(description = "")
  public ExtraHeaders getExtraHeaders() {
    return extraHeaders;
  }

  public void setExtraHeaders(ExtraHeaders extraHeaders) {
    this.extraHeaders = extraHeaders;
  }

  public OpenMetadataConnection forceEntityOverwriting(Boolean forceEntityOverwriting) {
    this.forceEntityOverwriting = forceEntityOverwriting;
    return this;
  }

   /**
   * Get forceEntityOverwriting
   * @return forceEntityOverwriting
  **/
  @Schema(description = "")
  public Boolean isForceEntityOverwriting() {
    return forceEntityOverwriting;
  }

  public void setForceEntityOverwriting(Boolean forceEntityOverwriting) {
    this.forceEntityOverwriting = forceEntityOverwriting;
  }

  public OpenMetadataConnection hostPort(String hostPort) {
    this.hostPort = hostPort;
    return this;
  }

   /**
   * Get hostPort
   * @return hostPort
  **/
  @Schema(required = true, description = "")
  public String getHostPort() {
    return hostPort;
  }

  public void setHostPort(String hostPort) {
    this.hostPort = hostPort;
  }

  public OpenMetadataConnection includeDashboards(Boolean includeDashboards) {
    this.includeDashboards = includeDashboards;
    return this;
  }

   /**
   * Get includeDashboards
   * @return includeDashboards
  **/
  @Schema(description = "")
  public Boolean isIncludeDashboards() {
    return includeDashboards;
  }

  public void setIncludeDashboards(Boolean includeDashboards) {
    this.includeDashboards = includeDashboards;
  }

  public OpenMetadataConnection includeDatabaseServices(Boolean includeDatabaseServices) {
    this.includeDatabaseServices = includeDatabaseServices;
    return this;
  }

   /**
   * Get includeDatabaseServices
   * @return includeDatabaseServices
  **/
  @Schema(description = "")
  public Boolean isIncludeDatabaseServices() {
    return includeDatabaseServices;
  }

  public void setIncludeDatabaseServices(Boolean includeDatabaseServices) {
    this.includeDatabaseServices = includeDatabaseServices;
  }

  public OpenMetadataConnection includeGlossaryTerms(Boolean includeGlossaryTerms) {
    this.includeGlossaryTerms = includeGlossaryTerms;
    return this;
  }

   /**
   * Get includeGlossaryTerms
   * @return includeGlossaryTerms
  **/
  @Schema(description = "")
  public Boolean isIncludeGlossaryTerms() {
    return includeGlossaryTerms;
  }

  public void setIncludeGlossaryTerms(Boolean includeGlossaryTerms) {
    this.includeGlossaryTerms = includeGlossaryTerms;
  }

  public OpenMetadataConnection includeMessagingServices(Boolean includeMessagingServices) {
    this.includeMessagingServices = includeMessagingServices;
    return this;
  }

   /**
   * Get includeMessagingServices
   * @return includeMessagingServices
  **/
  @Schema(description = "")
  public Boolean isIncludeMessagingServices() {
    return includeMessagingServices;
  }

  public void setIncludeMessagingServices(Boolean includeMessagingServices) {
    this.includeMessagingServices = includeMessagingServices;
  }

  public OpenMetadataConnection includeMlModels(Boolean includeMlModels) {
    this.includeMlModels = includeMlModels;
    return this;
  }

   /**
   * Get includeMlModels
   * @return includeMlModels
  **/
  @Schema(description = "")
  public Boolean isIncludeMlModels() {
    return includeMlModels;
  }

  public void setIncludeMlModels(Boolean includeMlModels) {
    this.includeMlModels = includeMlModels;
  }

  public OpenMetadataConnection includePipelineServices(Boolean includePipelineServices) {
    this.includePipelineServices = includePipelineServices;
    return this;
  }

   /**
   * Get includePipelineServices
   * @return includePipelineServices
  **/
  @Schema(description = "")
  public Boolean isIncludePipelineServices() {
    return includePipelineServices;
  }

  public void setIncludePipelineServices(Boolean includePipelineServices) {
    this.includePipelineServices = includePipelineServices;
  }

  public OpenMetadataConnection includePipelines(Boolean includePipelines) {
    this.includePipelines = includePipelines;
    return this;
  }

   /**
   * Get includePipelines
   * @return includePipelines
  **/
  @Schema(description = "")
  public Boolean isIncludePipelines() {
    return includePipelines;
  }

  public void setIncludePipelines(Boolean includePipelines) {
    this.includePipelines = includePipelines;
  }

  public OpenMetadataConnection includePolicy(Boolean includePolicy) {
    this.includePolicy = includePolicy;
    return this;
  }

   /**
   * Get includePolicy
   * @return includePolicy
  **/
  @Schema(description = "")
  public Boolean isIncludePolicy() {
    return includePolicy;
  }

  public void setIncludePolicy(Boolean includePolicy) {
    this.includePolicy = includePolicy;
  }

  public OpenMetadataConnection includeTables(Boolean includeTables) {
    this.includeTables = includeTables;
    return this;
  }

   /**
   * Get includeTables
   * @return includeTables
  **/
  @Schema(description = "")
  public Boolean isIncludeTables() {
    return includeTables;
  }

  public void setIncludeTables(Boolean includeTables) {
    this.includeTables = includeTables;
  }

  public OpenMetadataConnection includeTags(Boolean includeTags) {
    this.includeTags = includeTags;
    return this;
  }

   /**
   * Get includeTags
   * @return includeTags
  **/
  @Schema(description = "")
  public Boolean isIncludeTags() {
    return includeTags;
  }

  public void setIncludeTags(Boolean includeTags) {
    this.includeTags = includeTags;
  }

  public OpenMetadataConnection includeTeams(Boolean includeTeams) {
    this.includeTeams = includeTeams;
    return this;
  }

   /**
   * Get includeTeams
   * @return includeTeams
  **/
  @Schema(description = "")
  public Boolean isIncludeTeams() {
    return includeTeams;
  }

  public void setIncludeTeams(Boolean includeTeams) {
    this.includeTeams = includeTeams;
  }

  public OpenMetadataConnection includeTopics(Boolean includeTopics) {
    this.includeTopics = includeTopics;
    return this;
  }

   /**
   * Get includeTopics
   * @return includeTopics
  **/
  @Schema(description = "")
  public Boolean isIncludeTopics() {
    return includeTopics;
  }

  public void setIncludeTopics(Boolean includeTopics) {
    this.includeTopics = includeTopics;
  }

  public OpenMetadataConnection includeUsers(Boolean includeUsers) {
    this.includeUsers = includeUsers;
    return this;
  }

   /**
   * Get includeUsers
   * @return includeUsers
  **/
  @Schema(description = "")
  public Boolean isIncludeUsers() {
    return includeUsers;
  }

  public void setIncludeUsers(Boolean includeUsers) {
    this.includeUsers = includeUsers;
  }

  public OpenMetadataConnection limitRecords(Integer limitRecords) {
    this.limitRecords = limitRecords;
    return this;
  }

   /**
   * Get limitRecords
   * @return limitRecords
  **/
  @Schema(description = "")
  public Integer getLimitRecords() {
    return limitRecords;
  }

  public void setLimitRecords(Integer limitRecords) {
    this.limitRecords = limitRecords;
  }

  public OpenMetadataConnection secretsManagerCredentials(Object secretsManagerCredentials) {
    this.secretsManagerCredentials = secretsManagerCredentials;
    return this;
  }

   /**
   * Get secretsManagerCredentials
   * @return secretsManagerCredentials
  **/
  @Schema(description = "")
  public Object getSecretsManagerCredentials() {
    return secretsManagerCredentials;
  }

  public void setSecretsManagerCredentials(Object secretsManagerCredentials) {
    this.secretsManagerCredentials = secretsManagerCredentials;
  }

  public OpenMetadataConnection secretsManagerProvider(SecretsManagerProviderEnum secretsManagerProvider) {
    this.secretsManagerProvider = secretsManagerProvider;
    return this;
  }

   /**
   * Get secretsManagerProvider
   * @return secretsManagerProvider
  **/
  @Schema(description = "")
  public SecretsManagerProviderEnum getSecretsManagerProvider() {
    return secretsManagerProvider;
  }

  public void setSecretsManagerProvider(SecretsManagerProviderEnum secretsManagerProvider) {
    this.secretsManagerProvider = secretsManagerProvider;
  }

  public OpenMetadataConnection securityConfig(Object securityConfig) {
    this.securityConfig = securityConfig;
    return this;
  }

   /**
   * Get securityConfig
   * @return securityConfig
  **/
  @Schema(description = "")
  public Object getSecurityConfig() {
    return securityConfig;
  }

  public void setSecurityConfig(Object securityConfig) {
    this.securityConfig = securityConfig;
  }

  public OpenMetadataConnection sslConfig(Object sslConfig) {
    this.sslConfig = sslConfig;
    return this;
  }

   /**
   * Get sslConfig
   * @return sslConfig
  **/
  @Schema(description = "")
  public Object getSslConfig() {
    return sslConfig;
  }

  public void setSslConfig(Object sslConfig) {
    this.sslConfig = sslConfig;
  }

  public OpenMetadataConnection supportsDataInsightExtraction(Boolean supportsDataInsightExtraction) {
    this.supportsDataInsightExtraction = supportsDataInsightExtraction;
    return this;
  }

   /**
   * Get supportsDataInsightExtraction
   * @return supportsDataInsightExtraction
  **/
  @Schema(description = "")
  public Boolean isSupportsDataInsightExtraction() {
    return supportsDataInsightExtraction;
  }

  public void setSupportsDataInsightExtraction(Boolean supportsDataInsightExtraction) {
    this.supportsDataInsightExtraction = supportsDataInsightExtraction;
  }

  public OpenMetadataConnection supportsElasticSearchReindexingExtraction(Boolean supportsElasticSearchReindexingExtraction) {
    this.supportsElasticSearchReindexingExtraction = supportsElasticSearchReindexingExtraction;
    return this;
  }

   /**
   * Get supportsElasticSearchReindexingExtraction
   * @return supportsElasticSearchReindexingExtraction
  **/
  @Schema(description = "")
  public Boolean isSupportsElasticSearchReindexingExtraction() {
    return supportsElasticSearchReindexingExtraction;
  }

  public void setSupportsElasticSearchReindexingExtraction(Boolean supportsElasticSearchReindexingExtraction) {
    this.supportsElasticSearchReindexingExtraction = supportsElasticSearchReindexingExtraction;
  }

  public OpenMetadataConnection type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @Schema(description = "")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public OpenMetadataConnection verifySSL(VerifySSLEnum verifySSL) {
    this.verifySSL = verifySSL;
    return this;
  }

   /**
   * Get verifySSL
   * @return verifySSL
  **/
  @Schema(description = "")
  public VerifySSLEnum getVerifySSL() {
    return verifySSL;
  }

  public void setVerifySSL(VerifySSLEnum verifySSL) {
    this.verifySSL = verifySSL;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OpenMetadataConnection openMetadataConnection = (OpenMetadataConnection) o;
    return Objects.equals(this.apiVersion, openMetadataConnection.apiVersion) &&
        Objects.equals(this.authProvider, openMetadataConnection.authProvider) &&
        Objects.equals(this.clusterName, openMetadataConnection.clusterName) &&
        Objects.equals(this.elasticsSearch, openMetadataConnection.elasticsSearch) &&
        Objects.equals(this.enableVersionValidation, openMetadataConnection.enableVersionValidation) &&
        Objects.equals(this.extraHeaders, openMetadataConnection.extraHeaders) &&
        Objects.equals(this.forceEntityOverwriting, openMetadataConnection.forceEntityOverwriting) &&
        Objects.equals(this.hostPort, openMetadataConnection.hostPort) &&
        Objects.equals(this.includeDashboards, openMetadataConnection.includeDashboards) &&
        Objects.equals(this.includeDatabaseServices, openMetadataConnection.includeDatabaseServices) &&
        Objects.equals(this.includeGlossaryTerms, openMetadataConnection.includeGlossaryTerms) &&
        Objects.equals(this.includeMessagingServices, openMetadataConnection.includeMessagingServices) &&
        Objects.equals(this.includeMlModels, openMetadataConnection.includeMlModels) &&
        Objects.equals(this.includePipelineServices, openMetadataConnection.includePipelineServices) &&
        Objects.equals(this.includePipelines, openMetadataConnection.includePipelines) &&
        Objects.equals(this.includePolicy, openMetadataConnection.includePolicy) &&
        Objects.equals(this.includeTables, openMetadataConnection.includeTables) &&
        Objects.equals(this.includeTags, openMetadataConnection.includeTags) &&
        Objects.equals(this.includeTeams, openMetadataConnection.includeTeams) &&
        Objects.equals(this.includeTopics, openMetadataConnection.includeTopics) &&
        Objects.equals(this.includeUsers, openMetadataConnection.includeUsers) &&
        Objects.equals(this.limitRecords, openMetadataConnection.limitRecords) &&
        Objects.equals(this.secretsManagerCredentials, openMetadataConnection.secretsManagerCredentials) &&
        Objects.equals(this.secretsManagerProvider, openMetadataConnection.secretsManagerProvider) &&
        Objects.equals(this.securityConfig, openMetadataConnection.securityConfig) &&
        Objects.equals(this.sslConfig, openMetadataConnection.sslConfig) &&
        Objects.equals(this.supportsDataInsightExtraction, openMetadataConnection.supportsDataInsightExtraction) &&
        Objects.equals(this.supportsElasticSearchReindexingExtraction, openMetadataConnection.supportsElasticSearchReindexingExtraction) &&
        Objects.equals(this.type, openMetadataConnection.type) &&
        Objects.equals(this.verifySSL, openMetadataConnection.verifySSL);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apiVersion, authProvider, clusterName, elasticsSearch, enableVersionValidation, extraHeaders, forceEntityOverwriting, hostPort, includeDashboards, includeDatabaseServices, includeGlossaryTerms, includeMessagingServices, includeMlModels, includePipelineServices, includePipelines, includePolicy, includeTables, includeTags, includeTeams, includeTopics, includeUsers, limitRecords, secretsManagerCredentials, secretsManagerProvider, securityConfig, sslConfig, supportsDataInsightExtraction, supportsElasticSearchReindexingExtraction, type, verifySSL);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OpenMetadataConnection {\n");
    
    sb.append("    apiVersion: ").append(toIndentedString(apiVersion)).append("\n");
    sb.append("    authProvider: ").append(toIndentedString(authProvider)).append("\n");
    sb.append("    clusterName: ").append(toIndentedString(clusterName)).append("\n");
    sb.append("    elasticsSearch: ").append(toIndentedString(elasticsSearch)).append("\n");
    sb.append("    enableVersionValidation: ").append(toIndentedString(enableVersionValidation)).append("\n");
    sb.append("    extraHeaders: ").append(toIndentedString(extraHeaders)).append("\n");
    sb.append("    forceEntityOverwriting: ").append(toIndentedString(forceEntityOverwriting)).append("\n");
    sb.append("    hostPort: ").append(toIndentedString(hostPort)).append("\n");
    sb.append("    includeDashboards: ").append(toIndentedString(includeDashboards)).append("\n");
    sb.append("    includeDatabaseServices: ").append(toIndentedString(includeDatabaseServices)).append("\n");
    sb.append("    includeGlossaryTerms: ").append(toIndentedString(includeGlossaryTerms)).append("\n");
    sb.append("    includeMessagingServices: ").append(toIndentedString(includeMessagingServices)).append("\n");
    sb.append("    includeMlModels: ").append(toIndentedString(includeMlModels)).append("\n");
    sb.append("    includePipelineServices: ").append(toIndentedString(includePipelineServices)).append("\n");
    sb.append("    includePipelines: ").append(toIndentedString(includePipelines)).append("\n");
    sb.append("    includePolicy: ").append(toIndentedString(includePolicy)).append("\n");
    sb.append("    includeTables: ").append(toIndentedString(includeTables)).append("\n");
    sb.append("    includeTags: ").append(toIndentedString(includeTags)).append("\n");
    sb.append("    includeTeams: ").append(toIndentedString(includeTeams)).append("\n");
    sb.append("    includeTopics: ").append(toIndentedString(includeTopics)).append("\n");
    sb.append("    includeUsers: ").append(toIndentedString(includeUsers)).append("\n");
    sb.append("    limitRecords: ").append(toIndentedString(limitRecords)).append("\n");
    sb.append("    secretsManagerCredentials: ").append(toIndentedString(secretsManagerCredentials)).append("\n");
    sb.append("    secretsManagerProvider: ").append(toIndentedString(secretsManagerProvider)).append("\n");
    sb.append("    securityConfig: ").append(toIndentedString(securityConfig)).append("\n");
    sb.append("    sslConfig: ").append(toIndentedString(sslConfig)).append("\n");
    sb.append("    supportsDataInsightExtraction: ").append(toIndentedString(supportsDataInsightExtraction)).append("\n");
    sb.append("    supportsElasticSearchReindexingExtraction: ").append(toIndentedString(supportsElasticSearchReindexingExtraction)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    verifySSL: ").append(toIndentedString(verifySSL)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
