/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
/**
 * PartitionProfilerConfig
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class PartitionProfilerConfig {
  @JsonProperty("enablePartitioning")
  private Boolean enablePartitioning = null;

  @JsonProperty("partitionColumnName")
  private String partitionColumnName = null;

  @JsonProperty("partitionInterval")
  private Integer partitionInterval = null;

  /**
   * Gets or Sets partitionIntervalType
   */
  public enum PartitionIntervalTypeEnum {
    TIME_UNIT("TIME-UNIT"),
    INGESTION_TIME("INGESTION-TIME");

    private String value;

    PartitionIntervalTypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static PartitionIntervalTypeEnum fromValue(String text) {
      for (PartitionIntervalTypeEnum b : PartitionIntervalTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("partitionIntervalType")
  private PartitionIntervalTypeEnum partitionIntervalType = null;

  /**
   * Gets or Sets partitionIntervalUnit
   */
  public enum PartitionIntervalUnitEnum {
    YEAR("YEAR"),
    MONTH("MONTH"),
    DAY("DAY"),
    HOUR("HOUR");

    private String value;

    PartitionIntervalUnitEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static PartitionIntervalUnitEnum fromValue(String text) {
      for (PartitionIntervalUnitEnum b : PartitionIntervalUnitEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("partitionIntervalUnit")
  private PartitionIntervalUnitEnum partitionIntervalUnit = null;

  @JsonProperty("partitionValues")
  private List<Object> partitionValues = null;

  public PartitionProfilerConfig enablePartitioning(Boolean enablePartitioning) {
    this.enablePartitioning = enablePartitioning;
    return this;
  }

   /**
   * Get enablePartitioning
   * @return enablePartitioning
  **/
  @Schema(description = "")
  public Boolean isEnablePartitioning() {
    return enablePartitioning;
  }

  public void setEnablePartitioning(Boolean enablePartitioning) {
    this.enablePartitioning = enablePartitioning;
  }

  public PartitionProfilerConfig partitionColumnName(String partitionColumnName) {
    this.partitionColumnName = partitionColumnName;
    return this;
  }

   /**
   * Get partitionColumnName
   * @return partitionColumnName
  **/
  @Schema(description = "")
  public String getPartitionColumnName() {
    return partitionColumnName;
  }

  public void setPartitionColumnName(String partitionColumnName) {
    this.partitionColumnName = partitionColumnName;
  }

  public PartitionProfilerConfig partitionInterval(Integer partitionInterval) {
    this.partitionInterval = partitionInterval;
    return this;
  }

   /**
   * Get partitionInterval
   * @return partitionInterval
  **/
  @Schema(description = "")
  public Integer getPartitionInterval() {
    return partitionInterval;
  }

  public void setPartitionInterval(Integer partitionInterval) {
    this.partitionInterval = partitionInterval;
  }

  public PartitionProfilerConfig partitionIntervalType(PartitionIntervalTypeEnum partitionIntervalType) {
    this.partitionIntervalType = partitionIntervalType;
    return this;
  }

   /**
   * Get partitionIntervalType
   * @return partitionIntervalType
  **/
  @Schema(description = "")
  public PartitionIntervalTypeEnum getPartitionIntervalType() {
    return partitionIntervalType;
  }

  public void setPartitionIntervalType(PartitionIntervalTypeEnum partitionIntervalType) {
    this.partitionIntervalType = partitionIntervalType;
  }

  public PartitionProfilerConfig partitionIntervalUnit(PartitionIntervalUnitEnum partitionIntervalUnit) {
    this.partitionIntervalUnit = partitionIntervalUnit;
    return this;
  }

   /**
   * Get partitionIntervalUnit
   * @return partitionIntervalUnit
  **/
  @Schema(description = "")
  public PartitionIntervalUnitEnum getPartitionIntervalUnit() {
    return partitionIntervalUnit;
  }

  public void setPartitionIntervalUnit(PartitionIntervalUnitEnum partitionIntervalUnit) {
    this.partitionIntervalUnit = partitionIntervalUnit;
  }

  public PartitionProfilerConfig partitionValues(List<Object> partitionValues) {
    this.partitionValues = partitionValues;
    return this;
  }

  public PartitionProfilerConfig addPartitionValuesItem(Object partitionValuesItem) {
    if (this.partitionValues == null) {
      this.partitionValues = new ArrayList<Object>();
    }
    this.partitionValues.add(partitionValuesItem);
    return this;
  }

   /**
   * Get partitionValues
   * @return partitionValues
  **/
  @Schema(description = "")
  public List<Object> getPartitionValues() {
    return partitionValues;
  }

  public void setPartitionValues(List<Object> partitionValues) {
    this.partitionValues = partitionValues;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PartitionProfilerConfig partitionProfilerConfig = (PartitionProfilerConfig) o;
    return Objects.equals(this.enablePartitioning, partitionProfilerConfig.enablePartitioning) &&
        Objects.equals(this.partitionColumnName, partitionProfilerConfig.partitionColumnName) &&
        Objects.equals(this.partitionInterval, partitionProfilerConfig.partitionInterval) &&
        Objects.equals(this.partitionIntervalType, partitionProfilerConfig.partitionIntervalType) &&
        Objects.equals(this.partitionIntervalUnit, partitionProfilerConfig.partitionIntervalUnit) &&
        Objects.equals(this.partitionValues, partitionProfilerConfig.partitionValues);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enablePartitioning, partitionColumnName, partitionInterval, partitionIntervalType, partitionIntervalUnit, partitionValues);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PartitionProfilerConfig {\n");
    
    sb.append("    enablePartitioning: ").append(toIndentedString(enablePartitioning)).append("\n");
    sb.append("    partitionColumnName: ").append(toIndentedString(partitionColumnName)).append("\n");
    sb.append("    partitionInterval: ").append(toIndentedString(partitionInterval)).append("\n");
    sb.append("    partitionIntervalType: ").append(toIndentedString(partitionIntervalType)).append("\n");
    sb.append("    partitionIntervalUnit: ").append(toIndentedString(partitionIntervalUnit)).append("\n");
    sb.append("    partitionValues: ").append(toIndentedString(partitionValues)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
