/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmetadata.client.model.BytesReference;
import org.openmetadata.client.model.DocumentField;
import org.openmetadata.client.model.Explanation;
import org.openmetadata.client.model.HighlightField;
import org.openmetadata.client.model.NestedIdentity;
import org.openmetadata.client.model.SearchHits;
import org.openmetadata.client.model.SearchShardTarget;
/**
 * SearchHit
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class SearchHit {
  @JsonProperty("clusterAlias")
  private String clusterAlias = null;

  @JsonProperty("explanation")
  private Explanation explanation = null;

  @JsonProperty("fields")
  private Map<String, DocumentField> fields = null;

  @JsonProperty("fragment")
  private Boolean fragment = null;

  @JsonProperty("highlightFields")
  private Map<String, HighlightField> highlightFields = null;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("index")
  private String index = null;

  @JsonProperty("innerHits")
  private Map<String, SearchHits> innerHits = null;

  @JsonProperty("matchedQueries")
  private List<String> matchedQueries = null;

  @JsonProperty("nestedIdentity")
  private NestedIdentity nestedIdentity = null;

  @JsonProperty("primaryTerm")
  private Long primaryTerm = null;

  @JsonProperty("rawSortValues")
  private List<Object> rawSortValues = null;

  @JsonProperty("score")
  private Float score = null;

  @JsonProperty("seqNo")
  private Long seqNo = null;

  @JsonProperty("shard")
  private SearchShardTarget shard = null;

  @JsonProperty("sortValues")
  private List<Object> sortValues = null;

  @JsonProperty("sourceAsMap")
  private Map<String, Object> sourceAsMap = null;

  @JsonProperty("sourceAsString")
  private String sourceAsString = null;

  @JsonProperty("sourceRef")
  private BytesReference sourceRef = null;

  @JsonProperty("type")
  private String type = null;

  @JsonProperty("version")
  private Long version = null;

  public SearchHit clusterAlias(String clusterAlias) {
    this.clusterAlias = clusterAlias;
    return this;
  }

   /**
   * Get clusterAlias
   * @return clusterAlias
  **/
  @Schema(description = "")
  public String getClusterAlias() {
    return clusterAlias;
  }

  public void setClusterAlias(String clusterAlias) {
    this.clusterAlias = clusterAlias;
  }

  public SearchHit explanation(Explanation explanation) {
    this.explanation = explanation;
    return this;
  }

   /**
   * Get explanation
   * @return explanation
  **/
  @Schema(description = "")
  public Explanation getExplanation() {
    return explanation;
  }

  public void setExplanation(Explanation explanation) {
    this.explanation = explanation;
  }

  public SearchHit fields(Map<String, DocumentField> fields) {
    this.fields = fields;
    return this;
  }

  public SearchHit putFieldsItem(String key, DocumentField fieldsItem) {
    if (this.fields == null) {
      this.fields = new HashMap<String, DocumentField>();
    }
    this.fields.put(key, fieldsItem);
    return this;
  }

   /**
   * Get fields
   * @return fields
  **/
  @Schema(description = "")
  public Map<String, DocumentField> getFields() {
    return fields;
  }

  public void setFields(Map<String, DocumentField> fields) {
    this.fields = fields;
  }

  public SearchHit fragment(Boolean fragment) {
    this.fragment = fragment;
    return this;
  }

   /**
   * Get fragment
   * @return fragment
  **/
  @Schema(description = "")
  public Boolean isFragment() {
    return fragment;
  }

  public void setFragment(Boolean fragment) {
    this.fragment = fragment;
  }

  public SearchHit highlightFields(Map<String, HighlightField> highlightFields) {
    this.highlightFields = highlightFields;
    return this;
  }

  public SearchHit putHighlightFieldsItem(String key, HighlightField highlightFieldsItem) {
    if (this.highlightFields == null) {
      this.highlightFields = new HashMap<String, HighlightField>();
    }
    this.highlightFields.put(key, highlightFieldsItem);
    return this;
  }

   /**
   * Get highlightFields
   * @return highlightFields
  **/
  @Schema(description = "")
  public Map<String, HighlightField> getHighlightFields() {
    return highlightFields;
  }

  public void setHighlightFields(Map<String, HighlightField> highlightFields) {
    this.highlightFields = highlightFields;
  }

  public SearchHit id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(description = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public SearchHit index(String index) {
    this.index = index;
    return this;
  }

   /**
   * Get index
   * @return index
  **/
  @Schema(description = "")
  public String getIndex() {
    return index;
  }

  public void setIndex(String index) {
    this.index = index;
  }

  public SearchHit innerHits(Map<String, SearchHits> innerHits) {
    this.innerHits = innerHits;
    return this;
  }

  public SearchHit putInnerHitsItem(String key, SearchHits innerHitsItem) {
    if (this.innerHits == null) {
      this.innerHits = new HashMap<String, SearchHits>();
    }
    this.innerHits.put(key, innerHitsItem);
    return this;
  }

   /**
   * Get innerHits
   * @return innerHits
  **/
  @Schema(description = "")
  public Map<String, SearchHits> getInnerHits() {
    return innerHits;
  }

  public void setInnerHits(Map<String, SearchHits> innerHits) {
    this.innerHits = innerHits;
  }

  public SearchHit matchedQueries(List<String> matchedQueries) {
    this.matchedQueries = matchedQueries;
    return this;
  }

  public SearchHit addMatchedQueriesItem(String matchedQueriesItem) {
    if (this.matchedQueries == null) {
      this.matchedQueries = new ArrayList<String>();
    }
    this.matchedQueries.add(matchedQueriesItem);
    return this;
  }

   /**
   * Get matchedQueries
   * @return matchedQueries
  **/
  @Schema(description = "")
  public List<String> getMatchedQueries() {
    return matchedQueries;
  }

  public void setMatchedQueries(List<String> matchedQueries) {
    this.matchedQueries = matchedQueries;
  }

  public SearchHit nestedIdentity(NestedIdentity nestedIdentity) {
    this.nestedIdentity = nestedIdentity;
    return this;
  }

   /**
   * Get nestedIdentity
   * @return nestedIdentity
  **/
  @Schema(description = "")
  public NestedIdentity getNestedIdentity() {
    return nestedIdentity;
  }

  public void setNestedIdentity(NestedIdentity nestedIdentity) {
    this.nestedIdentity = nestedIdentity;
  }

  public SearchHit primaryTerm(Long primaryTerm) {
    this.primaryTerm = primaryTerm;
    return this;
  }

   /**
   * Get primaryTerm
   * @return primaryTerm
  **/
  @Schema(description = "")
  public Long getPrimaryTerm() {
    return primaryTerm;
  }

  public void setPrimaryTerm(Long primaryTerm) {
    this.primaryTerm = primaryTerm;
  }

  public SearchHit rawSortValues(List<Object> rawSortValues) {
    this.rawSortValues = rawSortValues;
    return this;
  }

  public SearchHit addRawSortValuesItem(Object rawSortValuesItem) {
    if (this.rawSortValues == null) {
      this.rawSortValues = new ArrayList<Object>();
    }
    this.rawSortValues.add(rawSortValuesItem);
    return this;
  }

   /**
   * Get rawSortValues
   * @return rawSortValues
  **/
  @Schema(description = "")
  public List<Object> getRawSortValues() {
    return rawSortValues;
  }

  public void setRawSortValues(List<Object> rawSortValues) {
    this.rawSortValues = rawSortValues;
  }

  public SearchHit score(Float score) {
    this.score = score;
    return this;
  }

   /**
   * Get score
   * @return score
  **/
  @Schema(description = "")
  public Float getScore() {
    return score;
  }

  public void setScore(Float score) {
    this.score = score;
  }

  public SearchHit seqNo(Long seqNo) {
    this.seqNo = seqNo;
    return this;
  }

   /**
   * Get seqNo
   * @return seqNo
  **/
  @Schema(description = "")
  public Long getSeqNo() {
    return seqNo;
  }

  public void setSeqNo(Long seqNo) {
    this.seqNo = seqNo;
  }

  public SearchHit shard(SearchShardTarget shard) {
    this.shard = shard;
    return this;
  }

   /**
   * Get shard
   * @return shard
  **/
  @Schema(description = "")
  public SearchShardTarget getShard() {
    return shard;
  }

  public void setShard(SearchShardTarget shard) {
    this.shard = shard;
  }

  public SearchHit sortValues(List<Object> sortValues) {
    this.sortValues = sortValues;
    return this;
  }

  public SearchHit addSortValuesItem(Object sortValuesItem) {
    if (this.sortValues == null) {
      this.sortValues = new ArrayList<Object>();
    }
    this.sortValues.add(sortValuesItem);
    return this;
  }

   /**
   * Get sortValues
   * @return sortValues
  **/
  @Schema(description = "")
  public List<Object> getSortValues() {
    return sortValues;
  }

  public void setSortValues(List<Object> sortValues) {
    this.sortValues = sortValues;
  }

  public SearchHit sourceAsMap(Map<String, Object> sourceAsMap) {
    this.sourceAsMap = sourceAsMap;
    return this;
  }

  public SearchHit putSourceAsMapItem(String key, Object sourceAsMapItem) {
    if (this.sourceAsMap == null) {
      this.sourceAsMap = new HashMap<String, Object>();
    }
    this.sourceAsMap.put(key, sourceAsMapItem);
    return this;
  }

   /**
   * Get sourceAsMap
   * @return sourceAsMap
  **/
  @Schema(description = "")
  public Map<String, Object> getSourceAsMap() {
    return sourceAsMap;
  }

  public void setSourceAsMap(Map<String, Object> sourceAsMap) {
    this.sourceAsMap = sourceAsMap;
  }

  public SearchHit sourceAsString(String sourceAsString) {
    this.sourceAsString = sourceAsString;
    return this;
  }

   /**
   * Get sourceAsString
   * @return sourceAsString
  **/
  @Schema(description = "")
  public String getSourceAsString() {
    return sourceAsString;
  }

  public void setSourceAsString(String sourceAsString) {
    this.sourceAsString = sourceAsString;
  }

  public SearchHit sourceRef(BytesReference sourceRef) {
    this.sourceRef = sourceRef;
    return this;
  }

   /**
   * Get sourceRef
   * @return sourceRef
  **/
  @Schema(description = "")
  public BytesReference getSourceRef() {
    return sourceRef;
  }

  public void setSourceRef(BytesReference sourceRef) {
    this.sourceRef = sourceRef;
  }

  public SearchHit type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @Schema(description = "")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public SearchHit version(Long version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @Schema(description = "")
  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchHit searchHit = (SearchHit) o;
    return Objects.equals(this.clusterAlias, searchHit.clusterAlias) &&
        Objects.equals(this.explanation, searchHit.explanation) &&
        Objects.equals(this.fields, searchHit.fields) &&
        Objects.equals(this.fragment, searchHit.fragment) &&
        Objects.equals(this.highlightFields, searchHit.highlightFields) &&
        Objects.equals(this.id, searchHit.id) &&
        Objects.equals(this.index, searchHit.index) &&
        Objects.equals(this.innerHits, searchHit.innerHits) &&
        Objects.equals(this.matchedQueries, searchHit.matchedQueries) &&
        Objects.equals(this.nestedIdentity, searchHit.nestedIdentity) &&
        Objects.equals(this.primaryTerm, searchHit.primaryTerm) &&
        Objects.equals(this.rawSortValues, searchHit.rawSortValues) &&
        Objects.equals(this.score, searchHit.score) &&
        Objects.equals(this.seqNo, searchHit.seqNo) &&
        Objects.equals(this.shard, searchHit.shard) &&
        Objects.equals(this.sortValues, searchHit.sortValues) &&
        Objects.equals(this.sourceAsMap, searchHit.sourceAsMap) &&
        Objects.equals(this.sourceAsString, searchHit.sourceAsString) &&
        Objects.equals(this.sourceRef, searchHit.sourceRef) &&
        Objects.equals(this.type, searchHit.type) &&
        Objects.equals(this.version, searchHit.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clusterAlias, explanation, fields, fragment, highlightFields, id, index, innerHits, matchedQueries, nestedIdentity, primaryTerm, rawSortValues, score, seqNo, shard, sortValues, sourceAsMap, sourceAsString, sourceRef, type, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchHit {\n");
    
    sb.append("    clusterAlias: ").append(toIndentedString(clusterAlias)).append("\n");
    sb.append("    explanation: ").append(toIndentedString(explanation)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    fragment: ").append(toIndentedString(fragment)).append("\n");
    sb.append("    highlightFields: ").append(toIndentedString(highlightFields)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    index: ").append(toIndentedString(index)).append("\n");
    sb.append("    innerHits: ").append(toIndentedString(innerHits)).append("\n");
    sb.append("    matchedQueries: ").append(toIndentedString(matchedQueries)).append("\n");
    sb.append("    nestedIdentity: ").append(toIndentedString(nestedIdentity)).append("\n");
    sb.append("    primaryTerm: ").append(toIndentedString(primaryTerm)).append("\n");
    sb.append("    rawSortValues: ").append(toIndentedString(rawSortValues)).append("\n");
    sb.append("    score: ").append(toIndentedString(score)).append("\n");
    sb.append("    seqNo: ").append(toIndentedString(seqNo)).append("\n");
    sb.append("    shard: ").append(toIndentedString(shard)).append("\n");
    sb.append("    sortValues: ").append(toIndentedString(sortValues)).append("\n");
    sb.append("    sourceAsMap: ").append(toIndentedString(sourceAsMap)).append("\n");
    sb.append("    sourceAsString: ").append(toIndentedString(sourceAsString)).append("\n");
    sb.append("    sourceRef: ").append(toIndentedString(sourceRef)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
