/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmetadata.client.model.Aggregations;
import org.openmetadata.client.model.Clusters;
import org.openmetadata.client.model.ProfileShardResult;
import org.openmetadata.client.model.SearchHits;
import org.openmetadata.client.model.SearchResponseSections;
import org.openmetadata.client.model.ShardSearchFailure;
import org.openmetadata.client.model.Suggest;
import org.openmetadata.client.model.TimeValue;
/**
 * SearchResponse
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class SearchResponse {
  @JsonProperty("aggregations")
  private Aggregations aggregations = null;

  @JsonProperty("clusters")
  private Clusters clusters = null;

  @JsonProperty("failedShards")
  private Integer failedShards = null;

  @JsonProperty("fragment")
  private Boolean fragment = null;

  @JsonProperty("hits")
  private SearchHits hits = null;

  @JsonProperty("internalResponse")
  private SearchResponseSections internalResponse = null;

  @JsonProperty("numReducePhases")
  private Integer numReducePhases = null;

  @JsonProperty("profileResults")
  private Map<String, ProfileShardResult> profileResults = null;

  @JsonProperty("scrollId")
  private String scrollId = null;

  @JsonProperty("shardFailures")
  private List<ShardSearchFailure> shardFailures = null;

  @JsonProperty("skippedShards")
  private Integer skippedShards = null;

  @JsonProperty("successfulShards")
  private Integer successfulShards = null;

  @JsonProperty("suggest")
  private Suggest suggest = null;

  @JsonProperty("terminatedEarly")
  private Boolean terminatedEarly = null;

  @JsonProperty("timedOut")
  private Boolean timedOut = null;

  @JsonProperty("took")
  private TimeValue took = null;

  @JsonProperty("totalShards")
  private Integer totalShards = null;

  public SearchResponse aggregations(Aggregations aggregations) {
    this.aggregations = aggregations;
    return this;
  }

   /**
   * Get aggregations
   * @return aggregations
  **/
  @Schema(description = "")
  public Aggregations getAggregations() {
    return aggregations;
  }

  public void setAggregations(Aggregations aggregations) {
    this.aggregations = aggregations;
  }

  public SearchResponse clusters(Clusters clusters) {
    this.clusters = clusters;
    return this;
  }

   /**
   * Get clusters
   * @return clusters
  **/
  @Schema(description = "")
  public Clusters getClusters() {
    return clusters;
  }

  public void setClusters(Clusters clusters) {
    this.clusters = clusters;
  }

  public SearchResponse failedShards(Integer failedShards) {
    this.failedShards = failedShards;
    return this;
  }

   /**
   * Get failedShards
   * @return failedShards
  **/
  @Schema(description = "")
  public Integer getFailedShards() {
    return failedShards;
  }

  public void setFailedShards(Integer failedShards) {
    this.failedShards = failedShards;
  }

  public SearchResponse fragment(Boolean fragment) {
    this.fragment = fragment;
    return this;
  }

   /**
   * Get fragment
   * @return fragment
  **/
  @Schema(description = "")
  public Boolean isFragment() {
    return fragment;
  }

  public void setFragment(Boolean fragment) {
    this.fragment = fragment;
  }

  public SearchResponse hits(SearchHits hits) {
    this.hits = hits;
    return this;
  }

   /**
   * Get hits
   * @return hits
  **/
  @Schema(description = "")
  public SearchHits getHits() {
    return hits;
  }

  public void setHits(SearchHits hits) {
    this.hits = hits;
  }

  public SearchResponse internalResponse(SearchResponseSections internalResponse) {
    this.internalResponse = internalResponse;
    return this;
  }

   /**
   * Get internalResponse
   * @return internalResponse
  **/
  @Schema(description = "")
  public SearchResponseSections getInternalResponse() {
    return internalResponse;
  }

  public void setInternalResponse(SearchResponseSections internalResponse) {
    this.internalResponse = internalResponse;
  }

  public SearchResponse numReducePhases(Integer numReducePhases) {
    this.numReducePhases = numReducePhases;
    return this;
  }

   /**
   * Get numReducePhases
   * @return numReducePhases
  **/
  @Schema(description = "")
  public Integer getNumReducePhases() {
    return numReducePhases;
  }

  public void setNumReducePhases(Integer numReducePhases) {
    this.numReducePhases = numReducePhases;
  }

  public SearchResponse profileResults(Map<String, ProfileShardResult> profileResults) {
    this.profileResults = profileResults;
    return this;
  }

  public SearchResponse putProfileResultsItem(String key, ProfileShardResult profileResultsItem) {
    if (this.profileResults == null) {
      this.profileResults = new HashMap<String, ProfileShardResult>();
    }
    this.profileResults.put(key, profileResultsItem);
    return this;
  }

   /**
   * Get profileResults
   * @return profileResults
  **/
  @Schema(description = "")
  public Map<String, ProfileShardResult> getProfileResults() {
    return profileResults;
  }

  public void setProfileResults(Map<String, ProfileShardResult> profileResults) {
    this.profileResults = profileResults;
  }

  public SearchResponse scrollId(String scrollId) {
    this.scrollId = scrollId;
    return this;
  }

   /**
   * Get scrollId
   * @return scrollId
  **/
  @Schema(description = "")
  public String getScrollId() {
    return scrollId;
  }

  public void setScrollId(String scrollId) {
    this.scrollId = scrollId;
  }

  public SearchResponse shardFailures(List<ShardSearchFailure> shardFailures) {
    this.shardFailures = shardFailures;
    return this;
  }

  public SearchResponse addShardFailuresItem(ShardSearchFailure shardFailuresItem) {
    if (this.shardFailures == null) {
      this.shardFailures = new ArrayList<ShardSearchFailure>();
    }
    this.shardFailures.add(shardFailuresItem);
    return this;
  }

   /**
   * Get shardFailures
   * @return shardFailures
  **/
  @Schema(description = "")
  public List<ShardSearchFailure> getShardFailures() {
    return shardFailures;
  }

  public void setShardFailures(List<ShardSearchFailure> shardFailures) {
    this.shardFailures = shardFailures;
  }

  public SearchResponse skippedShards(Integer skippedShards) {
    this.skippedShards = skippedShards;
    return this;
  }

   /**
   * Get skippedShards
   * @return skippedShards
  **/
  @Schema(description = "")
  public Integer getSkippedShards() {
    return skippedShards;
  }

  public void setSkippedShards(Integer skippedShards) {
    this.skippedShards = skippedShards;
  }

  public SearchResponse successfulShards(Integer successfulShards) {
    this.successfulShards = successfulShards;
    return this;
  }

   /**
   * Get successfulShards
   * @return successfulShards
  **/
  @Schema(description = "")
  public Integer getSuccessfulShards() {
    return successfulShards;
  }

  public void setSuccessfulShards(Integer successfulShards) {
    this.successfulShards = successfulShards;
  }

  public SearchResponse suggest(Suggest suggest) {
    this.suggest = suggest;
    return this;
  }

   /**
   * Get suggest
   * @return suggest
  **/
  @Schema(description = "")
  public Suggest getSuggest() {
    return suggest;
  }

  public void setSuggest(Suggest suggest) {
    this.suggest = suggest;
  }

  public SearchResponse terminatedEarly(Boolean terminatedEarly) {
    this.terminatedEarly = terminatedEarly;
    return this;
  }

   /**
   * Get terminatedEarly
   * @return terminatedEarly
  **/
  @Schema(description = "")
  public Boolean isTerminatedEarly() {
    return terminatedEarly;
  }

  public void setTerminatedEarly(Boolean terminatedEarly) {
    this.terminatedEarly = terminatedEarly;
  }

  public SearchResponse timedOut(Boolean timedOut) {
    this.timedOut = timedOut;
    return this;
  }

   /**
   * Get timedOut
   * @return timedOut
  **/
  @Schema(description = "")
  public Boolean isTimedOut() {
    return timedOut;
  }

  public void setTimedOut(Boolean timedOut) {
    this.timedOut = timedOut;
  }

  public SearchResponse took(TimeValue took) {
    this.took = took;
    return this;
  }

   /**
   * Get took
   * @return took
  **/
  @Schema(description = "")
  public TimeValue getTook() {
    return took;
  }

  public void setTook(TimeValue took) {
    this.took = took;
  }

  public SearchResponse totalShards(Integer totalShards) {
    this.totalShards = totalShards;
    return this;
  }

   /**
   * Get totalShards
   * @return totalShards
  **/
  @Schema(description = "")
  public Integer getTotalShards() {
    return totalShards;
  }

  public void setTotalShards(Integer totalShards) {
    this.totalShards = totalShards;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchResponse searchResponse = (SearchResponse) o;
    return Objects.equals(this.aggregations, searchResponse.aggregations) &&
        Objects.equals(this.clusters, searchResponse.clusters) &&
        Objects.equals(this.failedShards, searchResponse.failedShards) &&
        Objects.equals(this.fragment, searchResponse.fragment) &&
        Objects.equals(this.hits, searchResponse.hits) &&
        Objects.equals(this.internalResponse, searchResponse.internalResponse) &&
        Objects.equals(this.numReducePhases, searchResponse.numReducePhases) &&
        Objects.equals(this.profileResults, searchResponse.profileResults) &&
        Objects.equals(this.scrollId, searchResponse.scrollId) &&
        Objects.equals(this.shardFailures, searchResponse.shardFailures) &&
        Objects.equals(this.skippedShards, searchResponse.skippedShards) &&
        Objects.equals(this.successfulShards, searchResponse.successfulShards) &&
        Objects.equals(this.suggest, searchResponse.suggest) &&
        Objects.equals(this.terminatedEarly, searchResponse.terminatedEarly) &&
        Objects.equals(this.timedOut, searchResponse.timedOut) &&
        Objects.equals(this.took, searchResponse.took) &&
        Objects.equals(this.totalShards, searchResponse.totalShards);
  }

  @Override
  public int hashCode() {
    return Objects.hash(aggregations, clusters, failedShards, fragment, hits, internalResponse, numReducePhases, profileResults, scrollId, shardFailures, skippedShards, successfulShards, suggest, terminatedEarly, timedOut, took, totalShards);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchResponse {\n");
    
    sb.append("    aggregations: ").append(toIndentedString(aggregations)).append("\n");
    sb.append("    clusters: ").append(toIndentedString(clusters)).append("\n");
    sb.append("    failedShards: ").append(toIndentedString(failedShards)).append("\n");
    sb.append("    fragment: ").append(toIndentedString(fragment)).append("\n");
    sb.append("    hits: ").append(toIndentedString(hits)).append("\n");
    sb.append("    internalResponse: ").append(toIndentedString(internalResponse)).append("\n");
    sb.append("    numReducePhases: ").append(toIndentedString(numReducePhases)).append("\n");
    sb.append("    profileResults: ").append(toIndentedString(profileResults)).append("\n");
    sb.append("    scrollId: ").append(toIndentedString(scrollId)).append("\n");
    sb.append("    shardFailures: ").append(toIndentedString(shardFailures)).append("\n");
    sb.append("    skippedShards: ").append(toIndentedString(skippedShards)).append("\n");
    sb.append("    successfulShards: ").append(toIndentedString(successfulShards)).append("\n");
    sb.append("    suggest: ").append(toIndentedString(suggest)).append("\n");
    sb.append("    terminatedEarly: ").append(toIndentedString(terminatedEarly)).append("\n");
    sb.append("    timedOut: ").append(toIndentedString(timedOut)).append("\n");
    sb.append("    took: ").append(toIndentedString(took)).append("\n");
    sb.append("    totalShards: ").append(toIndentedString(totalShards)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
