/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import org.openmetadata.client.model.FieldComparatorSource;
import org.openmetadata.client.model.IndexSorter;
/**
 * SortField
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class SortField {
  @JsonProperty("bytesComparator")
  private Object bytesComparator = null;

  @JsonProperty("canUsePoints")
  private Boolean canUsePoints = null;

  @JsonProperty("comparatorSource")
  private FieldComparatorSource comparatorSource = null;

  @JsonProperty("field")
  private String field = null;

  @JsonProperty("indexSorter")
  private IndexSorter indexSorter = null;

  @JsonProperty("missingValue")
  private Object missingValue = null;

  @JsonProperty("reverse")
  private Boolean reverse = null;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    SCORE("SCORE"),
    DOC("DOC"),
    STRING("STRING"),
    INT("INT"),
    FLOAT("FLOAT"),
    LONG("LONG"),
    DOUBLE("DOUBLE"),
    CUSTOM("CUSTOM"),
    STRING_VAL("STRING_VAL"),
    REWRITEABLE("REWRITEABLE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("type")
  private TypeEnum type = null;

  public SortField bytesComparator(Object bytesComparator) {
    this.bytesComparator = bytesComparator;
    return this;
  }

   /**
   * Get bytesComparator
   * @return bytesComparator
  **/
  @Schema(description = "")
  public Object getBytesComparator() {
    return bytesComparator;
  }

  public void setBytesComparator(Object bytesComparator) {
    this.bytesComparator = bytesComparator;
  }

  public SortField canUsePoints(Boolean canUsePoints) {
    this.canUsePoints = canUsePoints;
    return this;
  }

   /**
   * Get canUsePoints
   * @return canUsePoints
  **/
  @Schema(description = "")
  public Boolean isCanUsePoints() {
    return canUsePoints;
  }

  public void setCanUsePoints(Boolean canUsePoints) {
    this.canUsePoints = canUsePoints;
  }

  public SortField comparatorSource(FieldComparatorSource comparatorSource) {
    this.comparatorSource = comparatorSource;
    return this;
  }

   /**
   * Get comparatorSource
   * @return comparatorSource
  **/
  @Schema(description = "")
  public FieldComparatorSource getComparatorSource() {
    return comparatorSource;
  }

  public void setComparatorSource(FieldComparatorSource comparatorSource) {
    this.comparatorSource = comparatorSource;
  }

  public SortField field(String field) {
    this.field = field;
    return this;
  }

   /**
   * Get field
   * @return field
  **/
  @Schema(description = "")
  public String getField() {
    return field;
  }

  public void setField(String field) {
    this.field = field;
  }

  public SortField indexSorter(IndexSorter indexSorter) {
    this.indexSorter = indexSorter;
    return this;
  }

   /**
   * Get indexSorter
   * @return indexSorter
  **/
  @Schema(description = "")
  public IndexSorter getIndexSorter() {
    return indexSorter;
  }

  public void setIndexSorter(IndexSorter indexSorter) {
    this.indexSorter = indexSorter;
  }

  public SortField missingValue(Object missingValue) {
    this.missingValue = missingValue;
    return this;
  }

   /**
   * Get missingValue
   * @return missingValue
  **/
  @Schema(description = "")
  public Object getMissingValue() {
    return missingValue;
  }

  public void setMissingValue(Object missingValue) {
    this.missingValue = missingValue;
  }

  public SortField reverse(Boolean reverse) {
    this.reverse = reverse;
    return this;
  }

   /**
   * Get reverse
   * @return reverse
  **/
  @Schema(description = "")
  public Boolean isReverse() {
    return reverse;
  }

  public void setReverse(Boolean reverse) {
    this.reverse = reverse;
  }

  public SortField type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @Schema(description = "")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SortField sortField = (SortField) o;
    return Objects.equals(this.bytesComparator, sortField.bytesComparator) &&
        Objects.equals(this.canUsePoints, sortField.canUsePoints) &&
        Objects.equals(this.comparatorSource, sortField.comparatorSource) &&
        Objects.equals(this.field, sortField.field) &&
        Objects.equals(this.indexSorter, sortField.indexSorter) &&
        Objects.equals(this.missingValue, sortField.missingValue) &&
        Objects.equals(this.reverse, sortField.reverse) &&
        Objects.equals(this.type, sortField.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bytesComparator, canUsePoints, comparatorSource, field, indexSorter, missingValue, reverse, type);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SortField {\n");
    
    sb.append("    bytesComparator: ").append(toIndentedString(bytesComparator)).append("\n");
    sb.append("    canUsePoints: ").append(toIndentedString(canUsePoints)).append("\n");
    sb.append("    comparatorSource: ").append(toIndentedString(comparatorSource)).append("\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    indexSorter: ").append(toIndentedString(indexSorter)).append("\n");
    sb.append("    missingValue: ").append(toIndentedString(missingValue)).append("\n");
    sb.append("    reverse: ").append(toIndentedString(reverse)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
