/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.Column;
import org.openmetadata.client.model.DataModel;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.SQLQuery;
import org.openmetadata.client.model.TableConstraint;
import org.openmetadata.client.model.TableData;
import org.openmetadata.client.model.TableJoins;
import org.openmetadata.client.model.TablePartition;
import org.openmetadata.client.model.TableProfile;
import org.openmetadata.client.model.TableProfilerConfig;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.UsageDetails;
/**
 * Table
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class Table {
  @JsonProperty("changeDescription")
  private ChangeDescription changeDescription = null;

  @JsonProperty("columns")
  private List<Column> columns = new ArrayList<Column>();

  @JsonProperty("dataModel")
  private DataModel dataModel = null;

  @JsonProperty("database")
  private EntityReference database = null;

  @JsonProperty("databaseSchema")
  private EntityReference databaseSchema = null;

  @JsonProperty("deleted")
  private Boolean deleted = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("extension")
  private Object extension = null;

  @JsonProperty("followers")
  private List<EntityReference> followers = null;

  @JsonProperty("fullyQualifiedName")
  private String fullyQualifiedName = null;

  @JsonProperty("href")
  private String href = null;

  @JsonProperty("id")
  private UUID id = null;

  @JsonProperty("joins")
  private TableJoins joins = null;

  @JsonProperty("location")
  private EntityReference location = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("owner")
  private EntityReference owner = null;

  @JsonProperty("profile")
  private TableProfile profile = null;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static ProviderEnum fromValue(String text) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("provider")
  private ProviderEnum provider = null;

  @JsonProperty("sampleData")
  private TableData sampleData = null;

  @JsonProperty("service")
  private EntityReference service = null;

  /**
   * Gets or Sets serviceType
   */
  public enum ServiceTypeEnum {
    BIGQUERY("BigQuery"),
    MYSQL("Mysql"),
    REDSHIFT("Redshift"),
    SNOWFLAKE("Snowflake"),
    POSTGRES("Postgres"),
    MSSQL("Mssql"),
    ORACLE("Oracle"),
    ATHENA("Athena"),
    HIVE("Hive"),
    PRESTO("Presto"),
    TRINO("Trino"),
    VERTICA("Vertica"),
    GLUE("Glue"),
    MARIADB("MariaDB"),
    DRUID("Druid"),
    DB2("Db2"),
    CLICKHOUSE("Clickhouse"),
    DATABRICKS("Databricks"),
    AZURESQL("AzureSQL"),
    DYNAMODB("DynamoDB"),
    SINGLESTORE("SingleStore"),
    SQLITE("SQLite"),
    DELTALAKE("DeltaLake"),
    SALESFORCE("Salesforce"),
    PINOTDB("PinotDB"),
    DATALAKE("Datalake"),
    DOMODATABASE("DomoDatabase"),
    QUERYLOG("QueryLog"),
    CUSTOMDATABASE("CustomDatabase"),
    DBT("Dbt");

    private String value;

    ServiceTypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static ServiceTypeEnum fromValue(String text) {
      for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("serviceType")
  private ServiceTypeEnum serviceType = null;

  @JsonProperty("tableConstraints")
  private List<TableConstraint> tableConstraints = null;

  @JsonProperty("tablePartition")
  private TablePartition tablePartition = null;

  @JsonProperty("tableProfilerConfig")
  private TableProfilerConfig tableProfilerConfig = null;

  @JsonProperty("tableQueries")
  private List<SQLQuery> tableQueries = null;

  /**
   * Gets or Sets tableType
   */
  public enum TableTypeEnum {
    REGULAR("Regular"),
    EXTERNAL("External"),
    VIEW("View"),
    SECUREVIEW("SecureView"),
    MATERIALIZEDVIEW("MaterializedView"),
    ICEBERG("Iceberg"),
    LOCAL("Local"),
    PARTITIONED("Partitioned"),
    FOREIGN("Foreign");

    private String value;

    TableTypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static TableTypeEnum fromValue(String text) {
      for (TableTypeEnum b : TableTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("tableType")
  private TableTypeEnum tableType = null;

  @JsonProperty("tags")
  private List<TagLabel> tags = null;

  @JsonProperty("updatedAt")
  private Long updatedAt = null;

  @JsonProperty("updatedBy")
  private String updatedBy = null;

  @JsonProperty("usageSummary")
  private UsageDetails usageSummary = null;

  @JsonProperty("version")
  private Double version = null;

  @JsonProperty("viewDefinition")
  private String viewDefinition = null;

  public Table changeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @Schema(description = "")
  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }

  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }

  public Table columns(List<Column> columns) {
    this.columns = columns;
    return this;
  }

  public Table addColumnsItem(Column columnsItem) {
    this.columns.add(columnsItem);
    return this;
  }

   /**
   * Get columns
   * @return columns
  **/
  @Schema(required = true, description = "")
  public List<Column> getColumns() {
    return columns;
  }

  public void setColumns(List<Column> columns) {
    this.columns = columns;
  }

  public Table dataModel(DataModel dataModel) {
    this.dataModel = dataModel;
    return this;
  }

   /**
   * Get dataModel
   * @return dataModel
  **/
  @Schema(description = "")
  public DataModel getDataModel() {
    return dataModel;
  }

  public void setDataModel(DataModel dataModel) {
    this.dataModel = dataModel;
  }

  public Table database(EntityReference database) {
    this.database = database;
    return this;
  }

   /**
   * Get database
   * @return database
  **/
  @Schema(description = "")
  public EntityReference getDatabase() {
    return database;
  }

  public void setDatabase(EntityReference database) {
    this.database = database;
  }

  public Table databaseSchema(EntityReference databaseSchema) {
    this.databaseSchema = databaseSchema;
    return this;
  }

   /**
   * Get databaseSchema
   * @return databaseSchema
  **/
  @Schema(description = "")
  public EntityReference getDatabaseSchema() {
    return databaseSchema;
  }

  public void setDatabaseSchema(EntityReference databaseSchema) {
    this.databaseSchema = databaseSchema;
  }

  public Table deleted(Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @Schema(description = "")
  public Boolean isDeleted() {
    return deleted;
  }

  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }

  public Table description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @Schema(description = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Table displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @Schema(description = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public Table extension(Object extension) {
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @Schema(description = "")
  public Object getExtension() {
    return extension;
  }

  public void setExtension(Object extension) {
    this.extension = extension;
  }

  public Table followers(List<EntityReference> followers) {
    this.followers = followers;
    return this;
  }

  public Table addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<EntityReference>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @Schema(description = "")
  public List<EntityReference> getFollowers() {
    return followers;
  }

  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }

  public Table fullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @Schema(description = "")
  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }

  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }

  public Table href(String href) {
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @Schema(description = "")
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public Table id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(required = true, description = "")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public Table joins(TableJoins joins) {
    this.joins = joins;
    return this;
  }

   /**
   * Get joins
   * @return joins
  **/
  @Schema(description = "")
  public TableJoins getJoins() {
    return joins;
  }

  public void setJoins(TableJoins joins) {
    this.joins = joins;
  }

  public Table location(EntityReference location) {
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @Schema(description = "")
  public EntityReference getLocation() {
    return location;
  }

  public void setLocation(EntityReference location) {
    this.location = location;
  }

  public Table name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Table owner(EntityReference owner) {
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @Schema(description = "")
  public EntityReference getOwner() {
    return owner;
  }

  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }

  public Table profile(TableProfile profile) {
    this.profile = profile;
    return this;
  }

   /**
   * Get profile
   * @return profile
  **/
  @Schema(description = "")
  public TableProfile getProfile() {
    return profile;
  }

  public void setProfile(TableProfile profile) {
    this.profile = profile;
  }

  public Table provider(ProviderEnum provider) {
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @Schema(description = "")
  public ProviderEnum getProvider() {
    return provider;
  }

  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }

  public Table sampleData(TableData sampleData) {
    this.sampleData = sampleData;
    return this;
  }

   /**
   * Get sampleData
   * @return sampleData
  **/
  @Schema(description = "")
  public TableData getSampleData() {
    return sampleData;
  }

  public void setSampleData(TableData sampleData) {
    this.sampleData = sampleData;
  }

  public Table service(EntityReference service) {
    this.service = service;
    return this;
  }

   /**
   * Get service
   * @return service
  **/
  @Schema(description = "")
  public EntityReference getService() {
    return service;
  }

  public void setService(EntityReference service) {
    this.service = service;
  }

  public Table serviceType(ServiceTypeEnum serviceType) {
    this.serviceType = serviceType;
    return this;
  }

   /**
   * Get serviceType
   * @return serviceType
  **/
  @Schema(description = "")
  public ServiceTypeEnum getServiceType() {
    return serviceType;
  }

  public void setServiceType(ServiceTypeEnum serviceType) {
    this.serviceType = serviceType;
  }

  public Table tableConstraints(List<TableConstraint> tableConstraints) {
    this.tableConstraints = tableConstraints;
    return this;
  }

  public Table addTableConstraintsItem(TableConstraint tableConstraintsItem) {
    if (this.tableConstraints == null) {
      this.tableConstraints = new ArrayList<TableConstraint>();
    }
    this.tableConstraints.add(tableConstraintsItem);
    return this;
  }

   /**
   * Get tableConstraints
   * @return tableConstraints
  **/
  @Schema(description = "")
  public List<TableConstraint> getTableConstraints() {
    return tableConstraints;
  }

  public void setTableConstraints(List<TableConstraint> tableConstraints) {
    this.tableConstraints = tableConstraints;
  }

  public Table tablePartition(TablePartition tablePartition) {
    this.tablePartition = tablePartition;
    return this;
  }

   /**
   * Get tablePartition
   * @return tablePartition
  **/
  @Schema(description = "")
  public TablePartition getTablePartition() {
    return tablePartition;
  }

  public void setTablePartition(TablePartition tablePartition) {
    this.tablePartition = tablePartition;
  }

  public Table tableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
    this.tableProfilerConfig = tableProfilerConfig;
    return this;
  }

   /**
   * Get tableProfilerConfig
   * @return tableProfilerConfig
  **/
  @Schema(description = "")
  public TableProfilerConfig getTableProfilerConfig() {
    return tableProfilerConfig;
  }

  public void setTableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
    this.tableProfilerConfig = tableProfilerConfig;
  }

  public Table tableQueries(List<SQLQuery> tableQueries) {
    this.tableQueries = tableQueries;
    return this;
  }

  public Table addTableQueriesItem(SQLQuery tableQueriesItem) {
    if (this.tableQueries == null) {
      this.tableQueries = new ArrayList<SQLQuery>();
    }
    this.tableQueries.add(tableQueriesItem);
    return this;
  }

   /**
   * Get tableQueries
   * @return tableQueries
  **/
  @Schema(description = "")
  public List<SQLQuery> getTableQueries() {
    return tableQueries;
  }

  public void setTableQueries(List<SQLQuery> tableQueries) {
    this.tableQueries = tableQueries;
  }

  public Table tableType(TableTypeEnum tableType) {
    this.tableType = tableType;
    return this;
  }

   /**
   * Get tableType
   * @return tableType
  **/
  @Schema(description = "")
  public TableTypeEnum getTableType() {
    return tableType;
  }

  public void setTableType(TableTypeEnum tableType) {
    this.tableType = tableType;
  }

  public Table tags(List<TagLabel> tags) {
    this.tags = tags;
    return this;
  }

  public Table addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<TagLabel>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @Schema(description = "")
  public List<TagLabel> getTags() {
    return tags;
  }

  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }

  public Table updatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @Schema(description = "")
  public Long getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }

  public Table updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @Schema(description = "")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  public Table usageSummary(UsageDetails usageSummary) {
    this.usageSummary = usageSummary;
    return this;
  }

   /**
   * Get usageSummary
   * @return usageSummary
  **/
  @Schema(description = "")
  public UsageDetails getUsageSummary() {
    return usageSummary;
  }

  public void setUsageSummary(UsageDetails usageSummary) {
    this.usageSummary = usageSummary;
  }

  public Table version(Double version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @Schema(description = "")
  public Double getVersion() {
    return version;
  }

  public void setVersion(Double version) {
    this.version = version;
  }

  public Table viewDefinition(String viewDefinition) {
    this.viewDefinition = viewDefinition;
    return this;
  }

   /**
   * Get viewDefinition
   * @return viewDefinition
  **/
  @Schema(description = "")
  public String getViewDefinition() {
    return viewDefinition;
  }

  public void setViewDefinition(String viewDefinition) {
    this.viewDefinition = viewDefinition;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Table table = (Table) o;
    return Objects.equals(this.changeDescription, table.changeDescription) &&
        Objects.equals(this.columns, table.columns) &&
        Objects.equals(this.dataModel, table.dataModel) &&
        Objects.equals(this.database, table.database) &&
        Objects.equals(this.databaseSchema, table.databaseSchema) &&
        Objects.equals(this.deleted, table.deleted) &&
        Objects.equals(this.description, table.description) &&
        Objects.equals(this.displayName, table.displayName) &&
        Objects.equals(this.extension, table.extension) &&
        Objects.equals(this.followers, table.followers) &&
        Objects.equals(this.fullyQualifiedName, table.fullyQualifiedName) &&
        Objects.equals(this.href, table.href) &&
        Objects.equals(this.id, table.id) &&
        Objects.equals(this.joins, table.joins) &&
        Objects.equals(this.location, table.location) &&
        Objects.equals(this.name, table.name) &&
        Objects.equals(this.owner, table.owner) &&
        Objects.equals(this.profile, table.profile) &&
        Objects.equals(this.provider, table.provider) &&
        Objects.equals(this.sampleData, table.sampleData) &&
        Objects.equals(this.service, table.service) &&
        Objects.equals(this.serviceType, table.serviceType) &&
        Objects.equals(this.tableConstraints, table.tableConstraints) &&
        Objects.equals(this.tablePartition, table.tablePartition) &&
        Objects.equals(this.tableProfilerConfig, table.tableProfilerConfig) &&
        Objects.equals(this.tableQueries, table.tableQueries) &&
        Objects.equals(this.tableType, table.tableType) &&
        Objects.equals(this.tags, table.tags) &&
        Objects.equals(this.updatedAt, table.updatedAt) &&
        Objects.equals(this.updatedBy, table.updatedBy) &&
        Objects.equals(this.usageSummary, table.usageSummary) &&
        Objects.equals(this.version, table.version) &&
        Objects.equals(this.viewDefinition, table.viewDefinition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeDescription, columns, dataModel, database, databaseSchema, deleted, description, displayName, extension, followers, fullyQualifiedName, href, id, joins, location, name, owner, profile, provider, sampleData, service, serviceType, tableConstraints, tablePartition, tableProfilerConfig, tableQueries, tableType, tags, updatedAt, updatedBy, usageSummary, version, viewDefinition);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Table {\n");
    
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    columns: ").append(toIndentedString(columns)).append("\n");
    sb.append("    dataModel: ").append(toIndentedString(dataModel)).append("\n");
    sb.append("    database: ").append(toIndentedString(database)).append("\n");
    sb.append("    databaseSchema: ").append(toIndentedString(databaseSchema)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    joins: ").append(toIndentedString(joins)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    sampleData: ").append(toIndentedString(sampleData)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    serviceType: ").append(toIndentedString(serviceType)).append("\n");
    sb.append("    tableConstraints: ").append(toIndentedString(tableConstraints)).append("\n");
    sb.append("    tablePartition: ").append(toIndentedString(tablePartition)).append("\n");
    sb.append("    tableProfilerConfig: ").append(toIndentedString(tableProfilerConfig)).append("\n");
    sb.append("    tableQueries: ").append(toIndentedString(tableQueries)).append("\n");
    sb.append("    tableType: ").append(toIndentedString(tableType)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    usageSummary: ").append(toIndentedString(usageSummary)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    viewDefinition: ").append(toIndentedString(viewDefinition)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
