/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.Profile;
import org.openmetadata.client.model.TagLabel;
/**
 * Team
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class Team {
  @JsonProperty("changeDescription")
  private ChangeDescription changeDescription = null;

  @JsonProperty("children")
  private List<EntityReference> children = null;

  @JsonProperty("childrenCount")
  private Integer childrenCount = null;

  @JsonProperty("defaultRoles")
  private List<EntityReference> defaultRoles = null;

  @JsonProperty("deleted")
  private Boolean deleted = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("extension")
  private Object extension = null;

  @JsonProperty("followers")
  private List<EntityReference> followers = null;

  @JsonProperty("fullyQualifiedName")
  private String fullyQualifiedName = null;

  @JsonProperty("href")
  private String href = null;

  @JsonProperty("id")
  private UUID id = null;

  @JsonProperty("inheritedRoles")
  private List<EntityReference> inheritedRoles = null;

  @JsonProperty("isJoinable")
  private Boolean isJoinable = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("owner")
  private EntityReference owner = null;

  @JsonProperty("owns")
  private List<EntityReference> owns = null;

  @JsonProperty("parents")
  private List<EntityReference> parents = null;

  @JsonProperty("policies")
  private List<EntityReference> policies = null;

  @JsonProperty("profile")
  private Profile profile = null;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static ProviderEnum fromValue(String text) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("provider")
  private ProviderEnum provider = null;

  @JsonProperty("tags")
  private List<TagLabel> tags = null;

  /**
   * Gets or Sets teamType
   */
  public enum TeamTypeEnum {
    GROUP("Group"),
    DEPARTMENT("Department"),
    DIVISION("Division"),
    BUSINESSUNIT("BusinessUnit"),
    ORGANIZATION("Organization");

    private String value;

    TeamTypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static TeamTypeEnum fromValue(String text) {
      for (TeamTypeEnum b : TeamTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("teamType")
  private TeamTypeEnum teamType = null;

  @JsonProperty("updatedAt")
  private Long updatedAt = null;

  @JsonProperty("updatedBy")
  private String updatedBy = null;

  @JsonProperty("userCount")
  private Integer userCount = null;

  @JsonProperty("users")
  private List<EntityReference> users = null;

  @JsonProperty("version")
  private Double version = null;

  public Team changeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @Schema(description = "")
  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }

  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }

  public Team children(List<EntityReference> children) {
    this.children = children;
    return this;
  }

  public Team addChildrenItem(EntityReference childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<EntityReference>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @Schema(description = "")
  public List<EntityReference> getChildren() {
    return children;
  }

  public void setChildren(List<EntityReference> children) {
    this.children = children;
  }

  public Team childrenCount(Integer childrenCount) {
    this.childrenCount = childrenCount;
    return this;
  }

   /**
   * Get childrenCount
   * @return childrenCount
  **/
  @Schema(description = "")
  public Integer getChildrenCount() {
    return childrenCount;
  }

  public void setChildrenCount(Integer childrenCount) {
    this.childrenCount = childrenCount;
  }

  public Team defaultRoles(List<EntityReference> defaultRoles) {
    this.defaultRoles = defaultRoles;
    return this;
  }

  public Team addDefaultRolesItem(EntityReference defaultRolesItem) {
    if (this.defaultRoles == null) {
      this.defaultRoles = new ArrayList<EntityReference>();
    }
    this.defaultRoles.add(defaultRolesItem);
    return this;
  }

   /**
   * Get defaultRoles
   * @return defaultRoles
  **/
  @Schema(description = "")
  public List<EntityReference> getDefaultRoles() {
    return defaultRoles;
  }

  public void setDefaultRoles(List<EntityReference> defaultRoles) {
    this.defaultRoles = defaultRoles;
  }

  public Team deleted(Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @Schema(description = "")
  public Boolean isDeleted() {
    return deleted;
  }

  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }

  public Team description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @Schema(description = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Team displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @Schema(description = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public Team extension(Object extension) {
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @Schema(description = "")
  public Object getExtension() {
    return extension;
  }

  public void setExtension(Object extension) {
    this.extension = extension;
  }

  public Team followers(List<EntityReference> followers) {
    this.followers = followers;
    return this;
  }

  public Team addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<EntityReference>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @Schema(description = "")
  public List<EntityReference> getFollowers() {
    return followers;
  }

  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }

  public Team fullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @Schema(description = "")
  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }

  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }

  public Team href(String href) {
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @Schema(required = true, description = "")
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public Team id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(required = true, description = "")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public Team inheritedRoles(List<EntityReference> inheritedRoles) {
    this.inheritedRoles = inheritedRoles;
    return this;
  }

  public Team addInheritedRolesItem(EntityReference inheritedRolesItem) {
    if (this.inheritedRoles == null) {
      this.inheritedRoles = new ArrayList<EntityReference>();
    }
    this.inheritedRoles.add(inheritedRolesItem);
    return this;
  }

   /**
   * Get inheritedRoles
   * @return inheritedRoles
  **/
  @Schema(description = "")
  public List<EntityReference> getInheritedRoles() {
    return inheritedRoles;
  }

  public void setInheritedRoles(List<EntityReference> inheritedRoles) {
    this.inheritedRoles = inheritedRoles;
  }

  public Team isJoinable(Boolean isJoinable) {
    this.isJoinable = isJoinable;
    return this;
  }

   /**
   * Get isJoinable
   * @return isJoinable
  **/
  @Schema(description = "")
  public Boolean isIsJoinable() {
    return isJoinable;
  }

  public void setIsJoinable(Boolean isJoinable) {
    this.isJoinable = isJoinable;
  }

  public Team name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Team owner(EntityReference owner) {
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @Schema(description = "")
  public EntityReference getOwner() {
    return owner;
  }

  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }

  public Team owns(List<EntityReference> owns) {
    this.owns = owns;
    return this;
  }

  public Team addOwnsItem(EntityReference ownsItem) {
    if (this.owns == null) {
      this.owns = new ArrayList<EntityReference>();
    }
    this.owns.add(ownsItem);
    return this;
  }

   /**
   * Get owns
   * @return owns
  **/
  @Schema(description = "")
  public List<EntityReference> getOwns() {
    return owns;
  }

  public void setOwns(List<EntityReference> owns) {
    this.owns = owns;
  }

  public Team parents(List<EntityReference> parents) {
    this.parents = parents;
    return this;
  }

  public Team addParentsItem(EntityReference parentsItem) {
    if (this.parents == null) {
      this.parents = new ArrayList<EntityReference>();
    }
    this.parents.add(parentsItem);
    return this;
  }

   /**
   * Get parents
   * @return parents
  **/
  @Schema(description = "")
  public List<EntityReference> getParents() {
    return parents;
  }

  public void setParents(List<EntityReference> parents) {
    this.parents = parents;
  }

  public Team policies(List<EntityReference> policies) {
    this.policies = policies;
    return this;
  }

  public Team addPoliciesItem(EntityReference policiesItem) {
    if (this.policies == null) {
      this.policies = new ArrayList<EntityReference>();
    }
    this.policies.add(policiesItem);
    return this;
  }

   /**
   * Get policies
   * @return policies
  **/
  @Schema(description = "")
  public List<EntityReference> getPolicies() {
    return policies;
  }

  public void setPolicies(List<EntityReference> policies) {
    this.policies = policies;
  }

  public Team profile(Profile profile) {
    this.profile = profile;
    return this;
  }

   /**
   * Get profile
   * @return profile
  **/
  @Schema(description = "")
  public Profile getProfile() {
    return profile;
  }

  public void setProfile(Profile profile) {
    this.profile = profile;
  }

  public Team provider(ProviderEnum provider) {
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @Schema(description = "")
  public ProviderEnum getProvider() {
    return provider;
  }

  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }

  public Team tags(List<TagLabel> tags) {
    this.tags = tags;
    return this;
  }

  public Team addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<TagLabel>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @Schema(description = "")
  public List<TagLabel> getTags() {
    return tags;
  }

  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }

  public Team teamType(TeamTypeEnum teamType) {
    this.teamType = teamType;
    return this;
  }

   /**
   * Get teamType
   * @return teamType
  **/
  @Schema(description = "")
  public TeamTypeEnum getTeamType() {
    return teamType;
  }

  public void setTeamType(TeamTypeEnum teamType) {
    this.teamType = teamType;
  }

  public Team updatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @Schema(description = "")
  public Long getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }

  public Team updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @Schema(description = "")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  public Team userCount(Integer userCount) {
    this.userCount = userCount;
    return this;
  }

   /**
   * Get userCount
   * @return userCount
  **/
  @Schema(description = "")
  public Integer getUserCount() {
    return userCount;
  }

  public void setUserCount(Integer userCount) {
    this.userCount = userCount;
  }

  public Team users(List<EntityReference> users) {
    this.users = users;
    return this;
  }

  public Team addUsersItem(EntityReference usersItem) {
    if (this.users == null) {
      this.users = new ArrayList<EntityReference>();
    }
    this.users.add(usersItem);
    return this;
  }

   /**
   * Get users
   * @return users
  **/
  @Schema(description = "")
  public List<EntityReference> getUsers() {
    return users;
  }

  public void setUsers(List<EntityReference> users) {
    this.users = users;
  }

  public Team version(Double version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @Schema(description = "")
  public Double getVersion() {
    return version;
  }

  public void setVersion(Double version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Team team = (Team) o;
    return Objects.equals(this.changeDescription, team.changeDescription) &&
        Objects.equals(this.children, team.children) &&
        Objects.equals(this.childrenCount, team.childrenCount) &&
        Objects.equals(this.defaultRoles, team.defaultRoles) &&
        Objects.equals(this.deleted, team.deleted) &&
        Objects.equals(this.description, team.description) &&
        Objects.equals(this.displayName, team.displayName) &&
        Objects.equals(this.extension, team.extension) &&
        Objects.equals(this.followers, team.followers) &&
        Objects.equals(this.fullyQualifiedName, team.fullyQualifiedName) &&
        Objects.equals(this.href, team.href) &&
        Objects.equals(this.id, team.id) &&
        Objects.equals(this.inheritedRoles, team.inheritedRoles) &&
        Objects.equals(this.isJoinable, team.isJoinable) &&
        Objects.equals(this.name, team.name) &&
        Objects.equals(this.owner, team.owner) &&
        Objects.equals(this.owns, team.owns) &&
        Objects.equals(this.parents, team.parents) &&
        Objects.equals(this.policies, team.policies) &&
        Objects.equals(this.profile, team.profile) &&
        Objects.equals(this.provider, team.provider) &&
        Objects.equals(this.tags, team.tags) &&
        Objects.equals(this.teamType, team.teamType) &&
        Objects.equals(this.updatedAt, team.updatedAt) &&
        Objects.equals(this.updatedBy, team.updatedBy) &&
        Objects.equals(this.userCount, team.userCount) &&
        Objects.equals(this.users, team.users) &&
        Objects.equals(this.version, team.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeDescription, children, childrenCount, defaultRoles, deleted, description, displayName, extension, followers, fullyQualifiedName, href, id, inheritedRoles, isJoinable, name, owner, owns, parents, policies, profile, provider, tags, teamType, updatedAt, updatedBy, userCount, users, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Team {\n");
    
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    childrenCount: ").append(toIndentedString(childrenCount)).append("\n");
    sb.append("    defaultRoles: ").append(toIndentedString(defaultRoles)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inheritedRoles: ").append(toIndentedString(inheritedRoles)).append("\n");
    sb.append("    isJoinable: ").append(toIndentedString(isJoinable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    owns: ").append(toIndentedString(owns)).append("\n");
    sb.append("    parents: ").append(toIndentedString(parents)).append("\n");
    sb.append("    policies: ").append(toIndentedString(policies)).append("\n");
    sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    teamType: ").append(toIndentedString(teamType)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    userCount: ").append(toIndentedString(userCount)).append("\n");
    sb.append("    users: ").append(toIndentedString(users)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
