/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TestCaseParameterValue;
import org.openmetadata.client.model.TestCaseResult;
/**
 * TestCase
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class TestCase {
  @JsonProperty("changeDescription")
  private ChangeDescription changeDescription = null;

  @JsonProperty("deleted")
  private Boolean deleted = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("entityFQN")
  private String entityFQN = null;

  @JsonProperty("entityLink")
  private String entityLink = null;

  @JsonProperty("extension")
  private Object extension = null;

  @JsonProperty("followers")
  private List<EntityReference> followers = null;

  @JsonProperty("fullyQualifiedName")
  private String fullyQualifiedName = null;

  @JsonProperty("href")
  private String href = null;

  @JsonProperty("id")
  private UUID id = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("owner")
  private EntityReference owner = null;

  @JsonProperty("parameterValues")
  private List<TestCaseParameterValue> parameterValues = null;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static ProviderEnum fromValue(String text) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("provider")
  private ProviderEnum provider = null;

  @JsonProperty("tags")
  private List<TagLabel> tags = null;

  @JsonProperty("testCaseResult")
  private TestCaseResult testCaseResult = null;

  @JsonProperty("testDefinition")
  private EntityReference testDefinition = null;

  @JsonProperty("testSuite")
  private EntityReference testSuite = null;

  @JsonProperty("updatedAt")
  private Long updatedAt = null;

  @JsonProperty("updatedBy")
  private String updatedBy = null;

  @JsonProperty("version")
  private Double version = null;

  public TestCase changeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @Schema(description = "")
  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }

  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }

  public TestCase deleted(Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @Schema(description = "")
  public Boolean isDeleted() {
    return deleted;
  }

  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }

  public TestCase description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @Schema(description = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TestCase displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @Schema(description = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public TestCase entityFQN(String entityFQN) {
    this.entityFQN = entityFQN;
    return this;
  }

   /**
   * Get entityFQN
   * @return entityFQN
  **/
  @Schema(description = "")
  public String getEntityFQN() {
    return entityFQN;
  }

  public void setEntityFQN(String entityFQN) {
    this.entityFQN = entityFQN;
  }

  public TestCase entityLink(String entityLink) {
    this.entityLink = entityLink;
    return this;
  }

   /**
   * Get entityLink
   * @return entityLink
  **/
  @Schema(required = true, description = "")
  public String getEntityLink() {
    return entityLink;
  }

  public void setEntityLink(String entityLink) {
    this.entityLink = entityLink;
  }

  public TestCase extension(Object extension) {
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @Schema(description = "")
  public Object getExtension() {
    return extension;
  }

  public void setExtension(Object extension) {
    this.extension = extension;
  }

  public TestCase followers(List<EntityReference> followers) {
    this.followers = followers;
    return this;
  }

  public TestCase addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<EntityReference>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @Schema(description = "")
  public List<EntityReference> getFollowers() {
    return followers;
  }

  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }

  public TestCase fullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @Schema(description = "")
  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }

  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }

  public TestCase href(String href) {
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @Schema(description = "")
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public TestCase id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(description = "")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public TestCase name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestCase owner(EntityReference owner) {
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @Schema(description = "")
  public EntityReference getOwner() {
    return owner;
  }

  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }

  public TestCase parameterValues(List<TestCaseParameterValue> parameterValues) {
    this.parameterValues = parameterValues;
    return this;
  }

  public TestCase addParameterValuesItem(TestCaseParameterValue parameterValuesItem) {
    if (this.parameterValues == null) {
      this.parameterValues = new ArrayList<TestCaseParameterValue>();
    }
    this.parameterValues.add(parameterValuesItem);
    return this;
  }

   /**
   * Get parameterValues
   * @return parameterValues
  **/
  @Schema(description = "")
  public List<TestCaseParameterValue> getParameterValues() {
    return parameterValues;
  }

  public void setParameterValues(List<TestCaseParameterValue> parameterValues) {
    this.parameterValues = parameterValues;
  }

  public TestCase provider(ProviderEnum provider) {
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @Schema(description = "")
  public ProviderEnum getProvider() {
    return provider;
  }

  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }

  public TestCase tags(List<TagLabel> tags) {
    this.tags = tags;
    return this;
  }

  public TestCase addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<TagLabel>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @Schema(description = "")
  public List<TagLabel> getTags() {
    return tags;
  }

  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }

  public TestCase testCaseResult(TestCaseResult testCaseResult) {
    this.testCaseResult = testCaseResult;
    return this;
  }

   /**
   * Get testCaseResult
   * @return testCaseResult
  **/
  @Schema(description = "")
  public TestCaseResult getTestCaseResult() {
    return testCaseResult;
  }

  public void setTestCaseResult(TestCaseResult testCaseResult) {
    this.testCaseResult = testCaseResult;
  }

  public TestCase testDefinition(EntityReference testDefinition) {
    this.testDefinition = testDefinition;
    return this;
  }

   /**
   * Get testDefinition
   * @return testDefinition
  **/
  @Schema(required = true, description = "")
  public EntityReference getTestDefinition() {
    return testDefinition;
  }

  public void setTestDefinition(EntityReference testDefinition) {
    this.testDefinition = testDefinition;
  }

  public TestCase testSuite(EntityReference testSuite) {
    this.testSuite = testSuite;
    return this;
  }

   /**
   * Get testSuite
   * @return testSuite
  **/
  @Schema(required = true, description = "")
  public EntityReference getTestSuite() {
    return testSuite;
  }

  public void setTestSuite(EntityReference testSuite) {
    this.testSuite = testSuite;
  }

  public TestCase updatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @Schema(description = "")
  public Long getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }

  public TestCase updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @Schema(description = "")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  public TestCase version(Double version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @Schema(description = "")
  public Double getVersion() {
    return version;
  }

  public void setVersion(Double version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCase testCase = (TestCase) o;
    return Objects.equals(this.changeDescription, testCase.changeDescription) &&
        Objects.equals(this.deleted, testCase.deleted) &&
        Objects.equals(this.description, testCase.description) &&
        Objects.equals(this.displayName, testCase.displayName) &&
        Objects.equals(this.entityFQN, testCase.entityFQN) &&
        Objects.equals(this.entityLink, testCase.entityLink) &&
        Objects.equals(this.extension, testCase.extension) &&
        Objects.equals(this.followers, testCase.followers) &&
        Objects.equals(this.fullyQualifiedName, testCase.fullyQualifiedName) &&
        Objects.equals(this.href, testCase.href) &&
        Objects.equals(this.id, testCase.id) &&
        Objects.equals(this.name, testCase.name) &&
        Objects.equals(this.owner, testCase.owner) &&
        Objects.equals(this.parameterValues, testCase.parameterValues) &&
        Objects.equals(this.provider, testCase.provider) &&
        Objects.equals(this.tags, testCase.tags) &&
        Objects.equals(this.testCaseResult, testCase.testCaseResult) &&
        Objects.equals(this.testDefinition, testCase.testDefinition) &&
        Objects.equals(this.testSuite, testCase.testSuite) &&
        Objects.equals(this.updatedAt, testCase.updatedAt) &&
        Objects.equals(this.updatedBy, testCase.updatedBy) &&
        Objects.equals(this.version, testCase.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeDescription, deleted, description, displayName, entityFQN, entityLink, extension, followers, fullyQualifiedName, href, id, name, owner, parameterValues, provider, tags, testCaseResult, testDefinition, testSuite, updatedAt, updatedBy, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCase {\n");
    
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    entityFQN: ").append(toIndentedString(entityFQN)).append("\n");
    sb.append("    entityLink: ").append(toIndentedString(entityLink)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    parameterValues: ").append(toIndentedString(parameterValues)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    testCaseResult: ").append(toIndentedString(testCaseResult)).append("\n");
    sb.append("    testDefinition: ").append(toIndentedString(testDefinition)).append("\n");
    sb.append("    testSuite: ").append(toIndentedString(testSuite)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
