/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.AnnouncementDetails;
import org.openmetadata.client.model.Post;
import org.openmetadata.client.model.Reaction;
import org.openmetadata.client.model.TaskDetails;
/**
 * Thread
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class Thread {
  @JsonProperty("about")
  private String about = null;

  @JsonProperty("addressedTo")
  private String addressedTo = null;

  @JsonProperty("announcement")
  private AnnouncementDetails announcement = null;

  @JsonProperty("createdBy")
  private String createdBy = null;

  @JsonProperty("entityId")
  private UUID entityId = null;

  @JsonProperty("href")
  private String href = null;

  @JsonProperty("id")
  private UUID id = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("posts")
  private List<Post> posts = null;

  @JsonProperty("postsCount")
  private Integer postsCount = null;

  @JsonProperty("reactions")
  private List<Reaction> reactions = null;

  @JsonProperty("resolved")
  private Boolean resolved = null;

  @JsonProperty("task")
  private TaskDetails task = null;

  @JsonProperty("threadTs")
  private Long threadTs = null;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    CONVERSATION("Conversation"),
    TASK("Task"),
    ANNOUNCEMENT("Announcement");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("type")
  private TypeEnum type = null;

  @JsonProperty("updatedAt")
  private Long updatedAt = null;

  @JsonProperty("updatedBy")
  private String updatedBy = null;

  public Thread about(String about) {
    this.about = about;
    return this;
  }

   /**
   * Get about
   * @return about
  **/
  @Schema(required = true, description = "")
  public String getAbout() {
    return about;
  }

  public void setAbout(String about) {
    this.about = about;
  }

  public Thread addressedTo(String addressedTo) {
    this.addressedTo = addressedTo;
    return this;
  }

   /**
   * Get addressedTo
   * @return addressedTo
  **/
  @Schema(description = "")
  public String getAddressedTo() {
    return addressedTo;
  }

  public void setAddressedTo(String addressedTo) {
    this.addressedTo = addressedTo;
  }

  public Thread announcement(AnnouncementDetails announcement) {
    this.announcement = announcement;
    return this;
  }

   /**
   * Get announcement
   * @return announcement
  **/
  @Schema(description = "")
  public AnnouncementDetails getAnnouncement() {
    return announcement;
  }

  public void setAnnouncement(AnnouncementDetails announcement) {
    this.announcement = announcement;
  }

  public Thread createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * Get createdBy
   * @return createdBy
  **/
  @Schema(description = "")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  public Thread entityId(UUID entityId) {
    this.entityId = entityId;
    return this;
  }

   /**
   * Get entityId
   * @return entityId
  **/
  @Schema(description = "")
  public UUID getEntityId() {
    return entityId;
  }

  public void setEntityId(UUID entityId) {
    this.entityId = entityId;
  }

  public Thread href(String href) {
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @Schema(description = "")
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public Thread id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(required = true, description = "")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public Thread message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @Schema(required = true, description = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public Thread posts(List<Post> posts) {
    this.posts = posts;
    return this;
  }

  public Thread addPostsItem(Post postsItem) {
    if (this.posts == null) {
      this.posts = new ArrayList<Post>();
    }
    this.posts.add(postsItem);
    return this;
  }

   /**
   * Get posts
   * @return posts
  **/
  @Schema(description = "")
  public List<Post> getPosts() {
    return posts;
  }

  public void setPosts(List<Post> posts) {
    this.posts = posts;
  }

  public Thread postsCount(Integer postsCount) {
    this.postsCount = postsCount;
    return this;
  }

   /**
   * Get postsCount
   * @return postsCount
  **/
  @Schema(description = "")
  public Integer getPostsCount() {
    return postsCount;
  }

  public void setPostsCount(Integer postsCount) {
    this.postsCount = postsCount;
  }

  public Thread reactions(List<Reaction> reactions) {
    this.reactions = reactions;
    return this;
  }

  public Thread addReactionsItem(Reaction reactionsItem) {
    if (this.reactions == null) {
      this.reactions = new ArrayList<Reaction>();
    }
    this.reactions.add(reactionsItem);
    return this;
  }

   /**
   * Get reactions
   * @return reactions
  **/
  @Schema(description = "")
  public List<Reaction> getReactions() {
    return reactions;
  }

  public void setReactions(List<Reaction> reactions) {
    this.reactions = reactions;
  }

  public Thread resolved(Boolean resolved) {
    this.resolved = resolved;
    return this;
  }

   /**
   * Get resolved
   * @return resolved
  **/
  @Schema(description = "")
  public Boolean isResolved() {
    return resolved;
  }

  public void setResolved(Boolean resolved) {
    this.resolved = resolved;
  }

  public Thread task(TaskDetails task) {
    this.task = task;
    return this;
  }

   /**
   * Get task
   * @return task
  **/
  @Schema(description = "")
  public TaskDetails getTask() {
    return task;
  }

  public void setTask(TaskDetails task) {
    this.task = task;
  }

  public Thread threadTs(Long threadTs) {
    this.threadTs = threadTs;
    return this;
  }

   /**
   * Get threadTs
   * @return threadTs
  **/
  @Schema(description = "")
  public Long getThreadTs() {
    return threadTs;
  }

  public void setThreadTs(Long threadTs) {
    this.threadTs = threadTs;
  }

  public Thread type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @Schema(description = "")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public Thread updatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @Schema(description = "")
  public Long getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }

  public Thread updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @Schema(description = "")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Thread thread = (Thread) o;
    return Objects.equals(this.about, thread.about) &&
        Objects.equals(this.addressedTo, thread.addressedTo) &&
        Objects.equals(this.announcement, thread.announcement) &&
        Objects.equals(this.createdBy, thread.createdBy) &&
        Objects.equals(this.entityId, thread.entityId) &&
        Objects.equals(this.href, thread.href) &&
        Objects.equals(this.id, thread.id) &&
        Objects.equals(this.message, thread.message) &&
        Objects.equals(this.posts, thread.posts) &&
        Objects.equals(this.postsCount, thread.postsCount) &&
        Objects.equals(this.reactions, thread.reactions) &&
        Objects.equals(this.resolved, thread.resolved) &&
        Objects.equals(this.task, thread.task) &&
        Objects.equals(this.threadTs, thread.threadTs) &&
        Objects.equals(this.type, thread.type) &&
        Objects.equals(this.updatedAt, thread.updatedAt) &&
        Objects.equals(this.updatedBy, thread.updatedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(about, addressedTo, announcement, createdBy, entityId, href, id, message, posts, postsCount, reactions, resolved, task, threadTs, type, updatedAt, updatedBy);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Thread {\n");
    
    sb.append("    about: ").append(toIndentedString(about)).append("\n");
    sb.append("    addressedTo: ").append(toIndentedString(addressedTo)).append("\n");
    sb.append("    announcement: ").append(toIndentedString(announcement)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    posts: ").append(toIndentedString(posts)).append("\n");
    sb.append("    postsCount: ").append(toIndentedString(postsCount)).append("\n");
    sb.append("    reactions: ").append(toIndentedString(reactions)).append("\n");
    sb.append("    resolved: ").append(toIndentedString(resolved)).append("\n");
    sb.append("    task: ").append(toIndentedString(task)).append("\n");
    sb.append("    threadTs: ").append(toIndentedString(threadTs)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
