/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
/**
 * TimeValue
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class TimeValue {
  @JsonProperty("days")
  private Long days = null;

  @JsonProperty("daysFrac")
  private Double daysFrac = null;

  @JsonProperty("hours")
  private Long hours = null;

  @JsonProperty("hoursFrac")
  private Double hoursFrac = null;

  @JsonProperty("micros")
  private Long micros = null;

  @JsonProperty("microsFrac")
  private Double microsFrac = null;

  @JsonProperty("millis")
  private Long millis = null;

  @JsonProperty("millisFrac")
  private Double millisFrac = null;

  @JsonProperty("minutes")
  private Long minutes = null;

  @JsonProperty("minutesFrac")
  private Double minutesFrac = null;

  @JsonProperty("nanos")
  private Long nanos = null;

  @JsonProperty("seconds")
  private Long seconds = null;

  @JsonProperty("secondsFrac")
  private Double secondsFrac = null;

  @JsonProperty("stringRep")
  private String stringRep = null;

  public TimeValue days(Long days) {
    this.days = days;
    return this;
  }

   /**
   * Get days
   * @return days
  **/
  @Schema(description = "")
  public Long getDays() {
    return days;
  }

  public void setDays(Long days) {
    this.days = days;
  }

  public TimeValue daysFrac(Double daysFrac) {
    this.daysFrac = daysFrac;
    return this;
  }

   /**
   * Get daysFrac
   * @return daysFrac
  **/
  @Schema(description = "")
  public Double getDaysFrac() {
    return daysFrac;
  }

  public void setDaysFrac(Double daysFrac) {
    this.daysFrac = daysFrac;
  }

  public TimeValue hours(Long hours) {
    this.hours = hours;
    return this;
  }

   /**
   * Get hours
   * @return hours
  **/
  @Schema(description = "")
  public Long getHours() {
    return hours;
  }

  public void setHours(Long hours) {
    this.hours = hours;
  }

  public TimeValue hoursFrac(Double hoursFrac) {
    this.hoursFrac = hoursFrac;
    return this;
  }

   /**
   * Get hoursFrac
   * @return hoursFrac
  **/
  @Schema(description = "")
  public Double getHoursFrac() {
    return hoursFrac;
  }

  public void setHoursFrac(Double hoursFrac) {
    this.hoursFrac = hoursFrac;
  }

  public TimeValue micros(Long micros) {
    this.micros = micros;
    return this;
  }

   /**
   * Get micros
   * @return micros
  **/
  @Schema(description = "")
  public Long getMicros() {
    return micros;
  }

  public void setMicros(Long micros) {
    this.micros = micros;
  }

  public TimeValue microsFrac(Double microsFrac) {
    this.microsFrac = microsFrac;
    return this;
  }

   /**
   * Get microsFrac
   * @return microsFrac
  **/
  @Schema(description = "")
  public Double getMicrosFrac() {
    return microsFrac;
  }

  public void setMicrosFrac(Double microsFrac) {
    this.microsFrac = microsFrac;
  }

  public TimeValue millis(Long millis) {
    this.millis = millis;
    return this;
  }

   /**
   * Get millis
   * @return millis
  **/
  @Schema(description = "")
  public Long getMillis() {
    return millis;
  }

  public void setMillis(Long millis) {
    this.millis = millis;
  }

  public TimeValue millisFrac(Double millisFrac) {
    this.millisFrac = millisFrac;
    return this;
  }

   /**
   * Get millisFrac
   * @return millisFrac
  **/
  @Schema(description = "")
  public Double getMillisFrac() {
    return millisFrac;
  }

  public void setMillisFrac(Double millisFrac) {
    this.millisFrac = millisFrac;
  }

  public TimeValue minutes(Long minutes) {
    this.minutes = minutes;
    return this;
  }

   /**
   * Get minutes
   * @return minutes
  **/
  @Schema(description = "")
  public Long getMinutes() {
    return minutes;
  }

  public void setMinutes(Long minutes) {
    this.minutes = minutes;
  }

  public TimeValue minutesFrac(Double minutesFrac) {
    this.minutesFrac = minutesFrac;
    return this;
  }

   /**
   * Get minutesFrac
   * @return minutesFrac
  **/
  @Schema(description = "")
  public Double getMinutesFrac() {
    return minutesFrac;
  }

  public void setMinutesFrac(Double minutesFrac) {
    this.minutesFrac = minutesFrac;
  }

  public TimeValue nanos(Long nanos) {
    this.nanos = nanos;
    return this;
  }

   /**
   * Get nanos
   * @return nanos
  **/
  @Schema(description = "")
  public Long getNanos() {
    return nanos;
  }

  public void setNanos(Long nanos) {
    this.nanos = nanos;
  }

  public TimeValue seconds(Long seconds) {
    this.seconds = seconds;
    return this;
  }

   /**
   * Get seconds
   * @return seconds
  **/
  @Schema(description = "")
  public Long getSeconds() {
    return seconds;
  }

  public void setSeconds(Long seconds) {
    this.seconds = seconds;
  }

  public TimeValue secondsFrac(Double secondsFrac) {
    this.secondsFrac = secondsFrac;
    return this;
  }

   /**
   * Get secondsFrac
   * @return secondsFrac
  **/
  @Schema(description = "")
  public Double getSecondsFrac() {
    return secondsFrac;
  }

  public void setSecondsFrac(Double secondsFrac) {
    this.secondsFrac = secondsFrac;
  }

  public TimeValue stringRep(String stringRep) {
    this.stringRep = stringRep;
    return this;
  }

   /**
   * Get stringRep
   * @return stringRep
  **/
  @Schema(description = "")
  public String getStringRep() {
    return stringRep;
  }

  public void setStringRep(String stringRep) {
    this.stringRep = stringRep;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TimeValue timeValue = (TimeValue) o;
    return Objects.equals(this.days, timeValue.days) &&
        Objects.equals(this.daysFrac, timeValue.daysFrac) &&
        Objects.equals(this.hours, timeValue.hours) &&
        Objects.equals(this.hoursFrac, timeValue.hoursFrac) &&
        Objects.equals(this.micros, timeValue.micros) &&
        Objects.equals(this.microsFrac, timeValue.microsFrac) &&
        Objects.equals(this.millis, timeValue.millis) &&
        Objects.equals(this.millisFrac, timeValue.millisFrac) &&
        Objects.equals(this.minutes, timeValue.minutes) &&
        Objects.equals(this.minutesFrac, timeValue.minutesFrac) &&
        Objects.equals(this.nanos, timeValue.nanos) &&
        Objects.equals(this.seconds, timeValue.seconds) &&
        Objects.equals(this.secondsFrac, timeValue.secondsFrac) &&
        Objects.equals(this.stringRep, timeValue.stringRep);
  }

  @Override
  public int hashCode() {
    return Objects.hash(days, daysFrac, hours, hoursFrac, micros, microsFrac, millis, millisFrac, minutes, minutesFrac, nanos, seconds, secondsFrac, stringRep);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TimeValue {\n");
    
    sb.append("    days: ").append(toIndentedString(days)).append("\n");
    sb.append("    daysFrac: ").append(toIndentedString(daysFrac)).append("\n");
    sb.append("    hours: ").append(toIndentedString(hours)).append("\n");
    sb.append("    hoursFrac: ").append(toIndentedString(hoursFrac)).append("\n");
    sb.append("    micros: ").append(toIndentedString(micros)).append("\n");
    sb.append("    microsFrac: ").append(toIndentedString(microsFrac)).append("\n");
    sb.append("    millis: ").append(toIndentedString(millis)).append("\n");
    sb.append("    millisFrac: ").append(toIndentedString(millisFrac)).append("\n");
    sb.append("    minutes: ").append(toIndentedString(minutes)).append("\n");
    sb.append("    minutesFrac: ").append(toIndentedString(minutesFrac)).append("\n");
    sb.append("    nanos: ").append(toIndentedString(nanos)).append("\n");
    sb.append("    seconds: ").append(toIndentedString(seconds)).append("\n");
    sb.append("    secondsFrac: ").append(toIndentedString(secondsFrac)).append("\n");
    sb.append("    stringRep: ").append(toIndentedString(stringRep)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
