/*
 * OpenMetadata Apis
 * --- title: APIs slug: /main-concepts/metadata-standard/apis ---  # APIs  OpenMetadata supports REST APIs for getting data and in and out of the metadata system. APIs are built using general best practices of REST API design. We take a schema-first approach by defining Types and Entities in JSON Schema. We implement APIs based on these schemas.  ## Overview  ### URI  Following REST API conventions are followed for Resource URIs: - Operations for an entity are available through the Resource URI as a collection `.../api/<version>/entities`.    Plural of the entity name is used as the collection name - example `.../api/v1/users`. - Trailing forward slash is not used in the endpoint URI. Example use `.../api/v1/databases` instead of `.../api/v1/databases/`. - Resource URI for an entity instance by the entity id is `.../api/v1/entities/{id}`. Resource URI for an entity    instance by name is `.../api/v1/entities/name/{name}`.  ### Resource Representation  - The REST API calls return a response with JSON `Content-Type` and `Content-Length` that includes the length of the response. - All responses include the Resource ID field even though the id was provided in the request to simplify the consumption    of the response at the client. - Entity names and field names use `camelCase` per Javascript naming convention. - All resources include an attribute `href` with Resource URI. All relationship fields of an entity will also    include `href` links to the related resource for easy access. - Unknown fields sent by the client in API requests are not ignored to ensure the data sent by the client is not dropped    at the server without the user being aware of it.  ## API Organization  You can find the swagger documentation [here](/swagger.html). In a nutshell:  Data Asset APIs - These API endpoints support operations related to data asset entities. - `.../api/v1/databases` - `...api/v1/tables` - `.../api/v1/metrics` - `.../api/v1/dashboards` - `.../api/v1/reports` - `.../api/v1/pipelines` - `.../api/v1/topics`  Service APIs - These API endpoints support operations related to services from which metadata is collected: - `.../api/v1/services` is the collection of all service resources. - `.../api/v1/services/databaseService` - APIs related to database services. This includes transactional databases - MySQL, Postgres, MSSQL, Oracle, and data warehouses - Apache Hive BigQuery, Redshift, and Snowflake. - `.../api/v1/services/dashboardService` - APIs related to dashboard services. This includes Looker, Superset, and Tableau. - `.../api/v1/services/messaingService` - APIs related to messaging services. This includes Apache Kafka and Apache Pulsar (work in progress).  Teams & Users APIs - `.../api/v1/teams` - APIs related to team entities - `.../api/v1/users` - APIs related to user entities  Search & Suggest APIs - These API endpoints support search and suggest APIs: - `.../api/v1/search` - collection for search and suggest APIs - `.../api/v1/search/query` - search entities using query text - `.../api/v1/search/suggest` - get suggested entities used for auto-completion  Other APIs - `.../api/v1/tags` for APIs related to Classification and Tag entities - `../api/v1/feeds` for APIs related to Threads and Posts entities - `.../api/v1/usage` for reporting usage information of entities  ## Implementation Notes  We use the [Dropwizard](https://www.dropwizard.io/en/latest/) Java framework for developing Restful web services.  APIs are documented using [Swagger/OpenAPI 3.x](https://swagger.io/specification/). We take schema first approach and define metadata entities and types in [JSON schema](https://json-schema.org/)  specification version [Draft-07 to 2019-09](https://json-schema.org/draft/2019-09/release-notes.html). Java code is  generated from the JSON schema using [JSON schema 2 pojo](https://www.jsonschema2pojo.org/) tool and Python code is  generated using the [Data model code generator](https://github.com/koxudaxi/datamodel-code-generator) tool.
 *
 * OpenAPI spec version: 0.13.2
 * Contact: openmetadata-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.openmetadata.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.model.AuthenticationMechanism;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.Profile;
import org.openmetadata.client.model.TagLabel;
/**
 * User
 */

@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.JavaClientCodegen", date = "2023-01-30T08:44:05.249587Z[Etc/UTC]")
public class User {
  @JsonProperty("authenticationMechanism")
  private AuthenticationMechanism authenticationMechanism = null;

  @JsonProperty("changeDescription")
  private ChangeDescription changeDescription = null;

  @JsonProperty("deleted")
  private Boolean deleted = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("extension")
  private Object extension = null;

  @JsonProperty("followers")
  private List<EntityReference> followers = null;

  @JsonProperty("follows")
  private List<EntityReference> follows = null;

  @JsonProperty("fullyQualifiedName")
  private String fullyQualifiedName = null;

  @JsonProperty("href")
  private String href = null;

  @JsonProperty("id")
  private UUID id = null;

  @JsonProperty("inheritedRoles")
  private List<EntityReference> inheritedRoles = null;

  @JsonProperty("isAdmin")
  private Boolean isAdmin = null;

  @JsonProperty("isBot")
  private Boolean isBot = null;

  @JsonProperty("isEmailVerified")
  private Boolean isEmailVerified = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("owner")
  private EntityReference owner = null;

  @JsonProperty("owns")
  private List<EntityReference> owns = null;

  @JsonProperty("profile")
  private Profile profile = null;

  /**
   * Gets or Sets provider
   */
  public enum ProviderEnum {
    SYSTEM("system"),
    USER("user");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }
    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    @JsonCreator
    public static ProviderEnum fromValue(String text) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

  }  @JsonProperty("provider")
  private ProviderEnum provider = null;

  @JsonProperty("roles")
  private List<EntityReference> roles = null;

  @JsonProperty("tags")
  private List<TagLabel> tags = null;

  @JsonProperty("teams")
  private List<EntityReference> teams = null;

  @JsonProperty("timezone")
  private String timezone = null;

  @JsonProperty("updatedAt")
  private Long updatedAt = null;

  @JsonProperty("updatedBy")
  private String updatedBy = null;

  @JsonProperty("version")
  private Double version = null;

  public User authenticationMechanism(AuthenticationMechanism authenticationMechanism) {
    this.authenticationMechanism = authenticationMechanism;
    return this;
  }

   /**
   * Get authenticationMechanism
   * @return authenticationMechanism
  **/
  @Schema(description = "")
  public AuthenticationMechanism getAuthenticationMechanism() {
    return authenticationMechanism;
  }

  public void setAuthenticationMechanism(AuthenticationMechanism authenticationMechanism) {
    this.authenticationMechanism = authenticationMechanism;
  }

  public User changeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
    return this;
  }

   /**
   * Get changeDescription
   * @return changeDescription
  **/
  @Schema(description = "")
  public ChangeDescription getChangeDescription() {
    return changeDescription;
  }

  public void setChangeDescription(ChangeDescription changeDescription) {
    this.changeDescription = changeDescription;
  }

  public User deleted(Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @Schema(description = "")
  public Boolean isDeleted() {
    return deleted;
  }

  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }

  public User description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @Schema(description = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public User displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @Schema(description = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public User email(String email) {
    this.email = email;
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @Schema(required = true, description = "")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public User extension(Object extension) {
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @Schema(description = "")
  public Object getExtension() {
    return extension;
  }

  public void setExtension(Object extension) {
    this.extension = extension;
  }

  public User followers(List<EntityReference> followers) {
    this.followers = followers;
    return this;
  }

  public User addFollowersItem(EntityReference followersItem) {
    if (this.followers == null) {
      this.followers = new ArrayList<EntityReference>();
    }
    this.followers.add(followersItem);
    return this;
  }

   /**
   * Get followers
   * @return followers
  **/
  @Schema(description = "")
  public List<EntityReference> getFollowers() {
    return followers;
  }

  public void setFollowers(List<EntityReference> followers) {
    this.followers = followers;
  }

  public User follows(List<EntityReference> follows) {
    this.follows = follows;
    return this;
  }

  public User addFollowsItem(EntityReference followsItem) {
    if (this.follows == null) {
      this.follows = new ArrayList<EntityReference>();
    }
    this.follows.add(followsItem);
    return this;
  }

   /**
   * Get follows
   * @return follows
  **/
  @Schema(description = "")
  public List<EntityReference> getFollows() {
    return follows;
  }

  public void setFollows(List<EntityReference> follows) {
    this.follows = follows;
  }

  public User fullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

   /**
   * Get fullyQualifiedName
   * @return fullyQualifiedName
  **/
  @Schema(description = "")
  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }

  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }

  public User href(String href) {
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @Schema(required = true, description = "")
  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public User id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(required = true, description = "")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public User inheritedRoles(List<EntityReference> inheritedRoles) {
    this.inheritedRoles = inheritedRoles;
    return this;
  }

  public User addInheritedRolesItem(EntityReference inheritedRolesItem) {
    if (this.inheritedRoles == null) {
      this.inheritedRoles = new ArrayList<EntityReference>();
    }
    this.inheritedRoles.add(inheritedRolesItem);
    return this;
  }

   /**
   * Get inheritedRoles
   * @return inheritedRoles
  **/
  @Schema(description = "")
  public List<EntityReference> getInheritedRoles() {
    return inheritedRoles;
  }

  public void setInheritedRoles(List<EntityReference> inheritedRoles) {
    this.inheritedRoles = inheritedRoles;
  }

  public User isAdmin(Boolean isAdmin) {
    this.isAdmin = isAdmin;
    return this;
  }

   /**
   * Get isAdmin
   * @return isAdmin
  **/
  @Schema(description = "")
  public Boolean isIsAdmin() {
    return isAdmin;
  }

  public void setIsAdmin(Boolean isAdmin) {
    this.isAdmin = isAdmin;
  }

  public User isBot(Boolean isBot) {
    this.isBot = isBot;
    return this;
  }

   /**
   * Get isBot
   * @return isBot
  **/
  @Schema(description = "")
  public Boolean isIsBot() {
    return isBot;
  }

  public void setIsBot(Boolean isBot) {
    this.isBot = isBot;
  }

  public User isEmailVerified(Boolean isEmailVerified) {
    this.isEmailVerified = isEmailVerified;
    return this;
  }

   /**
   * Get isEmailVerified
   * @return isEmailVerified
  **/
  @Schema(description = "")
  public Boolean isIsEmailVerified() {
    return isEmailVerified;
  }

  public void setIsEmailVerified(Boolean isEmailVerified) {
    this.isEmailVerified = isEmailVerified;
  }

  public User name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public User owner(EntityReference owner) {
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @Schema(description = "")
  public EntityReference getOwner() {
    return owner;
  }

  public void setOwner(EntityReference owner) {
    this.owner = owner;
  }

  public User owns(List<EntityReference> owns) {
    this.owns = owns;
    return this;
  }

  public User addOwnsItem(EntityReference ownsItem) {
    if (this.owns == null) {
      this.owns = new ArrayList<EntityReference>();
    }
    this.owns.add(ownsItem);
    return this;
  }

   /**
   * Get owns
   * @return owns
  **/
  @Schema(description = "")
  public List<EntityReference> getOwns() {
    return owns;
  }

  public void setOwns(List<EntityReference> owns) {
    this.owns = owns;
  }

  public User profile(Profile profile) {
    this.profile = profile;
    return this;
  }

   /**
   * Get profile
   * @return profile
  **/
  @Schema(description = "")
  public Profile getProfile() {
    return profile;
  }

  public void setProfile(Profile profile) {
    this.profile = profile;
  }

  public User provider(ProviderEnum provider) {
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @Schema(description = "")
  public ProviderEnum getProvider() {
    return provider;
  }

  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }

  public User roles(List<EntityReference> roles) {
    this.roles = roles;
    return this;
  }

  public User addRolesItem(EntityReference rolesItem) {
    if (this.roles == null) {
      this.roles = new ArrayList<EntityReference>();
    }
    this.roles.add(rolesItem);
    return this;
  }

   /**
   * Get roles
   * @return roles
  **/
  @Schema(description = "")
  public List<EntityReference> getRoles() {
    return roles;
  }

  public void setRoles(List<EntityReference> roles) {
    this.roles = roles;
  }

  public User tags(List<TagLabel> tags) {
    this.tags = tags;
    return this;
  }

  public User addTagsItem(TagLabel tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<TagLabel>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @Schema(description = "")
  public List<TagLabel> getTags() {
    return tags;
  }

  public void setTags(List<TagLabel> tags) {
    this.tags = tags;
  }

  public User teams(List<EntityReference> teams) {
    this.teams = teams;
    return this;
  }

  public User addTeamsItem(EntityReference teamsItem) {
    if (this.teams == null) {
      this.teams = new ArrayList<EntityReference>();
    }
    this.teams.add(teamsItem);
    return this;
  }

   /**
   * Get teams
   * @return teams
  **/
  @Schema(description = "")
  public List<EntityReference> getTeams() {
    return teams;
  }

  public void setTeams(List<EntityReference> teams) {
    this.teams = teams;
  }

  public User timezone(String timezone) {
    this.timezone = timezone;
    return this;
  }

   /**
   * Get timezone
   * @return timezone
  **/
  @Schema(description = "")
  public String getTimezone() {
    return timezone;
  }

  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }

  public User updatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @Schema(description = "")
  public Long getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(Long updatedAt) {
    this.updatedAt = updatedAt;
  }

  public User updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * Get updatedBy
   * @return updatedBy
  **/
  @Schema(description = "")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  public User version(Double version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @Schema(description = "")
  public Double getVersion() {
    return version;
  }

  public void setVersion(Double version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    User user = (User) o;
    return Objects.equals(this.authenticationMechanism, user.authenticationMechanism) &&
        Objects.equals(this.changeDescription, user.changeDescription) &&
        Objects.equals(this.deleted, user.deleted) &&
        Objects.equals(this.description, user.description) &&
        Objects.equals(this.displayName, user.displayName) &&
        Objects.equals(this.email, user.email) &&
        Objects.equals(this.extension, user.extension) &&
        Objects.equals(this.followers, user.followers) &&
        Objects.equals(this.follows, user.follows) &&
        Objects.equals(this.fullyQualifiedName, user.fullyQualifiedName) &&
        Objects.equals(this.href, user.href) &&
        Objects.equals(this.id, user.id) &&
        Objects.equals(this.inheritedRoles, user.inheritedRoles) &&
        Objects.equals(this.isAdmin, user.isAdmin) &&
        Objects.equals(this.isBot, user.isBot) &&
        Objects.equals(this.isEmailVerified, user.isEmailVerified) &&
        Objects.equals(this.name, user.name) &&
        Objects.equals(this.owner, user.owner) &&
        Objects.equals(this.owns, user.owns) &&
        Objects.equals(this.profile, user.profile) &&
        Objects.equals(this.provider, user.provider) &&
        Objects.equals(this.roles, user.roles) &&
        Objects.equals(this.tags, user.tags) &&
        Objects.equals(this.teams, user.teams) &&
        Objects.equals(this.timezone, user.timezone) &&
        Objects.equals(this.updatedAt, user.updatedAt) &&
        Objects.equals(this.updatedBy, user.updatedBy) &&
        Objects.equals(this.version, user.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authenticationMechanism, changeDescription, deleted, description, displayName, email, extension, followers, follows, fullyQualifiedName, href, id, inheritedRoles, isAdmin, isBot, isEmailVerified, name, owner, owns, profile, provider, roles, tags, teams, timezone, updatedAt, updatedBy, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class User {\n");
    
    sb.append("    authenticationMechanism: ").append(toIndentedString(authenticationMechanism)).append("\n");
    sb.append("    changeDescription: ").append(toIndentedString(changeDescription)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("    followers: ").append(toIndentedString(followers)).append("\n");
    sb.append("    follows: ").append(toIndentedString(follows)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inheritedRoles: ").append(toIndentedString(inheritedRoles)).append("\n");
    sb.append("    isAdmin: ").append(toIndentedString(isAdmin)).append("\n");
    sb.append("    isBot: ").append(toIndentedString(isBot)).append("\n");
    sb.append("    isEmailVerified: ").append(toIndentedString(isEmailVerified)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    owns: ").append(toIndentedString(owns)).append("\n");
    sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    teams: ").append(toIndentedString(teams)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
