/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.listener;

import cn.dev33.satoken.annotation.handler.SaAnnotationHandlerInterface;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.listener.SaTokenListener;
import cn.dev33.satoken.listener.SaTokenListenerForLog;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import java.util.ArrayList;
import java.util.List;

public class SaTokenEventCenter {
    private static List<SaTokenListener> listenerList = new ArrayList<SaTokenListener>();

    public static List<SaTokenListener> getListenerList() {
        return listenerList;
    }

    public static void setListenerList(List<SaTokenListener> listenerList) {
        if (listenerList == null) {
            throw new SaTokenException("\u91cd\u7f6e\u7684\u4fa6\u542c\u5668\u96c6\u5408\u4e0d\u53ef\u4ee5\u4e3a\u7a7a").setCode(10031);
        }
        SaTokenEventCenter.listenerList = listenerList;
    }

    public static void registerListener(SaTokenListener listener) {
        if (listener == null) {
            throw new SaTokenException("\u6ce8\u518c\u7684\u4fa6\u542c\u5668\u4e0d\u53ef\u4ee5\u4e3a\u7a7a").setCode(10032);
        }
        listenerList.add(listener);
    }

    public static void registerListenerList(List<SaTokenListener> listenerList) {
        if (listenerList == null) {
            throw new SaTokenException("\u6ce8\u518c\u7684\u4fa6\u542c\u5668\u96c6\u5408\u4e0d\u53ef\u4ee5\u4e3a\u7a7a").setCode(10031);
        }
        for (SaTokenListener listener : listenerList) {
            if (listener != null) continue;
            throw new SaTokenException("\u6ce8\u518c\u7684\u4fa6\u542c\u5668\u4e0d\u53ef\u4ee5\u4e3a\u7a7a").setCode(10032);
        }
        SaTokenEventCenter.listenerList.addAll(listenerList);
    }

    public static void removeListener(SaTokenListener listener) {
        listenerList.remove(listener);
    }

    public static void removeListener(Class<? extends SaTokenListener> cls) {
        ArrayList<SaTokenListener> listenerListCopy = new ArrayList<SaTokenListener>(listenerList);
        for (SaTokenListener listener : listenerListCopy) {
            if (!cls.isAssignableFrom(listener.getClass())) continue;
            listenerList.remove(listener);
        }
    }

    public static void clearListener() {
        listenerList.clear();
    }

    public static boolean hasListener(SaTokenListener listener) {
        return listenerList.contains(listener);
    }

    public static boolean hasListener(Class<? extends SaTokenListener> cls) {
        for (SaTokenListener listener : listenerList) {
            if (!cls.isAssignableFrom(listener.getClass())) continue;
            return true;
        }
        return false;
    }

    public static void doLogin(String loginType, Object loginId, String tokenValue, SaLoginParameter loginParameter) {
        for (SaTokenListener listener : listenerList) {
            listener.doLogin(loginType, loginId, tokenValue, loginParameter);
        }
    }

    public static void doLogout(String loginType, Object loginId, String tokenValue) {
        for (SaTokenListener listener : listenerList) {
            listener.doLogout(loginType, loginId, tokenValue);
        }
    }

    public static void doKickout(String loginType, Object loginId, String tokenValue) {
        for (SaTokenListener listener : listenerList) {
            listener.doKickout(loginType, loginId, tokenValue);
        }
    }

    public static void doReplaced(String loginType, Object loginId, String tokenValue) {
        for (SaTokenListener listener : listenerList) {
            listener.doReplaced(loginType, loginId, tokenValue);
        }
    }

    public static void doDisable(String loginType, Object loginId, String service, int level, long disableTime) {
        for (SaTokenListener listener : listenerList) {
            listener.doDisable(loginType, loginId, service, level, disableTime);
        }
    }

    public static void doUntieDisable(String loginType, Object loginId, String service) {
        for (SaTokenListener listener : listenerList) {
            listener.doUntieDisable(loginType, loginId, service);
        }
    }

    public static void doOpenSafe(String loginType, String tokenValue, String service, long safeTime) {
        for (SaTokenListener listener : listenerList) {
            listener.doOpenSafe(loginType, tokenValue, service, safeTime);
        }
    }

    public static void doCloseSafe(String loginType, String tokenValue, String service) {
        for (SaTokenListener listener : listenerList) {
            listener.doCloseSafe(loginType, tokenValue, service);
        }
    }

    public static void doCreateSession(String id) {
        for (SaTokenListener listener : listenerList) {
            listener.doCreateSession(id);
        }
    }

    public static void doLogoutSession(String id) {
        for (SaTokenListener listener : listenerList) {
            listener.doLogoutSession(id);
        }
    }

    public static void doRenewTimeout(String loginType, Object loginId, String tokenValue, long timeout) {
        for (SaTokenListener listener : listenerList) {
            listener.doRenewTimeout(loginType, loginId, tokenValue, timeout);
        }
    }

    public static void doRegisterComponent(String compName, Object compObj) {
        for (SaTokenListener listener : listenerList) {
            listener.doRegisterComponent(compName, compObj);
        }
    }

    public static void doRegisterAnnotationHandler(SaAnnotationHandlerInterface<?> handler) {
        for (SaTokenListener listener : listenerList) {
            listener.doRegisterAnnotationHandler(handler);
        }
    }

    public static void doSetStpLogic(StpLogic stpLogic) {
        for (SaTokenListener listener : listenerList) {
            listener.doSetStpLogic(stpLogic);
        }
    }

    public static void doSetConfig(SaTokenConfig config) {
        for (SaTokenListener listener : listenerList) {
            listener.doSetConfig(config);
        }
    }

    static {
        listenerList.add(new SaTokenListenerForLog());
    }
}

