/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.base.exception;

import cn.yzw.infra.component.base.exception.AbstractException;
import cn.yzw.infra.component.base.exception.code.ErrorCode;
import cn.yzw.infra.component.base.exception.code.SystemErrorCode;

public class BusinessException
extends AbstractException {
    private BusinessException(String message) {
        super(SystemErrorCode.BUSINESS_EXCEPTION, message);
    }

    private BusinessException(ErrorCode code) {
        super(code);
    }

    private BusinessException(ErrorCode code, String message) {
        super(code, message);
    }

    private BusinessException(ErrorCode code, String message, Throwable ex) {
        super(code, message, ex);
    }

    public static BusinessException create(String message) {
        return BusinessException.create(SystemErrorCode.BUSINESS_EXCEPTION.getCode(), message);
    }

    public static BusinessException dataNotExists() {
        return BusinessException.create(SystemErrorCode.DATA_NOT_EXISTS);
    }

    public static BusinessException create(final int code, final String message) {
        return new BusinessException(new ErrorCode(){

            @Override
            public int getCode() {
                return code;
            }

            @Override
            public String getMessage() {
                return message;
            }
        });
    }

    public static BusinessException create(ErrorCode errorCode) {
        return new BusinessException(errorCode);
    }

    public static BusinessException create(ErrorCode errorCode, String message) {
        if (null == message) {
            return BusinessException.create(errorCode);
        }
        return new BusinessException(errorCode, message);
    }

    public static BusinessException create(ErrorCode errorCode, String message, Throwable exception) {
        if (null == exception) {
            return BusinessException.create(errorCode, message);
        }
        if (exception instanceof BusinessException) {
            BusinessException source = (BusinessException)exception;
            if (null != errorCode && errorCode.getCode() != source.getCode()) {
                return new BusinessException(errorCode, message, source);
            }
            return source;
        }
        return new BusinessException(errorCode, message, exception);
    }
}

