/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.base.model;

import cn.yzw.infra.component.base.exception.code.ErrorCode;
import cn.yzw.infra.component.base.exception.code.SystemErrorCode;
import java.io.Serializable;

public class YzwResult<T>
implements Serializable {
    private static final long serialVersionUID = 2081104351106889132L;
    private boolean success;
    private int code;
    private String message;
    private T data;

    private YzwResult() {
        this.success = true;
        this.code = SystemErrorCode.SUCCESS.getCode();
        this.message = SystemErrorCode.SUCCESS.getMessage();
    }

    private YzwResult(T data) {
        this.success = true;
        this.code = SystemErrorCode.SUCCESS.getCode();
        this.message = SystemErrorCode.SUCCESS.getMessage();
        this.data = data;
    }

    private YzwResult(int code, String message) {
        this.success = false;
        this.code = code;
        this.message = message;
    }

    private YzwResult(int code, String message, T data) {
        this.success = false;
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> YzwResult<T> success() {
        return new YzwResult<T>();
    }

    public static <T> YzwResult<T> success(T data) {
        return new YzwResult<T>(data);
    }

    public static <T> YzwResult<T> error(int code, String message) {
        return new YzwResult<T>(code, message);
    }

    public static <T> YzwResult<T> error(ErrorCode errorCode) {
        return new YzwResult<T>(errorCode.getCode(), errorCode.getMessage());
    }

    public static <T> YzwResult<T> error(ErrorCode errorCode, T data) {
        return new YzwResult<T>(errorCode.getCode(), errorCode.getMessage(), data);
    }

    public static <T> YzwResult<T> badRequest(String message) {
        return new YzwResult<T>(SystemErrorCode.BAD_REQUEST.getCode(), message);
    }

    public static <T> YzwResult<T> badRequest(String message, T data) {
        return new YzwResult<T>(SystemErrorCode.BAD_REQUEST.getCode(), message, data);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YzwResult)) {
            return false;
        }
        YzwResult other = (YzwResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof YzwResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "YzwResult(success=" + this.isSuccess() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

