/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.base.model.page;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class PageRequest<T>
implements Serializable {
    private static final long serialVersionUID = -6380378186325034951L;
    private static final Pattern pattern = Pattern.compile("[A-Z]");
    public static final int DEFAULT_PAGE_NUM = 1;
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int MAX_PAGE_SIZE = 1000;
    public static final String DEFAULT_ORDER_BY_FIELD = "id";
    public static final Direction DEFAULT_PAGE_ORDER = Direction.DESC;
    private int pageNum = 1;
    private int pageSize = 10;
    private int pageStart;
    private String orderBy = "id";
    private Direction direction = DEFAULT_PAGE_ORDER;
    @Valid
    private T param;

    public void setPageStart() {
        this.pageStart = (this.pageNum - 1) * this.pageSize;
    }

    public Integer getPageStart() {
        return (this.pageNum - 1) * this.pageSize;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = Math.max(pageNum, 1);
    }

    public void setPageSize(int pageSize) {
        this.pageSize = Math.min(pageSize, 1000);
    }

    public String buildOrderBy() {
        this.orderBy = StringUtils.isNotBlank((CharSequence)this.orderBy) ? this.orderBy : DEFAULT_ORDER_BY_FIELD;
        this.direction = this.direction != null ? this.direction : DEFAULT_PAGE_ORDER;
        return this.convert2ColumnName(this.orderBy) + " " + (Object)((Object)this.direction);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    private String convert2ColumnName(String fieldName) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return fieldName;
        }
        Matcher matcher = pattern.matcher(fieldName);
        while (matcher.find()) {
            String old = matcher.group();
            String ne = matcher.group().toLowerCase();
            fieldName = fieldName.replaceAll(old, "_" + ne);
        }
        return fieldName;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public T getParam() {
        return this.param;
    }

    public void setPageStart(int pageStart) {
        this.pageStart = pageStart;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setParam(T param) {
        this.param = param;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageRequest)) {
            return false;
        }
        PageRequest other = (PageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        Integer this$pageStart = this.getPageStart();
        Integer other$pageStart = other.getPageStart();
        if (this$pageStart == null ? other$pageStart != null : !((Object)this$pageStart).equals(other$pageStart)) {
            return false;
        }
        String this$orderBy = this.getOrderBy();
        String other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy)) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        T this$param = this.getParam();
        T other$param = other.getParam();
        return !(this$param == null ? other$param != null : !this$param.equals(other$param));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        Integer $pageStart = this.getPageStart();
        result = result * 59 + ($pageStart == null ? 43 : ((Object)$pageStart).hashCode());
        String $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        T $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        return result;
    }

    public static enum Direction {
        ASC("asc"),
        DESC("desc");

        private String code;

        private Direction(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

