/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.base.thread.factory;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger threadPoolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private boolean daemon;

    public NamedThreadFactory(String threadPoolName) {
        this(threadPoolName, false);
    }

    public NamedThreadFactory(String threadPoolName, boolean daemon) {
        SecurityManager s = System.getSecurityManager();
        this.group = Objects.nonNull(s) ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = threadPoolName + "-pool-" + threadPoolNumber.getAndIncrement() + "-thread-";
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        thread.setDaemon(this.daemon);
        return thread;
    }
}

