/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.bean;

import cn.yzw.infra.component.base.exception.code.SystemErrorCode;
import cn.yzw.infra.component.base.model.YzwResult;
import cn.yzw.infra.component.fss.api.FssClientApi;
import cn.yzw.infra.component.fss.http.FssOkHttp;
import cn.yzw.infra.component.fss.model.HttpConfig;
import cn.yzw.infra.component.fss.model.fcs.request.FcsCovertRequest;
import cn.yzw.infra.component.fss.model.fcs.response.FcsAsyncResponse;
import cn.yzw.infra.component.fss.model.fcs.response.FcsStatusResponse;
import cn.yzw.infra.component.fss.model.fcs.response.FcsSyncResponse;
import cn.yzw.infra.component.fss.model.fms.request.BatchImgAuditRequest;
import cn.yzw.infra.component.fss.model.fms.request.BatchTextAuditRequest;
import cn.yzw.infra.component.fss.model.fms.request.ImageAuditRequest;
import cn.yzw.infra.component.fss.model.fms.request.TextAuditRequest;
import cn.yzw.infra.component.fss.model.fms.response.AuditResponse;
import cn.yzw.infra.component.fss.model.fms.response.BatchAuditResponse;
import cn.yzw.infra.component.fss.model.fts.AuthRequest;
import cn.yzw.infra.component.fss.model.fts.FtsOptEnum;
import cn.yzw.infra.component.fss.model.request.BatchDownloadRequest;
import cn.yzw.infra.component.fss.model.request.CopyRequest;
import cn.yzw.infra.component.fss.model.request.FileHashRequest;
import cn.yzw.infra.component.fss.model.request.PreviewBatchRequest;
import cn.yzw.infra.component.fss.model.request.PreviewRequest;
import cn.yzw.infra.component.fss.model.request.WaterMarkRequest;
import cn.yzw.infra.component.fss.model.response.BatchDownloadResponse;
import cn.yzw.infra.component.fss.model.response.CopyResponse;
import cn.yzw.infra.component.fss.model.response.FileHashResponse;
import cn.yzw.infra.component.fss.model.response.FileInfoResponse;
import cn.yzw.infra.component.fss.model.response.FilePathMappingInfo;
import cn.yzw.infra.component.fss.model.response.FtsTokenResponse;
import cn.yzw.infra.component.fss.model.response.PreviewBatchResponse;
import cn.yzw.infra.component.fss.model.response.PreviewMultiResponse;
import cn.yzw.infra.component.fss.model.response.PreviewResponse;
import cn.yzw.infra.component.fss.model.response.UploadResponse;
import cn.yzw.infra.component.fss.model.response.WaterMarkResponse;
import cn.yzw.infra.component.fss.util.Base64Util;
import cn.yzw.infra.component.fss.util.FssUtil;
import cn.yzw.infra.component.fss.util.JsonUtils;
import cn.yzw.infra.component.fss.util.SecureUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FssClient
implements FssClientApi {
    private static final Logger log = LoggerFactory.getLogger(FssClient.class);
    private final String API_VERSION = "v1/fss";
    private final String HTTP_METHOD_POST = "POST";
    private final String uploadHandler;
    private final String uploadByUrlHandler;
    private final String uploadMultiHandler;
    private final String downloadHandler;
    private final String batchDownloadHandler;
    private final String previewHandler;
    private final String previewMultiHandler;
    private final String previewBatchHandler;
    private final String waterMarkHandler;
    private final String hashHandler;
    private final String infoHandler;
    private final String packageStateHandler;
    private final String deleteFileHandler;
    private final String fileIsExistHandler;
    private final String copyHandler;
    private final String filePathMappingInfoHandler;
    private final String upload4failoverHandler;
    private final String serverAddress;
    private final String appName;
    private final String appSecret;
    private final String securityToken;
    private final boolean openTenant;
    private final HttpConfig httpConfig;

    public FssClient(String serverAddress, String appName, String appSecret) {
        this(serverAddress, appName, appSecret, null);
    }

    public FssClient(String serverAddress, String appName, String appSecret, String securityToken) {
        this(serverAddress, appName, appSecret, securityToken, false, null);
    }

    public FssClient(String serverAddress, String appName, String appSecret, boolean openTenant, HttpConfig httpConfig) {
        this(serverAddress, appName, appSecret, null, openTenant, httpConfig);
    }

    public FssClient(String serverAddress, String appName, String appSecret, String securityToken, boolean openTenant, HttpConfig httpConfig) {
        this.serverAddress = serverAddress;
        this.appName = appName;
        this.appSecret = appSecret;
        this.securityToken = securityToken;
        this.openTenant = openTenant;
        this.httpConfig = httpConfig;
        this.uploadHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "uploadHandler.fss");
        this.uploadByUrlHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "uploadByUrlHandler.fss");
        this.uploadMultiHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "uploadMultiHandler.fss");
        this.downloadHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "downloadHandler.fss");
        this.batchDownloadHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "batchDownloadHandler.fss");
        this.previewHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "previewHandler.fss");
        this.previewMultiHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "previewMultiHandler.fss");
        this.previewBatchHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "previewBatchHandler.fss");
        this.waterMarkHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "waterMarkHandler.fss");
        this.hashHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "fileHashHandler.fss");
        this.infoHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "fileInfoHandler.fss");
        this.packageStateHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "packageStateHandler.fss");
        this.deleteFileHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "deleteFileHandler.fss");
        this.fileIsExistHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "fileIsExistHandler.fss");
        this.filePathMappingInfoHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "filePathMappingInfoHandler.fss");
        this.upload4failoverHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "upload4failover.fss");
        this.copyHandler = String.format("%s/%s/%s", serverAddress, "v1/fss", "copyHandler.fss");
    }

    @Override
    public YzwResult<UploadResponse> upload(File file, Map<String, String> extensionMap, Map<String, String> ... headers) {
        return this.upload(file, (String)null, extensionMap, headers);
    }

    @Override
    public YzwResult<UploadResponse> upload(File file, String filePath, Map<String, String> extensionMap, Map<String, String> ... headers) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)).addFormDataPart("appName", this.appName);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appName", this.appName);
        if (StringUtils.hasText((String)filePath)) {
            builder.addFormDataPart("customFilePath", filePath);
            paramMap.put("customFilePath", filePath);
        }
        if (null != extensionMap && extensionMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)entry.getKey()) || !StringUtils.hasLength((String)entry.getValue())) continue;
                builder.addFormDataPart(entry.getKey(), entry.getValue());
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.uploadHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<UploadResponse>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<UploadResponse> upload(String fileUrl, String fileName, Map<String, String> extensionMap, Map<String, String> ... headers) {
        Assert.hasLength((String)fileUrl, (String)"\u6587\u4ef6URL\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)fileName, (String)"\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("fileUrl", fileUrl);
        builder.addFormDataPart("fileName", fileName);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("fileUrl", fileUrl);
        paramMap.put("fileName", fileName);
        if (null != extensionMap && extensionMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)entry.getKey()) || !StringUtils.hasLength((String)entry.getValue())) continue;
                builder.addFormDataPart(entry.getKey(), entry.getValue());
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.uploadByUrlHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<UploadResponse>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<List<UploadResponse>> upload(List<File> fileList, Map<String, String> extensionMap, Map<String, String> ... headers) {
        Assert.notEmpty(fileList, (String)"\u6587\u4ef6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        fileList.forEach(file -> builder.addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)));
        builder.addFormDataPart("appName", this.appName);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appName", this.appName);
        if (null != extensionMap && extensionMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)entry.getKey()) || !StringUtils.hasLength((String)entry.getValue())) continue;
                builder.addFormDataPart(entry.getKey(), entry.getValue());
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.uploadMultiHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<List<UploadResponse>>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<UploadResponse> upload(String fileName, byte[] content, Map<String, String> extensionMap, Map<String, String> ... headers) {
        return this.upload(null, fileName, content, extensionMap, headers);
    }

    @Override
    public YzwResult<UploadResponse> upload(byte[] content, String filePath, Map<String, String> extensionMap, Map<String, String> ... headers) {
        Assert.hasLength((String)filePath, (String)"filePath\u4e0d\u80fd\u4e3a\u7a7a");
        Path path = Paths.get(filePath, new String[0]);
        return this.upload(filePath, null == path ? null : path.getFileName().toString(), content, extensionMap, headers);
    }

    @Override
    public YzwResult<UploadResponse> upload(String filePath, String fileName, byte[] content, Map<String, String> extensionMap, Map<String, String> ... headers) {
        Assert.hasLength((String)fileName, (String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((content != null && content.length > 0 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileName, RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])content)).addFormDataPart("appName", this.appName);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appName", this.appName);
        if (StringUtils.hasText((String)filePath)) {
            builder.addFormDataPart("customFilePath", filePath);
            paramMap.put("customFilePath", filePath);
        }
        if (null != extensionMap && extensionMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)entry.getKey()) || !StringUtils.hasLength((String)entry.getValue())) continue;
                builder.addFormDataPart(entry.getKey(), entry.getValue());
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.uploadHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<UploadResponse>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<List<UploadResponse>> upload(List<String> fileNameList, List<byte[]> contentList, Map<String, String> extensionMap, Map<String, String> ... headers) {
        Assert.notEmpty(fileNameList, (String)"\u6587\u4ef6\u540d\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(contentList, (String)"\u6587\u4ef6\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((fileNameList.size() == contentList.size() ? 1 : 0) != 0, (String)"\u6587\u4ef6\u540d\u5217\u8868\u4e0e\u6587\u4ef6\u6570\u636e\u5217\u8868\u4e0d\u5339\u914d");
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (int i = 0; i < fileNameList.size(); ++i) {
            String fileName = fileNameList.get(i);
            byte[] byArray = contentList.get(i);
            builder.addFormDataPart("file", fileName, RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])byArray));
        }
        builder.addFormDataPart("appName", this.appName);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appName", this.appName);
        if (null != extensionMap && extensionMap.keySet().size() > 0) {
            for (Map.Entry entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)((String)entry.getKey())) || !StringUtils.hasLength((String)((String)entry.getValue()))) continue;
                builder.addFormDataPart((String)entry.getKey(), (String)entry.getValue());
                paramMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request request = this.assembleHttpRequest(this.uploadMultiHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(request).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<List<UploadResponse>>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    @Deprecated
    public YzwResult<File> download(String filePath, String fileName, Map<String, String> extensionMap, String dstLocalPath, Map<String, String> ... headers) {
        Assert.hasLength((String)dstLocalPath, (String)"\u672c\u5730\u5168\u8def\u5f84\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        return this.download(filePath, extensionMap, dstLocalPath, headers);
    }

    @Override
    @Deprecated
    public YzwResult<InputStream> download(String filePath, String fileName, Map<String, String> extensionMap, Map<String, String> ... headers) {
        return this.download(filePath, extensionMap, headers);
    }

    @Override
    public YzwResult<File> download(String filePath, Map<String, String> extensionMap, String dstLocalPath, Map<String, String> ... headers) {
        Assert.hasLength((String)dstLocalPath, (String)"\u672c\u5730\u5168\u8def\u5f84\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        YzwResult<InputStream> result = this.download(filePath, extensionMap, headers);
        if (result.isSuccess()) {
            try {
                File file = FssUtil.writeFromStream((InputStream)result.getData(), dstLocalPath, true);
                return YzwResult.success((Object)file);
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff01filePath: {}, dstLocalPath: {}", new Object[]{filePath, dstLocalPath, e});
                return YzwResult.badRequest((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff01");
            }
        }
        return result;
    }

    @Override
    public YzwResult<InputStream> download(String filePath, Map<String, String> extensionMap, Map<String, String> ... headers) {
        Assert.hasLength((String)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("filePath", filePath);
        builder.addFormDataPart("fileName", fileName);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("filePath", filePath);
        paramMap.put("fileName", fileName);
        if (null != extensionMap && extensionMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)entry.getKey()) || !StringUtils.hasLength((String)entry.getValue())) continue;
                builder.addFormDataPart(entry.getKey(), entry.getValue());
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.downloadHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                if (response.body().contentType() != null && "json".equalsIgnoreCase(response.body().contentType().subtype())) {
                    return JsonUtils.readAsObject(response.body().source().readUtf8(), new TypeReference<YzwResult>(){});
                }
                return YzwResult.success((Object)response.body().byteStream());
            }
            String resultStr = response.body().source().readUtf8();
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<BatchDownloadResponse> filePackage(BatchDownloadRequest batchDownloadRequest, Map<String, String> ... headers) {
        return this.packageFile(batchDownloadRequest, headers);
    }

    @Override
    @Deprecated
    public YzwResult<BatchDownloadResponse> batchDownload(BatchDownloadRequest batchDownloadRequest, Map<String, String> ... headers) {
        return this.packageFile(batchDownloadRequest, headers);
    }

    private YzwResult<BatchDownloadResponse> packageFile(BatchDownloadRequest batchDownloadRequest, Map<String, String> ... headers) {
        Assert.hasLength((String)batchDownloadRequest.getZipFileName(), (String)"\u538b\u7f29\u5305\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(batchDownloadRequest.getAttachments(), (String)"\u9700\u8981\u6253\u5305\u4e0b\u8f7d\u7684\u6587\u4ef6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        for (Map.Entry<String, String> entry : batchDownloadRequest.getAttachments().entrySet()) {
            Assert.hasLength((String)entry.getKey(), (String)"\u9700\u8981\u4e0b\u8f7d\u7684\u6e90\u6587\u4ef6\u5168\u8def\u5f84\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasLength((String)entry.getValue(), (String)"\u9700\u8981\u4e0b\u8f7d\u7684\u6e90\u6587\u4ef6\u5bf9\u5e94\u7684\u76ee\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqJson = JsonUtils.writeAsJson(batchDownloadRequest);
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)reqJson);
        Request httpRequest = this.assembleHttpRequest(this.batchDownloadHandler, body, new TreeMap<String, String>(), headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<BatchDownloadResponse>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    @Deprecated
    public YzwResult<File> batchDownload(BatchDownloadRequest batchDownloadRequest, String dstLocalPath, Map<String, String> ... headers) {
        Assert.hasLength((String)dstLocalPath, (String)"\u672c\u5730\u5168\u8def\u5f84\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        YzwResult<BatchDownloadResponse> result = this.batchDownload(batchDownloadRequest, headers);
        if (result.isSuccess()) {
            if (SystemErrorCode.SUCCESS.name().toLowerCase().equals(result.getMessage())) {
                BatchDownloadResponse data = (BatchDownloadResponse)result.getData();
                return this.download(data.getFilePath(), dstLocalPath, null, dstLocalPath, new Map[0]);
            }
            return YzwResult.error((int)SystemErrorCode.BAD_REQUEST.getCode(), (String)result.getMessage());
        }
        return result;
    }

    @Override
    public YzwResult<BatchDownloadResponse> packageState(String filePath, Map<String, String> ... headers) {
        Assert.hasLength((String)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("filePath", filePath).build();
        paramMap.put("filePath", filePath);
        Request httpRequest = this.assembleHttpRequest(this.packageStateHandler, (RequestBody)body, paramMap, headers);
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<BatchDownloadResponse> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<BatchDownloadResponse>>(){});
                if (result == null) {
                    return YzwResult.success((Object)new BatchDownloadResponse());
                }
                return result;
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<String> preview(String filePath, Map<String, String> ... headers) {
        PreviewRequest previewRequest = new PreviewRequest(filePath);
        YzwResult<PreviewResponse> preview = this.preview(previewRequest, headers);
        if (preview.isSuccess()) {
            return YzwResult.success((Object)((PreviewResponse)preview.getData()).getUrl());
        }
        return preview;
    }

    @Override
    public YzwResult<String[]> previewBatch(String[] filePaths, Map<String, String> ... headers) {
        PreviewBatchRequest previewBatchRequest = new PreviewBatchRequest(filePaths);
        YzwResult<PreviewBatchResponse> previewBatch = this.previewBatch(previewBatchRequest, headers);
        if (previewBatch.isSuccess()) {
            return YzwResult.success((Object)((PreviewBatchResponse)previewBatch.getData()).getUrls());
        }
        return previewBatch;
    }

    @Override
    public YzwResult<String[]> previewBatch(String ... filePaths) {
        PreviewBatchRequest previewBatchRequest = new PreviewBatchRequest(filePaths);
        YzwResult<PreviewBatchResponse> previewBatch = this.previewBatch(previewBatchRequest, new Map[0]);
        if (previewBatch.isSuccess()) {
            return YzwResult.success((Object)((PreviewBatchResponse)previewBatch.getData()).getUrls());
        }
        return previewBatch;
    }

    @Override
    public YzwResult<PreviewResponse> preview(PreviewRequest previewRequest, Map<String, String> ... headers) {
        Map<String, String> extensionMap;
        Assert.hasLength((String)previewRequest.getFilePath(), (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        MultipartBody body = null;
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("filePath", previewRequest.getFilePath());
        paramMap.put("filePath", previewRequest.getFilePath());
        if (null != previewRequest.getExpireInSecs()) {
            builder.addFormDataPart("expireInSecs", previewRequest.getExpireInSecs() + "");
            paramMap.put("expireInSecs", previewRequest.getExpireInSecs() + "");
        }
        if (null != previewRequest.getFormat()) {
            builder.addFormDataPart("format", previewRequest.getFormat());
            paramMap.put("format", previewRequest.getFormat());
        }
        if (null != (extensionMap = previewRequest.getExtensionMap()) && extensionMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)entry.getKey()) || !StringUtils.hasLength((String)entry.getValue())) continue;
                builder.addFormDataPart(entry.getKey(), entry.getValue());
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.previewHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<PreviewResponse>>(){});
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (Exception e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<PreviewMultiResponse> previewMulti(PreviewBatchRequest previewBatchRequest, Map<String, String> ... headers) {
        Map<String, String> extensionMap;
        Assert.notEmpty((Object[])previewBatchRequest.getFilePaths(), (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        String filePath = null;
        StringBuilder sb = new StringBuilder();
        for (String path : previewBatchRequest.getFilePaths()) {
            sb.append(path).append(",");
        }
        filePath = sb.deleteCharAt(sb.length() - 1).toString();
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("filePath", filePath);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("filePath", filePath);
        if (null != previewBatchRequest.getExpireInSecs()) {
            builder.addFormDataPart("expireInSecs", previewBatchRequest.getExpireInSecs() + "");
            paramMap.put("expireInSecs", previewBatchRequest.getExpireInSecs() + "");
        }
        if (null != previewBatchRequest.getFormat()) {
            builder.addFormDataPart("format", previewBatchRequest.getFormat());
            paramMap.put("format", previewBatchRequest.getFormat());
        }
        if (null != (extensionMap = previewBatchRequest.getExtensionMap()) && extensionMap.keySet().size() > 0) {
            for (Map.Entry entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)((String)entry.getKey())) || !StringUtils.hasLength((String)((String)entry.getValue()))) continue;
                builder.addFormDataPart((String)entry.getKey(), (String)entry.getValue());
                paramMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request request = this.assembleHttpRequest(this.previewMultiHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(request).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<PreviewMultiResponse>>(){});
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    @Deprecated
    public YzwResult<PreviewBatchResponse> previewBatch(PreviewBatchRequest previewBatchRequest, Map<String, String> ... headers) {
        Map<String, String> extensionMap;
        Assert.notEmpty((Object[])previewBatchRequest.getFilePaths(), (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        String filePath = null;
        StringBuilder sb = new StringBuilder();
        for (String path : previewBatchRequest.getFilePaths()) {
            sb.append(path).append(",");
        }
        filePath = sb.deleteCharAt(sb.length() - 1).toString();
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("filePath", filePath);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("filePath", filePath);
        if (null != previewBatchRequest.getExpireInSecs()) {
            builder.addFormDataPart("expireInSecs", previewBatchRequest.getExpireInSecs() + "");
            paramMap.put("expireInSecs", previewBatchRequest.getExpireInSecs() + "");
        }
        if (null != previewBatchRequest.getFormat()) {
            builder.addFormDataPart("format", previewBatchRequest.getFormat());
            paramMap.put("format", previewBatchRequest.getFormat());
        }
        if (null != (extensionMap = previewBatchRequest.getExtensionMap()) && extensionMap.keySet().size() > 0) {
            for (Map.Entry entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)((String)entry.getKey())) || !StringUtils.hasLength((String)((String)entry.getValue()))) continue;
                builder.addFormDataPart((String)entry.getKey(), (String)entry.getValue());
                paramMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request request = this.assembleHttpRequest(this.previewBatchHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(request).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<PreviewBatchResponse>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<List<WaterMarkResponse>> waterMark(WaterMarkRequest waterRequest, Map<String, String> ... headers) {
        Assert.notNull((Object)waterRequest, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(waterRequest.getFilePaths(), (String)"\u6587\u4ef6\u540d\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String waterStr = JsonUtils.writeAsJson(waterRequest);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)waterStr);
        Request httpRequest = this.assembleHttpRequest(this.waterMarkHandler, body, new TreeMap<String, String>(), headers);
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<List<WaterMarkResponse>> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<List<WaterMarkResponse>>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
                if (result == null) {
                    return YzwResult.success(new ArrayList());
                }
                return result;
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<FileHashResponse> hash(FileHashRequest request, Map<String, String> ... headers) {
        Assert.notNull((Object)request, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)request.getFilePath(), (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        MultipartBody body = null;
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("filePath", request.getFilePath());
        paramMap.put("filePath", request.getFilePath());
        if (null != request.getAlgorithm() && request.getAlgorithm() != "") {
            builder.addFormDataPart("algorithm", request.getAlgorithm());
            paramMap.put("algorithm", request.getAlgorithm());
        }
        body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.hashHandler, (RequestBody)body, paramMap, headers);
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<FileHashResponse> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<FileHashResponse>>(){});
                if (result == null) {
                    return YzwResult.success((Object)new FileHashResponse());
                }
                return result;
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<FileInfoResponse> info(String filePath, Map<String, String> ... headers) {
        Assert.hasLength((String)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("filePath", filePath).build();
        paramMap.put("filePath", filePath);
        Request httpRequest = this.assembleHttpRequest(this.infoHandler, (RequestBody)body, paramMap, headers);
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<FileInfoResponse> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<FileInfoResponse>>(){});
                if (result == null) {
                    return YzwResult.success((Object)new FileInfoResponse());
                }
                return result;
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<Boolean> delete(String filePath, Map<String, String> ... headers) {
        Assert.hasLength((String)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("filePath", filePath).build();
        paramMap.put("filePath", filePath);
        Request httpRequest = this.assembleHttpRequest(this.deleteFileHandler, (RequestBody)body, paramMap, headers);
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<Boolean> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<Boolean>>(){});
                if (result == null) {
                    return YzwResult.success((Object)false);
                }
                return result;
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<Boolean> exist(String filePath, Map<String, String> ... headers) {
        Assert.hasLength((String)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("filePath", filePath).build();
        paramMap.put("filePath", filePath);
        Request httpRequest = this.assembleHttpRequest(this.fileIsExistHandler, (RequestBody)body, paramMap, headers);
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<Boolean> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<Boolean>>(){});
                if (result == null) {
                    return YzwResult.success((Object)false);
                }
                return result;
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<CopyResponse> copy(CopyRequest request, Map<String, String> ... headers) {
        Assert.notNull((Object)request, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(request.getFilePaths(), (String)"\u6587\u4ef6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String requestStr = JsonUtils.writeAsJson(request);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)requestStr);
        Request httpRequest = this.assembleHttpRequest(this.copyHandler, body, new TreeMap<String, String>(), headers);
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<CopyResponse> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<CopyResponse>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
                if (result == null) {
                    return YzwResult.success((Object)new CopyResponse());
                }
                return result;
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<Map<String, String>> sign(AuthRequest request) {
        String operate = request.getOperate();
        if (!StringUtils.hasText((String)operate)) {
            return YzwResult.badRequest((String)"\u7b7e\u540d\u5f02\u5e38\uff0c\u7f3a\u5931\u5fc5\u8981\u7684\u7b7e\u540d\u53c2\u6570\u3010operate\u3011");
        }
        FtsOptEnum optType = FtsOptEnum.getOptType(operate);
        if (optType == null) {
            return YzwResult.badRequest((String)("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b\uff1a" + operate));
        }
        HashMap signParams = request.getSignParams();
        if (signParams == null) {
            signParams = Maps.newHashMap();
        }
        signParams.put("target", optType.getOpt());
        TreeMap<String, String> reqTreeMap = new TreeMap<String, String>(signParams);
        try {
            Map<String, String> signData = this.assembleSignData(reqTreeMap);
            return YzwResult.success(signData);
        }
        catch (Exception e) {
            log.error("\u7b7e\u540d\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)"\u7b7e\u540d\u5931\u8d25\uff01\u8bf7\u6838\u5bf9FSS\u914d\u7f6e\u662f\u5426\u6b63\u786e");
        }
    }

    private Request assembleHttpRequest(String url, RequestBody body, TreeMap<String, String> paramMap, Map<String, String>[] commonHeaders) {
        paramMap.put("target", url.substring(url.lastIndexOf("/") + 1));
        Map<String, String> signData = this.assembleSignData(paramMap);
        HashMap commonHeader = Maps.newHashMap();
        commonHeader.putAll(signData);
        commonHeader.put("x-fss-origin", "1");
        commonHeader.put("x-fss-uuid", UUID.randomUUID().toString());
        if (commonHeaders != null && commonHeaders.length > 0 && commonHeaders[0] != null) {
            commonHeader.putAll(commonHeaders[0]);
        }
        Request httpRequest = new Request.Builder().url(url).method("POST", body).headers(Headers.of((Map)commonHeader)).build();
        return httpRequest;
    }

    private Map<String, String> assembleSignData(TreeMap<String, String> paramMap) {
        Assert.notEmpty(paramMap, (String)"\u7b7e\u540d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String access = Base64Util.encodeStr(this.appName.getBytes(StandardCharsets.UTF_8), false, true);
        String token = SecureUtil.generateRandom(10);
        String expires = System.currentTimeMillis() + "";
        boolean isSecurityToken = StringUtils.hasText((String)this.securityToken);
        HashMap commonHeader = Maps.newHashMap();
        paramMap.put("access", access);
        paramMap.put("appSecret", isSecurityToken ? this.appSecret : SecureUtil.decrypt(this.appName, this.appSecret));
        paramMap.put("expires", expires);
        paramMap.put("token", token);
        if (isSecurityToken) {
            paramMap.put("x-fss-security-token", this.securityToken);
            commonHeader.put("x-fss-security-token", this.securityToken);
        }
        String sign = SecureUtil.encodeSign(paramMap);
        commonHeader.put("access", access);
        commonHeader.put("token", token);
        commonHeader.put("expires", expires);
        commonHeader.put("sign", sign);
        return commonHeader;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getAppName() {
        return this.appName;
    }

    @Override
    public YzwResult<FcsSyncResponse> convert(FcsCovertRequest request, Map<String, String> ... headers) {
        Assert.notNull((Object)request, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String waterStr = JsonUtils.writeAsJson(request);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)waterStr);
        Request httpRequest = this.assembleHttpRequest(String.format("%s/%s", this.serverAddress, "v1/fcs/sync/officeConvert"), body, new TreeMap<String, String>(), headers);
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<FcsSyncResponse> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<FcsSyncResponse>>(){});
                if (result != null) {
                    return result;
                }
                return YzwResult.badRequest(null);
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<FcsAsyncResponse> asyncConvert(FcsCovertRequest request, Map<String, String> ... headers) {
        Assert.notNull((Object)request, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String waterStr = JsonUtils.writeAsJson(request);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)waterStr);
        Request httpRequest = this.assembleHttpRequest(String.format("%s/%s", this.serverAddress, "v1/fcs/async/officeConvert"), body, new TreeMap<String, String>(), headers);
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<FcsAsyncResponse> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<FcsAsyncResponse>>(){});
                if (result != null) {
                    return result;
                }
                return YzwResult.badRequest(null);
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<FcsStatusResponse> convertStatus(String requestId, Map<String, String> ... headers) {
        Assert.hasText((String)requestId, (String)"\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a");
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("requestId", requestId);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("requestId", requestId);
        MultipartBody body = builder.build();
        Request httpRequest = this.assembleHttpRequest(String.format("%s/%s", this.serverAddress, "v1/fcs/async/status"), (RequestBody)body, paramMap, headers);
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<FcsStatusResponse> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<FcsStatusResponse>>(){});
                if (result != null) {
                    return result;
                }
                return YzwResult.badRequest(null);
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<FtsTokenResponse> ftsTokens(Long expireInSecs, Map<String, String> ... headers) {
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        HashMap map = Maps.newHashMap();
        map.put("expireInSecs", expireInSecs);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)JsonUtils.writeAsJson(map));
        try {
            String url = String.format("%s/%s", this.serverAddress, "v1/fts/securityTokens.fts");
            Request httpRequest = this.assembleHttpRequest(url, body, new TreeMap<String, String>(), headers);
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                YzwResult<FtsTokenResponse> result = JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<FtsTokenResponse>>(){});
                if (result != null) {
                    return result;
                }
                return YzwResult.badRequest(null);
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    public YzwResult<AuditResponse> textAudit(TextAuditRequest request, Map<String, String> ... headers) {
        Assert.notNull((Object)request, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)request.getInputContent(), (String)"\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String requestStr = JsonUtils.writeAsJson(request);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)requestStr);
        Request httpRequest = this.assembleHttpRequest(String.format("%s/%s", this.serverAddress, "v1/fms/textModeration"), body, new TreeMap<String, String>(), headers);
        return this.doRequest(httpRequest, new TypeReference<YzwResult<AuditResponse>>(){});
    }

    @Override
    public YzwResult<BatchAuditResponse> textBatchAudit(BatchTextAuditRequest request, Map<String, String> ... headers) {
        Assert.notNull((Object)request, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(request.getInputContents(), (String)"\u6279\u91cf\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String requestStr = JsonUtils.writeAsJson(request);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)requestStr);
        Request httpRequest = this.assembleHttpRequest(String.format("%s/%s", this.serverAddress, "v1/fms/batchTextModeration"), body, new TreeMap<String, String>(), headers);
        return this.doRequest(httpRequest, new TypeReference<YzwResult<BatchAuditResponse>>(){});
    }

    @Override
    public YzwResult<AuditResponse> imageAudit(ImageAuditRequest request, Map<String, String> ... headers) {
        Assert.notNull((Object)request, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (!StringUtils.hasText((String)request.getImgUrl()) && !StringUtils.hasText((String)request.getImgContent())) {
            return YzwResult.badRequest((String)"imgContent\u548cimgUrl\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String requestStr = JsonUtils.writeAsJson(request);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)requestStr);
        Request httpRequest = this.assembleHttpRequest(String.format("%s/%s", this.serverAddress, "v1/fms/imgModeration"), body, new TreeMap<String, String>(), headers);
        return this.doRequest(httpRequest, new TypeReference<YzwResult<AuditResponse>>(){});
    }

    @Override
    public YzwResult<BatchAuditResponse> imageBatchAudit(BatchImgAuditRequest request, Map<String, String> ... headers) {
        Assert.notNull((Object)request, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(request.getInputContents(), (String)"\u6279\u91cf\u56fe\u7247\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String requestStr = JsonUtils.writeAsJson(request);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)requestStr);
        Request httpRequest = this.assembleHttpRequest(String.format("%s/%s", this.serverAddress, "v1/fms/batchImgModeration"), body, new TreeMap<String, String>(), headers);
        return this.doRequest(httpRequest, new TypeReference<YzwResult<BatchAuditResponse>>(){});
    }

    private <T> T doRequest(Request httpRequest, TypeReference<T> valueTypeRef) {
        try {
            Response response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, valueTypeRef);
            }
            return (T)YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return (T)YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    @Deprecated
    public YzwResult<Map<String, FilePathMappingInfo>> filePathMappingInfoHandler(Set<String> filePaths, Map<String, String> ... headers) {
        Assert.notEmpty(filePaths, (String)"filePaths\u4e0d\u80fd\u4e3a\u7a7a");
        String reqJson = JsonUtils.writeAsJson(filePaths);
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)reqJson);
        Request httpRequest = this.assembleHttpRequest(this.filePathMappingInfoHandler, body, new TreeMap<String, String>(), headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<Map<String, FilePathMappingInfo>>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    @Override
    @Deprecated
    public YzwResult<UploadResponse> upload4failover(File file, Map<String, String> extensionMap, Map<String, String> ... headers) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)).addFormDataPart("appName", this.appName);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appName", this.appName);
        if (null != extensionMap && extensionMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)entry.getKey()) || !StringUtils.hasLength((String)entry.getValue())) continue;
                builder.addFormDataPart(entry.getKey(), entry.getValue());
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.upload4failoverHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(this.openTenant, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                return JsonUtils.readAsObject(resultStr, new TypeReference<YzwResult<UploadResponse>>(){

                    public Type getType() {
                        return super.getType();
                    }
                });
            }
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }
}

