/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.bean;

import cn.yzw.infra.component.base.exception.code.SystemErrorCode;
import cn.yzw.infra.component.base.model.YzwResult;
import cn.yzw.infra.component.fss.http.FssOkHttp;
import cn.yzw.infra.component.fss.model.HttpConfig;
import cn.yzw.infra.component.fss.model.request.v1.FileHashV1Request;
import cn.yzw.infra.component.fss.model.request.v1.FilePackageV1Request;
import cn.yzw.infra.component.fss.model.request.v1.WaterMarkV1Request;
import cn.yzw.infra.component.fss.model.response.v1.FileHashV1Response;
import cn.yzw.infra.component.fss.model.response.v1.FileSizeInfo;
import cn.yzw.infra.component.fss.model.response.v1.PackageV1Response;
import cn.yzw.infra.component.fss.model.response.v1.WaterMarkV1Response;
import cn.yzw.infra.component.fss.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Deprecated
public class FssV1Client {
    private static final Logger log = LoggerFactory.getLogger(FssV1Client.class);
    private final String HTTP_METHOD_POST = "POST";
    private final String serverAddress;
    private final HttpConfig httpConfig;
    private final String downloadHandler;
    private final String waterMarkHandler;
    private final String hashHandler;
    private final String packageStateHandler;
    private final String batchDownloadHandler;
    private final String batchEncryptFileHandler;
    private final String batchDecryptFileHandler;
    private final String fileSizeHandler;

    public FssV1Client(String serverAddress, HttpConfig httpConfig) {
        this.serverAddress = serverAddress;
        this.httpConfig = httpConfig;
        this.downloadHandler = String.format("%s/%s", serverAddress, "DownloadHandler.ashx");
        this.waterMarkHandler = String.format("%s/%s", serverAddress, "BatchWaterMark.ashx");
        this.hashHandler = String.format("%s/%s", serverAddress, "BatchGetFileHashHandler.ashx");
        this.packageStateHandler = String.format("%s/%s", serverAddress, "PackageStateHandler.ashx");
        this.batchDownloadHandler = String.format("%s/%s", serverAddress, "BatchDownloadHandler.ashx");
        this.batchEncryptFileHandler = String.format("%s/%s", serverAddress, "BatchEncryptFile.ashx");
        this.batchDecryptFileHandler = String.format("%s/%s", serverAddress, "BatchDecryptFile.ashx");
        this.fileSizeHandler = String.format("%s/%s", serverAddress, "fileSize.ashx");
    }

    public YzwResult<Long> fileSize(String filePath, Map<String, String> extensionMap, Map<String, String> ... headers) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("filePath", filePath);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("filePath", filePath);
        if (null != extensionMap && extensionMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)entry.getKey()) || !StringUtils.hasLength((String)entry.getValue())) continue;
                builder.addFormDataPart(entry.getKey(), entry.getValue());
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.fileSizeHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(false, this.httpConfig).newCall(httpRequest).execute();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                String resultStr = response.body().source().readUtf8();
                FileSizeInfo fileSizeInfo = JsonUtils.readAsObject(resultStr, FileSizeInfo.class);
                return YzwResult.success((Object)Optional.ofNullable(fileSizeInfo).map(FileSizeInfo::getLength).orElse(0L));
            }
            String resultStr = response.body().source().readUtf8();
            log.error("{} err: {}", (Object)this.fileSizeHandler, (Object)resultStr);
            return YzwResult.success((Object)0L);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    public YzwResult<InputStream> download(String filePath, String fileName, Map<String, String> extensionMap, Map<String, String> ... headers) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("filePath", filePath);
        builder.addFormDataPart("fileName", fileName);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("filePath", filePath);
        paramMap.put("fileName", fileName);
        if (null != extensionMap && extensionMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)entry.getKey()) || !StringUtils.hasLength((String)entry.getValue())) continue;
                builder.addFormDataPart(entry.getKey(), entry.getValue());
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.downloadHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(false, this.httpConfig).newCall(httpRequest).execute();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                if (response.body().contentType() != null && "json".equalsIgnoreCase(response.body().contentType().subtype())) {
                    return JsonUtils.readAsObject(response.body().source().readUtf8(), new TypeReference<YzwResult>(){});
                }
                return YzwResult.success((Object)response.body().byteStream());
            }
            String resultStr = response.body().source().readUtf8();
            log.error("{} err: {}", (Object)this.downloadHandler, (Object)resultStr);
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    public YzwResult<List<WaterMarkV1Response>> waterMark(List<WaterMarkV1Request> waterRequest, Map<String, String> ... headers) {
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String waterStr = JsonUtils.writeAsJson(waterRequest);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)waterStr);
        Request httpRequest = this.assembleHttpRequest(this.waterMarkHandler, body, new TreeMap<String, String>(), headers);
        try {
            Response response = FssOkHttp.build().init(false, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                List<WaterMarkV1Response> result = JsonUtils.readAsList(resultStr, WaterMarkV1Response.class);
                if (result == null) {
                    return YzwResult.success(new ArrayList());
                }
                return YzwResult.success(result);
            }
            log.error("{} err: {}", (Object)this.waterMarkHandler, (Object)resultStr);
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            log.error("{} acc err: ", (Object)this.waterMarkHandler, (Object)e);
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    public YzwResult<List<FileHashV1Response>> hash(List<FileHashV1Request> requests, Map<String, String> ... headers) {
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String hashStr = JsonUtils.writeAsJson(requests);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)hashStr);
        Request httpRequest = this.assembleHttpRequest(this.hashHandler, body, new TreeMap<String, String>(), headers);
        try {
            Response response = FssOkHttp.build().init(false, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                List<FileHashV1Response> result = JsonUtils.readAsList(resultStr, FileHashV1Response.class);
                if (result == null) {
                    return YzwResult.success(new ArrayList());
                }
                return YzwResult.success(result);
            }
            log.error("{} err: {}", (Object)this.hashHandler, (Object)resultStr);
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            log.error("{} acc err: ", (Object)this.hashHandler, (Object)e);
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    public YzwResult<PackageV1Response> packageState(String filePath, Map<String, String> extensionMap, Map<String, String> ... headers) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("filePath", filePath);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("filePath", filePath);
        if (null != extensionMap && extensionMap.keySet().size() > 0) {
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                if (!StringUtils.hasLength((String)entry.getKey()) || !StringUtils.hasLength((String)entry.getValue())) continue;
                builder.addFormDataPart(entry.getKey(), entry.getValue());
                paramMap.put(entry.getKey(), entry.getValue());
            }
        }
        MultipartBody body = builder.build();
        Request httpRequest = this.assembleHttpRequest(this.packageStateHandler, (RequestBody)body, paramMap, headers);
        Response response = null;
        try {
            response = FssOkHttp.build().init(false, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                PackageV1Response result = JsonUtils.readAsObject(resultStr, PackageV1Response.class);
                return YzwResult.success((Object)result);
            }
            log.error("{} err: {}", (Object)this.packageStateHandler, (Object)resultStr);
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            log.error("{} acc err: ", (Object)this.packageStateHandler, (Object)e);
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    public YzwResult<PackageV1Response> filePackage(FilePackageV1Request request, Map<String, String> ... headers) {
        MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
        String pkgStr = JsonUtils.writeAsJson(request);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)pkgStr);
        Request httpRequest = this.assembleHttpRequest(this.batchDownloadHandler, body, new TreeMap<String, String>(), headers);
        try {
            Response response = FssOkHttp.build().init(false, this.httpConfig).newCall(httpRequest).execute();
            String resultStr = response.body().source().readUtf8();
            if (response.code() == SystemErrorCode.SUCCESS.getCode()) {
                PackageV1Response result = JsonUtils.readAsObject(resultStr, PackageV1Response.class);
                return YzwResult.success((Object)result);
            }
            log.error("{} err: {}", (Object)this.batchDownloadHandler, (Object)resultStr);
            return YzwResult.error((int)response.code(), (String)resultStr);
        }
        catch (IOException e) {
            log.error("{} acc err: ", (Object)this.batchDownloadHandler, (Object)e);
            return YzwResult.error((int)SystemErrorCode.INTERNAL_SERVER_ERROR.getCode(), (String)e.getMessage());
        }
    }

    private Request assembleHttpRequest(String url, RequestBody body, TreeMap<String, String> paramMap, Map<String, String>[] commonHeaders) {
        HashMap commonHeader = Maps.newHashMap();
        if (commonHeaders != null && commonHeaders.length > 0 && commonHeaders[0] != null) {
            commonHeader.putAll(commonHeaders[0]);
        }
        Request httpRequest = new Request.Builder().url(url).method("POST", body).headers(Headers.of((Map)commonHeader)).build();
        return httpRequest;
    }
}

