/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.config;

import cn.yzw.infra.component.fss.bean.FssClient;
import cn.yzw.infra.component.fss.bean.FssRpcClient;
import cn.yzw.infra.component.fss.config.FssProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
@EnableConfigurationProperties(value={FssProperties.class})
public class FssConfiguration {
    @Value(value="${yzw.tenant.open:false}")
    private boolean tenantOpen;
    final FssProperties fssProperties;

    @Bean
    @ConditionalOnProperty(prefix="yzw.fss", name={"address"})
    public FssClient fssClient() {
        String address = this.fssProperties.getAddress();
        Assert.hasLength((String)address, (String)"address\u4e0d\u80fd\u4e3a\u7a7a");
        String appName = this.fssProperties.getApp().getName();
        Assert.hasLength((String)appName, (String)"appName\u4e0d\u80fd\u4e3a\u7a7a");
        String secret = this.fssProperties.getApp().getSecret();
        Assert.hasLength((String)secret, (String)"appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        return new FssClient(address, appName, secret, this.tenantOpen, this.fssProperties.getHttp());
    }

    @Bean
    @ConditionalOnProperty(prefix="yzw.fss.rpc", name={"enable"}, havingValue="true")
    public FssRpcClient fssRpcClient() {
        String appName = this.fssProperties.getApp().getName();
        Assert.hasLength((String)appName, (String)"appName\u4e0d\u80fd\u4e3a\u7a7a");
        String secret = this.fssProperties.getApp().getSecret();
        Assert.hasLength((String)secret, (String)"appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        return new FssRpcClient(appName, secret, this.tenantOpen);
    }

    public FssConfiguration(FssProperties fssProperties) {
        this.fssProperties = fssProperties;
    }
}

