/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.intercept;

import cn.yzw.infra.component.tenant.context.TenantHolder;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantRequestFilter
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(TenantRequestFilter.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (!TenantHolder.INSTANCE.isOpenTenant()) {
            return chain.proceed(request);
        }
        if (!TenantHolder.isExist()) {
            throw new IllegalArgumentException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.debug("fss\u4f7f\u7528\u79df\u6237\u4e0a\u4e0b\u6587, tenantId = {}", (Object)TenantHolder.INSTANCE.getTenantId());
        return chain.proceed(request.newBuilder().header("tenant-id", TenantHolder.INSTANCE.getTenantId()).build());
    }
}

