/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.util;

import cn.yzw.infra.component.fss.mutable.MutableInt;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Base64Util {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final byte PADDING = -2;
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public static String encodeStr(byte[] arr, boolean isMultiLine, boolean isUrlSafe) {
        return new String(Base64Util.encode(arr, isMultiLine, isUrlSafe), DEFAULT_CHARSET);
    }

    public static byte[] encode(byte[] arr, boolean isMultiLine, boolean isUrlSafe) {
        if (null == arr) {
            return null;
        }
        int len = arr.length;
        if (len == 0) {
            return new byte[0];
        }
        int evenlen = len / 3 * 3;
        int cnt = (len - 1) / 3 + 1 << 2;
        int destlen = cnt + (isMultiLine ? (cnt - 1) / 76 << 1 : 0);
        byte[] dest = new byte[destlen];
        byte[] encodeTable = isUrlSafe ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < evenlen) {
            int i = (arr[s++] & 0xFF) << 16 | (arr[s++] & 0xFF) << 8 | arr[s++] & 0xFF;
            dest[d++] = encodeTable[i >>> 18 & 0x3F];
            dest[d++] = encodeTable[i >>> 12 & 0x3F];
            dest[d++] = encodeTable[i >>> 6 & 0x3F];
            dest[d++] = encodeTable[i & 0x3F];
            if (!isMultiLine || ++cc != 19 || d >= destlen - 2) continue;
            dest[d++] = 13;
            dest[d++] = 10;
            cc = 0;
        }
        int left = len - evenlen;
        if (left > 0) {
            int i = (arr[evenlen] & 0xFF) << 10 | (left == 2 ? (arr[len - 1] & 0xFF) << 2 : 0);
            dest[destlen - 4] = encodeTable[i >> 12];
            dest[destlen - 3] = encodeTable[i >>> 6 & 0x3F];
            if (isUrlSafe) {
                int urlSafeLen = destlen - 2;
                if (2 == left) {
                    dest[destlen - 2] = encodeTable[i & 0x3F];
                    ++urlSafeLen;
                }
                byte[] urlSafeDest = new byte[urlSafeLen];
                System.arraycopy(dest, 0, urlSafeDest, 0, urlSafeLen);
                return urlSafeDest;
            }
            dest[destlen - 2] = left == 2 ? encodeTable[i & 0x3F] : 61;
            dest[destlen - 1] = 61;
        }
        return dest;
    }

    public static byte[] decode(CharSequence source) {
        byte[] in = source.toString().getBytes(DEFAULT_CHARSET);
        if (in == null || in.length == 0) {
            return in;
        }
        int length = in.length;
        int pos = 0;
        MutableInt offset = new MutableInt(pos);
        int maxPos = pos + length - 1;
        int octetId = 0;
        byte[] octet = new byte[length * 3 / 4];
        while (offset.intValue() <= maxPos) {
            byte sestet0 = Base64Util.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet1 = Base64Util.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet2 = Base64Util.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet3 = Base64Util.getNextValidDecodeByte(in, offset, maxPos);
            if (-2 != sestet1) {
                octet[octetId++] = (byte)(sestet0 << 2 | sestet1 >>> 4);
            }
            if (-2 != sestet2) {
                octet[octetId++] = (byte)((sestet1 & 0xF) << 4 | sestet2 >>> 2);
            }
            if (-2 == sestet3) continue;
            octet[octetId++] = (byte)((sestet2 & 3) << 6 | sestet3);
        }
        if (octetId == octet.length) {
            return octet;
        }
        byte[] dest = new byte[octetId];
        System.arraycopy(octet, 0, dest, 0, length);
        return dest;
    }

    private static byte getNextValidDecodeByte(byte[] in, MutableInt pos, int maxPos) {
        while (pos.intValue() <= maxPos) {
            byte decodeByte;
            byte base64Byte = in[pos.intValue()];
            pos.increment();
            if (base64Byte <= -1 || (decodeByte = DECODE_TABLE[base64Byte]) <= -1) continue;
            return decodeByte;
        }
        return -2;
    }
}

