/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.util;

import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class HexUtil {
    public static final Pattern HEX = Pattern.compile("^[a-fA-F0-9]+$");

    public static byte[] decodeHex(CharSequence encoded) {
        if (encoded == null || encoded.length() == 0) {
            return null;
        }
        int len = (encoded = StringUtils.trimAllWhitespace((String)((String)encoded))).length();
        if ((len & 1) != 0) {
            encoded = "0" + encoded;
            len = encoded.length();
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtil.toDigit(encoded.charAt(j), j) << 4;
            f |= HexUtil.toDigit(encoded.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit < 0) {
            String msg = String.format("Illegal hexadecimal character %s at index %s", Character.valueOf(ch), index);
            throw new IllegalArgumentException(msg);
        }
        return digit;
    }

    public static boolean isHex(CharSequence value) {
        if (value == null) {
            return false;
        }
        return HEX.matcher(value).matches();
    }
}

