/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static ObjectMapper objectMapper = null;

    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = JsonUtils.buildObjectMapper();
        }
        return objectMapper;
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        JsonUtils.objectMapper = objectMapper;
    }

    public static <T> T readAsObject(String json, Class<T> objClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)JsonUtils.getObjectMapper().readValue(json, objClass);
        }
        catch (IOException e) {
            throw new RuntimeException("json to object valueType err:" + e.getMessage());
        }
    }

    public static <T> T readAsObject(String json, TypeReference<T> valueTypeRef) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)JsonUtils.getObjectMapper().readValue(json, valueTypeRef);
        }
        catch (IOException e) {
            throw new RuntimeException("json to object valueType err:" + e.getMessage());
        }
    }

    public static Map convertToMap(Object fromValue) {
        if (fromValue == null) {
            return new HashMap();
        }
        return (Map)JsonUtils.getObjectMapper().convertValue(fromValue, Map.class);
    }

    public static <T> T convertToBean(Object fromValue, Class<T> objClass) {
        if (fromValue == null) {
            return null;
        }
        return (T)JsonUtils.getObjectMapper().convertValue(fromValue, objClass);
    }

    public static <T> List<T> readAsList(String json, Class<T> targetClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return Collections.emptyList();
        }
        try {
            JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametricType(List.class, new Class[]{targetClass});
            return (List)JsonUtils.getObjectMapper().readValue(json, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException("json to list  valueType err:" + e.getMessage());
        }
    }

    public static String writeAsJson(Object val) {
        if (val == null) {
            return null;
        }
        try {
            return JsonUtils.getObjectMapper().writeValueAsString(val);
        }
        catch (Exception e) {
            throw new RuntimeException("object to json err:" + e.getMessage());
        }
    }

    public static ObjectMapper buildObjectMapper() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, false);
        objectMapper.disable(new MapperFeature[]{MapperFeature.IGNORE_DUPLICATE_MODULE_REGISTRATIONS});
        objectMapper.registerModule((Module)javaTimeModule);
        objectMapper.enable(new MapperFeature[]{MapperFeature.IGNORE_DUPLICATE_MODULE_REGISTRATIONS});
        return objectMapper;
    }
}

