/*
 * Decompiled with CFR 0.152.
 */
package cn.yzw.infra.component.fss.util;

import cn.yzw.infra.component.fss.crypto.FssAesCrypt;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ThreadLocalRandom;

public class SecureUtil {
    private static final String BASE = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static String generateRandom(int length) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(BASE.length());
            sb.append(BASE.charAt(number));
        }
        return sb.toString();
    }

    public static String decrypt(String appName, String encryptSecret) {
        int i;
        byte[] keys = new byte[16];
        byte[] ivs = new byte[16];
        byte[] apps = appName.getBytes(StandardCharsets.UTF_8);
        int minLength = Math.min(keys.length, apps.length);
        for (i = 0; i < minLength; ++i) {
            keys[i] = apps[i];
            ivs[i] = apps[minLength - 1 - i];
        }
        if (minLength != keys.length) {
            for (i = minLength; i < keys.length; ++i) {
                keys[i] = (byte)i;
                ivs[i] = (byte)i;
            }
        }
        return SecureUtil.decrypt(keys, ivs, encryptSecret);
    }

    private static String decrypt(byte[] keys, byte[] ivs, String str) {
        FssAesCrypt aesCrypt = new FssAesCrypt("AES/CBC/PKCS5Padding", keys, ivs);
        String decrypt = aesCrypt.decryptStr(str, StandardCharsets.UTF_16LE);
        return decrypt;
    }

    public static String encodeSign(SortedMap<String, String> map) {
        String appSecret = (String)map.get("appSecret");
        if (appSecret == null || appSecret.length() == 0) {
            throw new RuntimeException("appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Set<Map.Entry<String, String>> entries = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entries.iterator();
        ArrayList<String> values = new ArrayList<String>();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String k = String.valueOf(entry.getKey());
            String v = String.valueOf(entry.getValue());
            if (v == null || v.length() <= 0 || "sign".equals(k) || "appSecret".equals(k)) continue;
            values.add(k + "=" + v);
        }
        values.add("appSecret=" + appSecret);
        StringBuilder sign = new StringBuilder();
        values.forEach(value -> sign.append((String)value).append("&"));
        sign.deleteCharAt(sign.length() - 1);
        return SecureUtil.encodeByMD5(sign.toString()).toUpperCase();
    }

    private static String encodeByMD5(String algorithmStr) {
        if (algorithmStr == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("md5");
            messageDigest.update(algorithmStr.getBytes(StandardCharsets.UTF_8));
            return SecureUtil.getFormattedText(messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFormattedText(byte[] digest) {
        StringBuffer buffer = new StringBuffer();
        for (byte b : digest) {
            int number = b & 0xFF;
            String str = Integer.toHexString(number);
            if (str.length() == 1) {
                buffer.append("0");
            }
            buffer.append(str);
        }
        return buffer.toString();
    }
}

