/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.clickhouse.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLArrayDataType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLMapDataType;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLStructDataType;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.clickhouse.ast.CKAlterTableUpdateStatement;
import com.alibaba.druid.sql.dialect.clickhouse.ast.CKCreateTableStatement;
import com.alibaba.druid.sql.dialect.clickhouse.ast.CKSelectQueryBlock;
import com.alibaba.druid.sql.dialect.clickhouse.ast.ClickhouseColumnCodec;
import com.alibaba.druid.sql.dialect.clickhouse.ast.ClickhouseColumnTTL;
import com.alibaba.druid.sql.dialect.clickhouse.visitor.CKASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.util.StringUtils;
import java.util.List;

public class CKOutputVisitor
extends SQLASTOutputVisitor
implements CKASTVisitor {
    public CKOutputVisitor(StringBuilder appender) {
        super(appender, DbType.clickhouse);
    }

    public CKOutputVisitor(StringBuilder appender, DbType dbType) {
        super(appender, dbType);
    }

    public CKOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, parameterized);
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        if (x.isPrefixAlias()) {
            this.print0(x.getAlias());
            this.print(' ');
            this.print0(this.ucase ? "AS " : "as ");
            this.printWithExpr(x);
        } else {
            this.printWithExpr(x);
            this.print(' ');
            this.print0(this.ucase ? "AS " : "as ");
            this.print0(x.getAlias());
        }
        return false;
    }

    private void printWithExpr(SQLWithSubqueryClause.Entry x) {
        if (x.getExpr() != null) {
            x.getExpr().accept(this);
        } else if (x.getSubQuery() != null) {
            this.print('(');
            this.println();
            SQLSelect query = x.getSubQuery();
            if (query != null) {
                query.accept(this);
            } else {
                x.getReturningStatement().accept(this);
            }
            this.println();
            this.print(')');
        }
    }

    @Override
    public boolean visit(SQLStructDataType x) {
        this.print0(this.ucase ? "NESTED (" : "nested (");
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getFields(), ",");
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLStructDataType.Field x) {
        SQLDataType dataType;
        SQLName name = x.getName();
        if (name != null) {
            name.accept(this);
        }
        if ((dataType = x.getDataType()) != null) {
            this.print(' ');
            dataType.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByList x) {
        if (x.getColumns().size() == 1) {
            x.getColumns().get(0).accept(this);
        } else {
            this.print('(');
            this.printAndAccept(x.getColumns(), ", ");
            this.print0(")");
        }
        this.printPartitionsCountAndSubPartitions(x);
        this.printSQLPartitions(x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(CKCreateTableStatement x) {
        List<SQLAssignItem> settings;
        SQLExpr ttl;
        SQLExpr sampleBy;
        SQLPrimaryKey primaryKey;
        super.visit(x);
        SQLOrderBy orderBy = x.getOrderBy();
        if (orderBy != null) {
            this.println();
            orderBy.accept(this);
        }
        if ((primaryKey = x.getPrimaryKey()) != null) {
            this.println();
            primaryKey.accept(this);
        }
        if ((sampleBy = x.getSampleBy()) != null) {
            this.println();
            this.print0(this.ucase ? "SAMPLE BY " : "sample by ");
            sampleBy.accept(this);
        }
        if ((ttl = x.getTtl()) != null) {
            this.println();
            this.print0(this.ucase ? "TTL " : "ttl ");
            ttl.accept(this);
        }
        if (!(settings = x.getSettings()).isEmpty()) {
            this.println();
            this.print0(this.ucase ? "SETTINGS " : "settings ");
            this.printAndAccept(settings, ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        this.print0(this.ucase ? "ADD COLUMN " : "add column ");
        this.printAndAccept(x.getColumns(), ", ");
        return false;
    }

    @Override
    public boolean visit(SQLArrayDataType x) {
        List<SQLExpr> arguments = x.getArguments();
        if (Boolean.TRUE.equals(x.getAttribute("ads.arrayDataType"))) {
            x.getComponentType().accept(this);
            this.print('[');
            this.printAndAccept(arguments, ", ");
            this.print(']');
        } else {
            SQLDataType componentType = x.getComponentType();
            if (componentType != null) {
                this.print0(this.ucase ? "Array<" : "array<");
                componentType.accept(this);
                this.print('>');
            } else {
                this.print0(this.ucase ? "Array" : "array");
            }
            if (arguments.size() > 0) {
                this.print('(');
                this.printAndAccept(arguments, ", ");
                this.print(')');
            }
        }
        return false;
    }

    @Override
    public boolean visit(CKAlterTableUpdateStatement x) {
        this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
        this.printExpr(x.getTableName());
        if (x.getClusterName() != null) {
            this.print0(this.ucase ? " ON CLUSTER " : " on cluster ");
            if (this.parameterized) {
                this.print('?');
            } else {
                this.printExpr(x.getClusterName());
            }
        }
        this.print0(this.ucase ? " UPDATE " : " update ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            SQLUpdateSetItem item = x.getItems().get(i);
            this.visit(item);
        }
        if (x.getPartitionId() != null) {
            this.print0(this.ucase ? " IN PARTITION " : " in partition ");
            if (this.parameterized) {
                this.print('?');
            } else {
                this.printExpr(x.getPartitionId());
            }
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ClickhouseColumnCodec x) {
        this.print0(this.ucase ? "CODEC(" : "codec(");
        this.printExpr(x.getExpr());
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(ClickhouseColumnTTL x) {
        this.print0(this.ucase ? " TTL " : " ttl ");
        this.printExpr(x.getExpr());
        return false;
    }

    @Override
    protected void printAfterFetch(SQLSelectQueryBlock queryBlock) {
        if (queryBlock instanceof CKSelectQueryBlock) {
            CKSelectQueryBlock ckSelectQueryBlock = (CKSelectQueryBlock)queryBlock;
            if (!ckSelectQueryBlock.getSettings().isEmpty()) {
                this.println();
                this.print0(this.ucase ? "SETTINGS " : "settings ");
                this.printAndAccept(ckSelectQueryBlock.getSettings(), ", ");
            }
            if (ckSelectQueryBlock.getFormat() != null) {
                this.println();
                this.print0(this.ucase ? "FORMAT " : "format ");
                ckSelectQueryBlock.getFormat().accept(this);
            }
        }
    }

    @Override
    protected void printWhere(SQLSelectQueryBlock queryBlock) {
        SQLExpr where;
        SQLExpr preWhere;
        if (queryBlock instanceof CKSelectQueryBlock && (preWhere = ((CKSelectQueryBlock)queryBlock).getPreWhere()) != null) {
            this.println();
            this.print0(this.ucase ? "PREWHERE " : "prewhere ");
            this.printExpr(preWhere);
        }
        if ((where = queryBlock.getWhere()) == null) {
            return;
        }
        this.println();
        this.print0(this.ucase ? "WHERE " : "where ");
        List<String> beforeComments = where.getBeforeCommentsDirect();
        if (beforeComments != null && !beforeComments.isEmpty() && this.isPrettyFormat()) {
            this.printlnComments(beforeComments);
        }
        this.printExpr(where, this.parameterized);
    }

    @Override
    protected void printFrom(SQLSelectQueryBlock x) {
        super.printFrom(x);
        if (x instanceof CKSelectQueryBlock && ((CKSelectQueryBlock)x).isFinal()) {
            this.print0(this.ucase ? " FINAL" : " final");
        }
    }

    @Override
    protected void printGroupBy(SQLSelectQueryBlock x) {
        super.printGroupBy(x);
        if (x instanceof CKSelectQueryBlock && ((CKSelectQueryBlock)x).isWithTotals()) {
            this.print0(this.ucase ? " WITH TOTALS" : " with totals");
        }
    }

    @Override
    protected void printOrderBy(SQLSelectQueryBlock x) {
        super.printOrderBy(x);
        if (x instanceof CKSelectQueryBlock && ((CKSelectQueryBlock)x).isWithFill()) {
            this.print0(this.ucase ? " WITH FILL" : " with fill");
        }
    }

    @Override
    protected void printLimit(SQLSelectQueryBlock x) {
        super.printLimit(x);
        if (x instanceof CKSelectQueryBlock && ((CKSelectQueryBlock)x).isWithTies()) {
            this.print0(this.ucase ? " WITH TIES" : " with ties");
        }
    }

    @Override
    protected void printCreateTableAfterName(SQLCreateTableStatement x) {
        CKCreateTableStatement ckStmt;
        if (x instanceof CKCreateTableStatement && !StringUtils.isEmpty((ckStmt = (CKCreateTableStatement)x).getOnClusterName())) {
            this.print0(this.ucase ? " ON CLUSTER " : " on cluster ");
            this.print(ckStmt.getOnClusterName());
        }
    }

    @Override
    protected void printEngine(SQLCreateTableStatement x) {
        SQLExpr engine;
        if (x instanceof CKCreateTableStatement && (engine = ((CKCreateTableStatement)x).getEngine()) != null) {
            this.print0(this.ucase ? " ENGINE = " : " engine = ");
            engine.accept(this);
        }
    }

    @Override
    public boolean visit(SQLMapDataType x) {
        this.print0(this.ucase ? "MAP(" : "map(");
        SQLDataType keyType = x.getKeyType();
        SQLDataType valueType = x.getValueType();
        keyType.accept(this);
        this.print0(", ");
        valueType.accept(this);
        this.print(')');
        return false;
    }
}

