/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.gaussdb.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.gaussdb.ast.GaussDbDistributeBy;
import com.alibaba.druid.sql.dialect.gaussdb.ast.stmt.GaussDbCreateTableStatement;
import com.alibaba.druid.sql.dialect.gaussdb.parser.GaussDbExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class GaussDbCreateTableParser
extends PGCreateTableParser {
    public GaussDbCreateTableParser(String sql) {
        super(new GaussDbExprParser(sql, new SQLParserFeature[0]));
    }

    @Override
    protected SQLCreateTableStatement newCreateStatement() {
        return new GaussDbCreateTableStatement();
    }

    @Override
    public GaussDbExprParser getExprParser() {
        return (GaussDbExprParser)this.exprParser;
    }

    public GaussDbCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.gaussdb;
    }

    @Override
    protected void createTableBodyItem(SQLCreateTableStatement createTable) {
        if (this.lexer.token() == Token.PARTIAL) {
            this.lexer.nextToken();
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.CLUSTER)) {
                this.accept(Token.KEY);
                this.accept(Token.LPAREN);
                while (true) {
                    SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
                    createTable.addClusteredByItem(item);
                    if (this.lexer.token() == Token.COMMA) {
                        this.lexer.nextToken();
                        continue;
                    }
                    if (this.lexer.token() == Token.RPAREN) break;
                }
                this.accept(Token.RPAREN);
            }
        } else {
            super.createTableBodyItem(createTable);
        }
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement stmt) {
        GaussDbDistributeBy distributeByClause;
        GaussDbCreateTableStatement gdStmt = (GaussDbCreateTableStatement)stmt;
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(gdStmt.getTableOptions(), gdStmt, false);
            this.accept(Token.RPAREN);
        }
        if ((distributeByClause = this.parseDistributeBy()) != null) {
            gdStmt.setDistributeBy(distributeByClause);
        }
        if (this.lexer.nextIf(Token.COMMENT)) {
            this.lexer.nextIf(Token.EQ);
            SQLExpr comment = this.exprParser.expr();
            gdStmt.setComment(comment);
        }
    }

    @Override
    protected void createTableBefore(SQLCreateTableStatement createTable) {
        this.parseTableType(createTable);
        this.parseTableType(createTable);
    }

    private void parseTableType(SQLCreateTableStatement createTable) {
        if (this.lexer.nextIfIdentifier("UNLOGGED")) {
            createTable.config(SQLCreateTableStatement.Feature.Unlogged);
        } else if (this.lexer.nextIfIdentifier(FnvHash.Constants.GLOBAL)) {
            createTable.config(SQLCreateTableStatement.Feature.Global);
        } else if (this.lexer.nextIfIdentifier(FnvHash.Constants.TEMPORARY) || this.lexer.nextIfIdentifier("TEMP")) {
            createTable.config(SQLCreateTableStatement.Feature.Temporary);
        } else if (this.lexer.nextIf(Token.LOCAL)) {
            createTable.config(SQLCreateTableStatement.Feature.Local);
        }
    }

    public GaussDbDistributeBy parseDistributeBy() {
        if (this.lexer.token() == Token.DISTRIBUTE) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            GaussDbDistributeBy distributeBy = new GaussDbDistributeBy();
            if (this.lexer.identifierEquals(FnvHash.Constants.HASH)) {
                distributeBy.setType(this.exprParser.name());
                if (this.lexer.nextIf(Token.LPAREN)) {
                    while (true) {
                        distributeBy.addColumn(this.exprParser.name());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    return distributeBy;
                }
            } else {
                if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
                    distributeBy.setType(this.exprParser.name());
                    return this.distributionByContent(distributeBy);
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.LIST)) {
                    distributeBy.setType(this.exprParser.name());
                    return this.distributionByContent(distributeBy);
                }
            }
        }
        return null;
    }

    public GaussDbDistributeBy distributionByContent(GaussDbDistributeBy distributeBy) {
        this.accept(Token.LPAREN);
        while (true) {
            distributeBy.addColumn(this.exprParser.name());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        this.accept(Token.LPAREN);
        while (true) {
            distributeBy.addDistribution(this.getExprParser().parseDistribution());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return distributeBy;
    }
}

