/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HiveCreateTableStatement
extends SQLCreateTableStatement {
    protected List<SQLExpr> skewedBy = new ArrayList<SQLExpr>();
    protected List<SQLExpr> skewedByOn = new ArrayList<SQLExpr>();
    protected boolean skewedByStoreAsDirectories;
    protected Map<String, SQLObject> serdeProperties = new LinkedHashMap<String, SQLObject>();
    protected boolean likeQuery;
    protected List<SQLAssignItem> mappedBy = new ArrayList<SQLAssignItem>(1);
    protected SQLExpr intoBuckets;
    protected SQLExpr using;
    private boolean lbracketUse;
    private boolean rbracketUse;

    public HiveCreateTableStatement() {
        this.dbType = DbType.hive;
    }

    public HiveCreateTableStatement(DbType dbType) {
        this.dbType = dbType;
    }

    public boolean isLbracketUse() {
        return this.lbracketUse;
    }

    public void setLbracketUse(boolean lbracketUse) {
        this.lbracketUse = lbracketUse;
    }

    public boolean isRbracketUse() {
        return this.rbracketUse;
    }

    public void setRbracketUse(boolean rbracketUse) {
        this.rbracketUse = rbracketUse;
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this)) {
            this.acceptChild(v);
        }
        v.endVisit(this);
    }

    @Override
    protected void acceptChild(SQLASTVisitor v) {
        super.acceptChild(v);
        this.acceptChild(v, this.skewedBy);
        this.acceptChild(v, this.skewedByOn);
        for (SQLObject item : this.serdeProperties.values()) {
            this.acceptChild(v, item);
        }
        this.acceptChild(v, this.intoBuckets);
    }

    public void cloneTo(HiveCreateTableStatement x) {
        super.cloneTo(x);
        for (SQLExpr sQLExpr : this.skewedBy) {
            x.addSkewedBy(sQLExpr.clone());
        }
        for (SQLExpr sQLExpr : this.skewedByOn) {
            x.addSkewedByOn(sQLExpr.clone());
        }
        for (Map.Entry entry : this.serdeProperties.entrySet()) {
            SQLObject entryValue = ((SQLObject)entry.getValue()).clone();
            entryValue.setParent(x);
            x.serdeProperties.put((String)entry.getKey(), entryValue);
        }
        x.setLikeQuery(this.likeQuery);
        if (this.mappedBy != null) {
            for (SQLAssignItem sQLAssignItem : this.mappedBy) {
                SQLAssignItem item2 = sQLAssignItem.clone();
                item2.setParent(this);
                x.mappedBy.add(item2);
            }
        }
        if (this.intoBuckets != null) {
            x.intoBuckets = this.intoBuckets.clone();
        }
        if (this.using != null) {
            x.setUsing(this.using.clone());
        }
    }

    @Override
    public HiveCreateTableStatement clone() {
        HiveCreateTableStatement x = new HiveCreateTableStatement();
        this.cloneTo(x);
        return x;
    }

    public List<SQLExpr> getSkewedBy() {
        return this.skewedBy;
    }

    public void addSkewedBy(SQLExpr item) {
        item.setParent(this);
        this.skewedBy.add(item);
    }

    public List<SQLExpr> getSkewedByOn() {
        return this.skewedByOn;
    }

    public void addSkewedByOn(SQLExpr item) {
        item.setParent(this);
        this.skewedByOn.add(item);
    }

    public void setSkewedByStoreAsDirectories(boolean skewedByStoreAsDirectories) {
        this.skewedByStoreAsDirectories = skewedByStoreAsDirectories;
    }

    public boolean isSkewedByStoreAsDirectories() {
        return this.skewedByStoreAsDirectories;
    }

    public Map<String, SQLObject> getSerdeProperties() {
        return this.serdeProperties;
    }

    public boolean isLikeQuery() {
        return this.likeQuery;
    }

    public void setLikeQuery(boolean likeQuery) {
        this.likeQuery = likeQuery;
    }

    public List<SQLAssignItem> getMappedBy() {
        return this.mappedBy;
    }

    public SQLExpr getIntoBuckets() {
        return this.intoBuckets;
    }

    public void setIntoBuckets(SQLExpr intoBuckets) {
        this.intoBuckets = intoBuckets;
    }

    public SQLExpr getUsing() {
        return this.using;
    }

    public void setUsing(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.using = x;
    }
}

