/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting.handler;

import com.alipay.sofa.registry.common.model.metaserver.DataCenterNodes;
import com.alipay.sofa.registry.common.model.metaserver.GetChangeListRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class GetChangeListRequestHandler
extends AbstractServerHandler<GetChangeListRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"META-CONNECT");
    @Autowired
    private Registry metaServerRegistry;

    @Override
    public Object reply(Channel channel, GetChangeListRequest getChangeListRequest) {
        DataCenterNodes dataCenterNodes;
        try {
            dataCenterNodes = this.metaServerRegistry.getDataCenterNodes(getChangeListRequest.getNodeType());
            LOGGER.info("Get change Node list {} success!from {}", (Object)dataCenterNodes, (Object)channel.getRemoteAddress());
        }
        catch (Exception e) {
            LOGGER.error("Get change Node list error!", (Throwable)e);
            throw new RuntimeException("Get change Node list error!", e);
        }
        return dataCenterNodes;
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return GetChangeListRequest.class;
    }
}

