/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class Utils {
    public static Logger logger = Logger.getLogger(Utils.class);

    public static URI getHttpURI(String endpoint) {
        if (endpoint == null) {
            logger.warn((Object)"\u53c2\u6570endpoint\u4e3a\u7a7a\u6307\u9488\u3002");
            throw new NullPointerException("\u53c2\u6570endpoint\u4e3a\u7a7a\u6307\u9488\u3002");
        }
        try {
            if (!endpoint.startsWith("http://")) {
                logger.warn((Object)"\u4ec5\u652f\u6301http\u534f\u8bae\u3002Endpoint\u5fc5\u987b\u4ee5http://\u5f00\u5934\u3002");
                throw new IllegalArgumentException("\u4ec5\u652f\u6301http\u534f\u8bae\u3002Endpoint\u5fc5\u987b\u4ee5http://\u5f00\u5934\u3002");
            }
            while (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            if (endpoint.length() < "http://".length()) {
                logger.warn((Object)"\u53c2\u6570endpoint\u5730\u5740\u65e0\u6548.");
                throw new IllegalArgumentException("\u53c2\u6570endpoint\u5730\u5740\u65e0\u6548.");
            }
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            logger.warn((Object)"uri syntax error");
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean checkName(String name) {
        if (name == null) {
            logger.debug((Object)"name is null");
            return false;
        }
        int len = name.length();
        if (len < 1 || len > 256) {
            logger.debug((Object)"length error, should in 1~255");
            return false;
        }
        if (!Character.isDigit(name.charAt(0)) && !Character.isLetter(name.charAt(0))) {
            logger.debug((Object)"name format error");
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (Character.isDigit(name.charAt(i)) || Character.isLetter(name.charAt(i)) || name.charAt(i) == '-') continue;
            logger.debug((Object)"name format error");
            return false;
        }
        return true;
    }

    public static boolean checkQueueName(String name) {
        return Utils.checkName(name);
    }

    public static boolean checkTopicName(String name) {
        return Utils.checkName(name);
    }

    public static boolean checkSubscriptionName(String name) {
        return Utils.checkName(name);
    }
}

