/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractClient<T>
implements ClickHouseClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    private boolean initialized = false;
    private ExecutorService executor = null;
    private ClickHouseConfig config = null;
    private ClickHouseNode server = null;
    private T connection = null;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Please initialize the client first");
        }
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    protected CompletableFuture<ClickHouseResponse> failedResponse(Throwable ex) {
        CompletableFuture<ClickHouseResponse> future = new CompletableFuture<ClickHouseResponse>();
        future.completeExceptionally(ex);
        return future;
    }

    protected final ExecutorService getExecutor() {
        this.lock.readLock().lock();
        try {
            this.ensureInitialized();
            ExecutorService executorService = this.executor;
            return executorService;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected final ClickHouseNode getServer() {
        this.lock.readLock().lock();
        try {
            this.ensureInitialized();
            ClickHouseNode clickHouseNode = this.server;
            return clickHouseNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected boolean checkConnection(T connection, ClickHouseNode requestServer, ClickHouseNode currentServer, ClickHouseRequest<?> request) {
        return connection != null && requestServer.equals(currentServer);
    }

    protected abstract T newConnection(T var1, ClickHouseNode var2, ClickHouseRequest<?> var3);

    protected abstract void closeConnection(T var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T getConnection(ClickHouseRequest<?> request) {
        ClickHouseNode newNode = ClickHouseChecker.nonNull(request, "request").getServer();
        this.lock.readLock().lock();
        try {
            this.ensureInitialized();
            if (this.checkConnection(this.connection, newNode, this.server, request)) {
                T t = this.connection;
                return t;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            this.server = newNode;
            log.debug((Object)"Connecting to: %s", newNode);
            this.connection = this.newConnection(this.connection, this.server, request);
            log.debug((Object)"Connection established: %s", this.connection);
            T t = this.connection;
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public final ClickHouseConfig getConfig() {
        this.lock.readLock().lock();
        try {
            this.ensureInitialized();
            ClickHouseConfig clickHouseConfig = this.config;
            return clickHouseConfig;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void init(ClickHouseConfig config) {
        ClickHouseChecker.nonNull(config, "config");
        this.lock.writeLock().lock();
        try {
            this.config = config;
            if (this.executor == null) {
                int threads = config.getMaxThreadsPerClient();
                this.executor = threads < 1 ? ClickHouseClient.getExecutorService() : ClickHouseUtils.newThreadPool(this, threads, config.getMaxQueuedRequests());
            }
            this.initialized = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        this.lock.readLock().lock();
        try {
            if (!this.initialized) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            this.server = null;
            if (this.connection != null) {
                this.closeConnection(this.connection, false);
                this.connection = null;
            }
            if (this.executor != null && this.config.getMaxThreadsPerClient() > 0 && !this.executor.isTerminated()) {
                this.executor.shutdown();
            }
            this.executor = null;
        }
        catch (Exception e) {
            log.warn((Object)"Exception occurred when closing client", e);
        }
        finally {
            this.initialized = false;
            try {
                if (this.connection != null) {
                    this.closeConnection(this.connection, true);
                }
                if (this.executor != null && this.config.getMaxThreadsPerClient() > 0) {
                    this.executor.shutdownNow();
                }
            }
            finally {
                this.executor = null;
                this.connection = null;
                this.lock.writeLock().unlock();
            }
        }
    }
}

