package com.ejianc.business.asset.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.List;

/**
 * 报废处置主表
 * 
 * @author generator
 * 
 */
public class MaterialDealVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.util.Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人编码
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectTypeCode; // 项目性质编码
    private String projectTypeName; // 项目性质名称
    private Long orgId; // 组织Id
    private String orgName; // 组织名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private String dealUserName; // 处置人
    private java.math.BigDecimal dealMoney; // 处置总金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date dealDate; // 处置日期
    private Integer finishState; // 是否处置完成0未处置1已处置
    private String remark; // 备注
    private Integer belongType; // 0项目1公司
    
    private List<MaterialDealDetailVO> materialDealDetail = new ArrayList<>(); // 报废处置子表


    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }



    /**
     * 提交日期
     */
    public java.util.Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(java.util.Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人编码
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人编码
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目Id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目性质编码
     */
    public String getProjectTypeCode() {
        return projectTypeCode;
    }

    /**
     * 项目性质编码
     */
    public void setProjectTypeCode(String projectTypeCode) {
        this.projectTypeCode = projectTypeCode;
    }
    /**
     * 项目性质名称
     */
    public String getProjectTypeName() {
        return projectTypeName;
    }

    /**
     * 项目性质名称
     */
    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    /**
     * 组织Id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织Id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 处置人
     */
    public String getDealUserName() {
        return dealUserName;
    }

    /**
     * 处置人
     */
    public void setDealUserName(String dealUserName) {
        this.dealUserName = dealUserName;
    }
    /**
     * 处置总金额
     */
    public java.math.BigDecimal getDealMoney() {
        return dealMoney;
    }

    /**
     * 处置总金额
     */
    public void setDealMoney(java.math.BigDecimal dealMoney) {
        this.dealMoney = dealMoney;
    }
    /**
     * 处置日期
     */
    public java.util.Date getDealDate() {
        return dealDate;
    }

    /**
     * 处置日期
     */
    public void setDealDate(java.util.Date dealDate) {
        this.dealDate = dealDate;
    }
    /**
     * 是否处置完成0未处置1已处置
     */
    public Integer getFinishState() {
        return finishState;
    }

    /**
     * 是否处置完成0未处置1已处置
     */
    public void setFinishState(Integer finishState) {
        this.finishState = finishState;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 0项目1公司
     */
    public Integer getBelongType() {
        return belongType;
    }

    /**
     * 0项目1公司
     */
    public void setBelongType(Integer belongType) {
        this.belongType = belongType;
    }

    public List<MaterialDealDetailVO> getMaterialDealDetail() {
        return materialDealDetail;
    }

    public void setMaterialDealDetail(List<MaterialDealDetailVO> materialDealDetail) {
        this.materialDealDetail = materialDealDetail;
    }
}
