package com.ejianc.business.panhuo.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 资产表
 *
 * @author generator
 *
 */
public class GoodsVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.String billCode; // 资产编号
    private java.lang.Integer belongType; // 类型 0=项目，1=公司
    private java.lang.Long seller; // 发布人
    private java.lang.String sellerName; // 发布人名称
    private java.lang.Long toolId; // 机具主键
    private java.lang.String mainimgPath; // 资产主图URL
    private java.lang.Long projectId; // 项目主键
    private java.lang.Long orgId; // 组织主键
    private java.lang.String projectName; // 项目名称
    private java.lang.String orgName; // 组织名称
    private java.lang.Long belongOrgId; // 归属公司主键
    private java.lang.String belongOrgName; // 归属公司名称
    private java.lang.String spec; // 规格型号
    private java.lang.String shelfType; // 资产类型 0-周转材，1-机具，2-剩余物资，3-办公用品
    private java.lang.Long materialId; // 物资主键
    private java.lang.String materialName; // 物资名称
    private java.lang.String materialCode; // 物资编号
    private java.lang.Long materialTypeId; // 物资类别
    private java.lang.String materialTypeCode; // 物资类别编号
    private java.lang.String materialTypeName; // 物资类别名称
    private java.lang.Integer assetType; // 物资类型 0-周转材，1-台车
    private java.lang.String assetCode; // 资产编码
    private java.lang.Long assetId; // 物资主键
    private java.math.BigDecimal capacity; // 承载量
    private java.lang.Integer assetBelongType; // 资产归属 0-项目，1-公司
    private java.lang.Integer recoveryType; // 回收类型 0-待指定回收 1-已指定回收  2-待公司回收
    private java.lang.String sourceId; // 物资来源ID
    private java.lang.Long systemId; // 所属系统ID
    private java.math.BigDecimal guidePrice; // 指导价格
    private java.math.BigDecimal siteNums; // 在场数量
    private java.math.BigDecimal originalprice; // 原价
    private java.math.BigDecimal discount; // 折扣
    private java.lang.String unit; // 单位
    private java.math.BigDecimal price; // 单价
    private java.math.BigDecimal nums; // 数量
    private java.math.BigDecimal shelfMny; // 上架总金额
    private java.math.BigDecimal sellNums; // 已成交数量
    private java.math.BigDecimal preNums; // 预定中数量
    private java.math.BigDecimal rotatableNums; // 可周转数量(上架-已成交-预定中)
    private java.math.BigDecimal remainingNums; // 剩余数量(上架-已成交)
    private java.lang.String isPack; // 是否打包出售 0-是  1-否
    private java.lang.Long addressId; // 地址主键
    private java.lang.String addressName; // 出售项目
    private java.lang.String address; // 详细地址
    private java.lang.String projectAddress; // 项目地址
    private java.lang.String firstLocation; // 所在地一级区域
    private java.lang.Double lon; // 经度
    private java.lang.Double lat; // 纬度
    private java.lang.String secondLocation; // 所在地二级区域
    private java.lang.String thirdLocation; // 所在地三级区域
    private java.lang.String fourthLocation; // 所在地四级区域
    private java.lang.String location; // 所在地末级区域
    private java.lang.String phone; // 联系方式
    private java.lang.String name; // 联系人
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private java.util.Date shelfTime; // 上架时间
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private java.util.Date lowerTime; // 下架时间
    private java.lang.Integer lowerType; // 下架类型0-手动下架，1-售罄下架，2-回收下架
    private java.lang.Long lower; // 下架人
    private java.lang.String details; // 资产详情
    private java.lang.Integer status; // 资产状态0-在售，1-下架，2-暂存，3-待回收，4-已回收
    private java.lang.String labelName; // 标签名称
    private java.lang.Integer isCollect; // 是否收藏
    private java.lang.Long collectId; // 收藏主键

    private int type; // 上架类型 0-手动上架，1-加工上架

    private java.lang.Long orderId; // 订单主键

    private java.lang.String distance; // 距离

    // 加工上架用
    private java.math.BigDecimal addTon; // 加工吨位
    private java.math.BigDecimal useTon; // 利旧吨位
    private java.math.BigDecimal ton; // 吨位
    private Long turnoverRecordId; // 利旧资产记录ID
    private Long useAssetId; // 利旧资产id
    private String useAssetCode; // 利旧资产编码
    private Long recordId;//记录表ID

    // 标签子表
    private List<LabeldetailVO> labels = new ArrayList<>();

    // 图片子表
    private List<ImgdetailVO> imgsPath = new ArrayList<>();

    @ReferSerialTransfer(referCode="cr12g_record")
    public Long getRecordId() {
        return recordId;
    }
    @ReferDeserialTransfer
    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public BigDecimal getShelfMny() {
        return shelfMny;
    }

    public void setShelfMny(BigDecimal shelfMny) {
        this.shelfMny = shelfMny;
    }

    public List<LabeldetailVO> getLabels() {
        return labels;
    }

    public void setLabels(List<LabeldetailVO> labels) {
        this.labels = labels;
    }

    public List<ImgdetailVO> getImgsPath() {
        return imgsPath;
    }

    public void setImgsPath(List<ImgdetailVO> imgsPath) {
        this.imgsPath = imgsPath;
    }

    public Long getCollectId() {
        return collectId;
    }

    public void setCollectId(Long collectId) {
        this.collectId = collectId;
    }

    public Integer getIsCollect() {
        return isCollect;
    }

    public void setIsCollect(Integer isCollect) {
        this.isCollect = isCollect;
    }

    public Double getLon() {
        return lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Double getLat() {
        return lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public String getDistance() {
        return distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    /**
     * 资产编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 资产编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 发布人
     */
    public java.lang.Long getSeller() {
        return seller;
    }

    /**
     * 发布人
     */
    public void setSeller(java.lang.Long seller) {
        this.seller = seller;
    }
    /**
     * 发布人名称
     */
    public java.lang.String getSellerName() {
        return sellerName;
    }

    /**
     * 发布人名称
     */
    public void setSellerName(java.lang.String sellerName) {
        this.sellerName = sellerName;
    }
    /**
     * 机具主键
     */
    public java.lang.Long getToolId() {
        return toolId;
    }

    /**
     * 机具主键
     */
    public void setToolId(java.lang.Long toolId) {
        this.toolId = toolId;
    }
    /**
     * 资产主图URL
     */
    public java.lang.String getMainimgPath() {
        return mainimgPath;
    }

    /**
     * 资产主图URL
     */
    public void setMainimgPath(java.lang.String mainimgPath) {
        this.mainimgPath = mainimgPath;
    }
    /**
     * 项目主键
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目主键
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织主键
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 规格型号
     */
    public java.lang.String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(java.lang.String spec) {
        this.spec = spec;
    }
    /**
     * 资产类型0-周转材，1-机具，2-剩余物资，3-办公用品
     */
    public java.lang.String getShelfType() {
        return shelfType;
    }

    /**
     * 资产类型
     */
    public void setShelfType(java.lang.String shelfType) {
        this.shelfType = shelfType;
    }
    /**
     * 物资主键
     */
    @ReferSerialTransfer(referCode="Material001")
    public java.lang.Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    @ReferDeserialTransfer
    public void setMaterialId(java.lang.Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资类别
     */
    public java.lang.Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(java.lang.Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public java.lang.String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(java.lang.String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资来源ID
     */
    public java.lang.String getSourceId() {
        return sourceId;
    }

    /**
     * 物资来源ID
     */
    public void setSourceId(java.lang.String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 所属系统ID
     */
    public java.lang.Long getSystemId() {
        return systemId;
    }

    /**
     * 所属系统ID
     */
    public void setSystemId(java.lang.Long systemId) {
        this.systemId = systemId;
    }
    /**
     * 原价
     */
    public java.math.BigDecimal getOriginalprice() {
        return originalprice;
    }

    /**
     * 原价
     */
    public void setOriginalprice(java.math.BigDecimal originalprice) {
        this.originalprice = originalprice;
    }
    /**
     * 折扣
     */
    public java.math.BigDecimal getDiscount() {
        return discount;
    }

    /**
     * 折扣
     */
    public void setDiscount(java.math.BigDecimal discount) {
        this.discount = discount;
    }
    /**
     * 单位
     */
    public java.lang.String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(java.lang.String unit) {
        this.unit = unit;
    }
    /**
     * 单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 数量
     */
    public java.math.BigDecimal getNums() {
        return nums;
    }

    /**
     * 数量
     */
    public void setNums(java.math.BigDecimal nums) {
        this.nums = nums;
    }
    /**
     * 已成交数量
     */
    public java.math.BigDecimal getSellNums() {
        return sellNums;
    }

    /**
     * 已成交数量
     */
    public void setSellNums(java.math.BigDecimal sellNums) {
        this.sellNums = sellNums;
    }
    /**
     * 预定中数量
     */
    public java.math.BigDecimal getPreNums() {
        return preNums;
    }

    /**
     * 预定中数量
     */
    public void setPreNums(java.math.BigDecimal preNums) {
        this.preNums = preNums;
    }
    /**
     * 可周转数量(上架-已成交-预定中)
     */
    public java.math.BigDecimal getRotatableNums() {
        return rotatableNums;
    }

    /**
     * 可周转数量(上架-已成交-预定中)
     */
    public void setRotatableNums(java.math.BigDecimal rotatableNums) {
        this.rotatableNums = rotatableNums;
    }
    /**
     * 剩余数量(上架-已成交)
     */
    public java.math.BigDecimal getRemainingNums() {
        return remainingNums;
    }

    /**
     * 剩余数量(上架-已成交)
     */
    public void setRemainingNums(java.math.BigDecimal remainingNums) {
        this.remainingNums = remainingNums;
    }
    /**
     * 0-是  1-否
     */
    public java.lang.String getIsPack() {
        return isPack;
    }

    /**
     * 0-是  1-否
     */
    public void setIsPack(java.lang.String isPack) {
        this.isPack = isPack;
    }
    /**
     * 地址主键
     */
    @ReferSerialTransfer(referCode="panhuo-address")
    public java.lang.Long getAddressId() {
        return addressId;
    }

    /**
     * 地址主键
     */
    @ReferDeserialTransfer
    public void setAddressId(java.lang.Long addressId) {
        this.addressId = addressId;
    }
    /**
     * 出售项目
     */
    public java.lang.String getAddressName() {
        return addressName;
    }

    /**
     * 出售项目
     */
    public void setAddressName(java.lang.String addressName) {
        this.addressName = addressName;
    }
    /**
     * 详细地址
     */
    public java.lang.String getAddress() {
        return address;
    }

    /**
     * 详细地址
     */
    public void setAddress(java.lang.String address) {
        this.address = address;
    }
    /**
     * 所在地一级区域
     */
    public java.lang.String getFirstLocation() {
        return firstLocation;
    }

    /**
     * 所在地一级区域
     */
    public void setFirstLocation(java.lang.String firstLocation) {
        this.firstLocation = firstLocation;
    }
    /**
     * 所在地二级区域
     */
    public java.lang.String getSecondLocation() {
        return secondLocation;
    }

    /**
     * 所在地二级区域
     */
    public void setSecondLocation(java.lang.String secondLocation) {
        this.secondLocation = secondLocation;
    }
    /**
     * 所在地三级区域
     */
    public java.lang.String getThirdLocation() {
        return thirdLocation;
    }

    /**
     * 所在地三级区域
     */
    public void setThirdLocation(java.lang.String thirdLocation) {
        this.thirdLocation = thirdLocation;
    }
    /**
     * 所在地四级区域
     */
    public java.lang.String getFourthLocation() {
        return fourthLocation;
    }

    /**
     * 所在地四级区域
     */
    public void setFourthLocation(java.lang.String fourthLocation) {
        this.fourthLocation = fourthLocation;
    }
    /**
     * 所在地末级区域
     */
    public java.lang.String getLocation() {
        return location;
    }

    /**
     * 所在地末级区域
     */
    public void setLocation(java.lang.String location) {
        this.location = location;
    }
    /**
     * 联系方式
     */
    public java.lang.String getPhone() {
        return phone;
    }

    /**
     * 联系方式
     */
    public void setPhone(java.lang.String phone) {
        this.phone = phone;
    }
    /**
     * 联系人
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 联系人
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }
    /**
     * 上架时间
     */
    public java.util.Date getShelfTime() {
        return shelfTime;
    }

    /**
     * 上架时间
     */
    public void setShelfTime(java.util.Date shelfTime) {
        this.shelfTime = shelfTime;
    }
    /**
     * 下架时间
     */
    public java.util.Date getLowerTime() {
        return lowerTime;
    }

    /**
     * 下架时间
     */
    public void setLowerTime(java.util.Date lowerTime) {
        this.lowerTime = lowerTime;
    }
    /**
     * 下架类型0-手动下架，1-售罄下架，2-到期下架
     */
    public java.lang.Integer getLowerType() {
        return lowerType;
    }

    /**
     * 下架类型0-手动下架，1-售罄下架，2-到期下架
     */
    public void setLowerType(java.lang.Integer lowerType) {
        this.lowerType = lowerType;
    }
    /**
     * 下架人
     */
    public java.lang.Long getLower() {
        return lower;
    }

    /**
     * 下架人
     */
    public void setLower(java.lang.Long lower) {
        this.lower = lower;
    }
    /**
     * 资产详情
     */
    public java.lang.String getDetails() {
        return details;
    }

    /**
     * 资产详情
     */
    public void setDetails(java.lang.String details) {
        this.details = details;
    }
    /**
     * 资产状态0-在售，1-下架，2-暂存
     */
    public java.lang.Integer getStatus() {
        return status;
    }

    /**
     * 资产状态0-在售，1-下架，2-暂存
     */
    public void setStatus(java.lang.Integer status) {
        this.status = status;
    }
    /**
     * 标签名称
     */
    public java.lang.String getLabelName() {
        return labelName;
    }

    /**
     * 标签名称
     */
    public void setLabelName(java.lang.String labelName) {
        this.labelName = labelName;
    }

    public Integer getBelongType() {
        return belongType;
    }

    public void setBelongType(Integer belongType) {
        this.belongType = belongType;
    }

    public Long getBelongOrgId() {
        return belongOrgId;
    }

    public void setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
    }

    public String getBelongOrgName() {
        return belongOrgName;
    }

    public void setBelongOrgName(String belongOrgName) {
        this.belongOrgName = belongOrgName;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public Integer getAssetType() {
        return assetType;
    }

    public void setAssetType(Integer assetType) {
        this.assetType = assetType;
    }

    public String getAssetCode() {
        return assetCode;
    }

    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }

    public Long getAssetId() {
        return assetId;
    }

    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }

    public BigDecimal getCapacity() {
        return capacity;
    }

    public void setCapacity(BigDecimal capacity) {
        this.capacity = capacity;
    }

    public Integer getAssetBelongType() {
        return assetBelongType;
    }

    public void setAssetBelongType(Integer assetBelongType) {
        this.assetBelongType = assetBelongType;
    }

    public Integer getRecoveryType() {
        return recoveryType;
    }

    public void setRecoveryType(Integer recoveryType) {
        this.recoveryType = recoveryType;
    }

    public BigDecimal getGuidePrice() {
        return guidePrice;
    }

    public void setGuidePrice(BigDecimal guidePrice) {
        this.guidePrice = guidePrice;
    }

    public BigDecimal getSiteNums() {
        return siteNums;
    }

    public void setSiteNums(BigDecimal siteNums) {
        this.siteNums = siteNums;
    }

    public BigDecimal getAddTon() {
        return addTon;
    }

    public void setAddTon(BigDecimal addTon) {
        this.addTon = addTon;
    }

    public BigDecimal getUseTon() {
        return useTon;
    }

    public void setUseTon(BigDecimal useTon) {
        this.useTon = useTon;
    }

    public BigDecimal getTon() {
        return ton;
    }

    public void setTon(BigDecimal ton) {
        this.ton = ton;
    }

    public Long getUseAssetId() {
        return useAssetId;
    }

    public void setUseAssetId(Long useAssetId) {
        this.useAssetId = useAssetId;
    }

    public String getUseAssetCode() {
        return useAssetCode;
    }

    public void setUseAssetCode(String useAssetCode) {
        this.useAssetCode = useAssetCode;
    }

    public Long getTurnoverRecordId() {
        return turnoverRecordId;
    }

    public void setTurnoverRecordId(Long turnoverRecordId) {
        this.turnoverRecordId = turnoverRecordId;
    }
}
