package com.ejianc.business.asset.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.asset.bean.PricePublishDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 价格发布主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_panhuo_price_publish")
public class PricePublishEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="commit_date")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private java.util.Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 组织Id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="publish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date publishDate; // 编制日期
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="source_type")
    private Integer sourceType; // 1新增/2参照往期
    @TableField(value="enabled")
    private Integer enabled; // 0停用1启用


    @TableField(exist=false)
    @SubEntity(serviceName="pricePublishDetailService", pidName = "pId")
    private List<PricePublishDetailEntity> pricePublishDetail = new ArrayList<>(); // 价格发布子表
    

    /**
     * 提交日期
     */
    public java.util.Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(java.util.Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人编码
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人编码
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 组织Id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织Id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 经办人id
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 编制日期
     */
    public java.util.Date getPublishDate() {
        return publishDate;
    }

    /**
     * 编制日期
     */
    public void setPublishDate(java.util.Date publishDate) {
        this.publishDate = publishDate;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 1新增/2参照往期
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 1新增/2参照往期
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 0停用1启用
     */
    public Integer getEnabled() {
        return enabled;
    }

    /**
     * 0停用1启用
     */
    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }

    public List<PricePublishDetailEntity> getPricePublishDetail() {
        return pricePublishDetail;
    }

    public void setPricePublishDetail(List<PricePublishDetailEntity> pricePublishDetail) {
        this.pricePublishDetail = pricePublishDetail;
    }
}
