package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.asset.bean.CheckDetailEntity;
import com.ejianc.business.asset.bean.PlanDetailEntity;
import com.ejianc.business.asset.bean.CheckEntity;
import com.ejianc.business.asset.service.IPlanService;
import com.ejianc.business.asset.vo.CheckVO;
import com.ejianc.business.asset.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.CheckMapper;
import com.ejianc.business.asset.bean.CheckEntity;
import com.ejianc.business.asset.service.ICheckService;

import java.util.List;

/**
 * 验收实体
 * 
 * @author generator
 * 
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{
    private static final String EJC_CRG_CHECK = "EJC_CRG_CHECK";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IOrgApi orgApi;
    @Override
    public CommonResponse<CheckVO> saveOrUpdate(CheckVO checkVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(checkVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(EJC_CRG_CHECK,tenantId);
            if(billCode.isSuccess()) {
                checkVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        CheckEntity entity = BeanMapper.map(checkVO, CheckEntity.class);
        //汇总物资明细名称
        List<CheckDetailEntity> checkDetail = entity.getCheckDetail();
        String materialName = "";
        if(checkDetail != null && checkDetail.size() > 0){
            for(CheckDetailEntity checkDetailEntity : checkDetail){
                materialName = materialName + checkDetailEntity.getMaterialName() + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        checkService.saveOrUpdate(entity, false);
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
