package com.ejianc.business.asset.task;

import com.ejianc.business.asset.bean.PricePublishDetailEntity;
import com.ejianc.business.asset.service.IPricePublishService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 将符合条件的上架物资更改为待指定状态
 * 定时扫描项目上架的物资, 资产属性是项目的,上架45天后没有买家购买,由公司物资部指定专业公司进行回收
 * @date 2021-05-08
 */
@Configuration      //1.主要用于标记配置类，兼备Component的效果。
@EnableScheduling   // 2.开启定时任务
public class RecoveryScheduleTask {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IPricePublishService service;

    static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//设置日期格式

    /***

     每天23点执行一次：0 0 23 * * ?

     每天凌晨1点执行一次：0 0 1 * * ?

     每月1号凌晨1点执行一次：0 0 1 1 * ?

     每月最后一天23点执行一次：0 0 23 L * ?

     每周星期天凌晨1点实行一次：0 0 1 ? * L

     在26分、29分、33分执行一次：0 26,29,33 * * * ?

     每天的0点、13点、18点、21点都执行一次：0 0 0,13,18,21 * * ?
     */


    @Scheduled(cron = "0 0 1 1 * ?")
    private void configureTasks() {
        logger.info(">>>start>>>项目上架物资超时指定任务开始执行[" + df.format(new Date()) + "]...");

        Map param = new HashMap<String, Object>();
        param.put("enabled", 1);
        param.put("tenantId", InvocationInfoProxy.getTenantid());

        Map<String, Object> beans = new HashMap<String, Object>();
        List<PricePublishDetailEntity> pricePublishDetailEntities = service.queryDetail(param);

        logger.info(">>>end>>>项目上架物资超时指定任务结束执行[执行结果" + pricePublishDetailEntities.size() + "].");

    }

}
