package com.ejianc.business.asset.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.asset.vo.AssignVO;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author songlx
 * @version 1.0
 * @description: 回收控制器
 * @date 2021-05-14
 */
@Controller
@RequestMapping("recovery")
public class RecoveryController implements Serializable {

    @Autowired
    private IGoodsService service;

    @Autowired
    private ITurnoverRecordService turnoverRecordService;


    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("address");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //启用状态
        IPage<GoodsEntity> page = service.queryPage(param, false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param assignVO
     * @description: 指定/取消指定操作
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021-05-14
     */
    @RequestMapping(value = "/assign", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> assign(@RequestBody AssignVO assignVO) {
        List<GoodsVO> goods = assignVO.getGoods();
        if (CollectionUtil.isNotEmpty(goods)) {
            Integer flag = assignVO.getFlag();
            List<Long> goodsIds = goods.stream().map(GoodsVO::getId).collect(Collectors.toList());
            List<GoodsEntity> goodsEntities = (List<GoodsEntity>) service.listByIds(goodsIds);
            if (CollectionUtil.isNotEmpty(goodsEntities)) {
                //指定操作
                if (1 == flag) {
                    for (GoodsEntity e : goodsEntities) {
                        //已制定回收
                        e.setRecoveryType(1);
                        e.setAssetBelongType(1);
                        e.setBelongOrgId(assignVO.getOrgId());
                        e.setBelongOrgName(assignVO.getOrgName());
                    }
                } else {
                    for (GoodsEntity e : goodsEntities) {
                        //已制定回收
                        e.setRecoveryType(0);
                        e.setAssetBelongType(0);
                        e.setBelongOrgId(null);
                        e.setBelongOrgName(null);
                    }
                }
                service.updateBatchById(goodsEntities);

            }

        }

        return CommonResponse.success("操作成功！");
    }


    /**
     * @param assignVO
     * @description: 回收
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021-05-14
     */
    @RequestMapping(value = "/recovery", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> recovery(@RequestBody AssignVO assignVO) {
        List<GoodsVO> goods = assignVO.getGoods();
        if (CollectionUtil.isNotEmpty(goods)) {
            Integer flag = assignVO.getFlag();
            List<Long> goodsIds = goods.stream().map(GoodsVO::getId).collect(Collectors.toList());
            List<GoodsEntity> goodsEntities = (List<GoodsEntity>) service.listByIds(goodsIds);
            if (CollectionUtil.isNotEmpty(goodsEntities)) {
                //回收
                for (GoodsEntity e : goodsEntities) {
                    //已回收
                    e.setStatus(4);
                    //回收下架
                    e.setLowerType(2);
                    e.setLowerTime(new Date());
                }
                List<TurnoverRecordEntity> turnoverRecordEntitList = new ArrayList<>();
                for (GoodsEntity e : goodsEntities) {
                    //公司的资产回收
                    turnoverRecordEntitList.add(this.getGSRecord(TurnoverTypeEnum.资产回收, e));
                    //项目的回收退场
                    turnoverRecordEntitList.add(this.getXMRecord(TurnoverTypeEnum.回收退场, e));
                }
                turnoverRecordService.saveBatch(turnoverRecordEntitList);
                service.updateBatchById(goodsEntities);

            }

        }

        return CommonResponse.success("操作成功！");
    }


    /**
     * @description: 项目的回收退场
     *
     * @param t
     * @param e
     * @return: com.ejianc.business.asset.bean.TurnoverRecordEntity
     * @author songlx
     * @date: 2021-05-14
     */
    private TurnoverRecordEntity getXMRecord(TurnoverTypeEnum t, GoodsEntity e) {
        TurnoverRecordEntity turnoverRecordEntity = TurnoverRecordEntity.instance(t);
        turnoverRecordEntity.setMaterialTypeName(e.getMaterialTypeName());
        turnoverRecordEntity.setMaterialTypeCode(e.getMaterialTypeCode());
        turnoverRecordEntity.setMaterialTypeId(e.getMaterialTypeId());
        turnoverRecordEntity.setMaterialCode(e.getMaterialCode());
        turnoverRecordEntity.setMaterialId(e.getMaterialId());
        turnoverRecordEntity.setMaterialName(e.getMaterialName());
        turnoverRecordEntity.setSpec(e.getSpec());
        turnoverRecordEntity.setUnit(e.getUnit());
        turnoverRecordEntity.setAssetId(e.getAssetId());
        turnoverRecordEntity.setAssetCode(e.getAssetCode());
        turnoverRecordEntity.setAssetType(e.getAssetType());
        turnoverRecordEntity.setOrgId(e.getOrgId());
        turnoverRecordEntity.setOrgName(e.getOrgName());
        turnoverRecordEntity.setProjectId(e.getProjectId());
        turnoverRecordEntity.setProjectName(e.getProjectName());
        turnoverRecordEntity.setSourceDate(e.getLowerTime());
        turnoverRecordEntity.setSourceId(e.getId());
        turnoverRecordEntity.setSourceDetailId(e.getId());
        turnoverRecordEntity.setBelongType(e.getBelongType());
        turnoverRecordEntity.setAssetBelongType(0);
        //可周转数量
        BigDecimal num = e.getRotatableNums() != null ? e.getRotatableNums() : BigDecimal.ZERO;
        turnoverRecordEntity.setNum(BigDecimal.ZERO.subtract(num));

        return turnoverRecordEntity;
    }

    /**
     * @description: 公司的资产回收
     *
     * @param t
     * @param e
     * @return: com.ejianc.business.asset.bean.TurnoverRecordEntity
     * @author songlx
     * @date: 2021-05-14
     */
    private TurnoverRecordEntity getGSRecord(TurnoverTypeEnum t, GoodsEntity e) {
        TurnoverRecordEntity turnoverRecordEntity = TurnoverRecordEntity.instance(t);
        turnoverRecordEntity.setMaterialTypeName(e.getMaterialTypeName());
        turnoverRecordEntity.setMaterialTypeCode(e.getMaterialTypeCode());
        turnoverRecordEntity.setMaterialTypeId(e.getMaterialTypeId());
        turnoverRecordEntity.setMaterialCode(e.getMaterialCode());
        turnoverRecordEntity.setMaterialId(e.getMaterialId());
        turnoverRecordEntity.setMaterialName(e.getMaterialName());
        turnoverRecordEntity.setSpec(e.getSpec());
        turnoverRecordEntity.setUnit(e.getUnit());
        turnoverRecordEntity.setAssetId(e.getAssetId());
        turnoverRecordEntity.setAssetCode(e.getAssetCode());
        turnoverRecordEntity.setAssetType(e.getAssetType());
        turnoverRecordEntity.setOrgId(e.getBelongOrgId());
        turnoverRecordEntity.setOrgName(e.getBelongOrgName());
        turnoverRecordEntity.setSourceDate(e.getLowerTime());
        turnoverRecordEntity.setSourceId(e.getId());
        turnoverRecordEntity.setSourceDetailId(e.getId());
        turnoverRecordEntity.setBelongType(1);
        turnoverRecordEntity.setAssetBelongType(1);
        turnoverRecordEntity.setBelongOrgId(e.getBelongOrgId());
        turnoverRecordEntity.setBelongOrgName(e.getBelongOrgName());
        //可周转数量
        BigDecimal num = e.getRotatableNums() != null ? e.getRotatableNums() : BigDecimal.ZERO;
        turnoverRecordEntity.setNum(num);

        return turnoverRecordEntity;
    }

}
