package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.asset.bean.CheckDetailEntity;
import com.ejianc.business.asset.bean.PlanDetailEntity;
import com.ejianc.business.asset.bean.CheckEntity;
import com.ejianc.business.asset.service.IPlanService;
import com.ejianc.business.asset.vo.CheckVO;
import com.ejianc.business.asset.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.CheckMapper;
import com.ejianc.business.asset.bean.CheckEntity;
import com.ejianc.business.asset.service.ICheckService;

import java.util.ArrayList;
import java.util.List;

/**
 * 验收实体
 * 
 * @author generator
 * 
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{
    private static final String CRG_PRO_CHECK = "CRG_PRO_CHECK";
    private static final String CRG_ORG_CHECK = "CRG_ORG_CHECK";
    private static final String ASSET_CODE = "ASSET_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IOrgApi orgApi;
    @Override
    public CommonResponse<CheckVO> saveOrUpdate(CheckVO checkVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(checkVO.getBillCode())){
            //区分项目和专业公司单据编码
            CommonResponse<String> billCode = null;
            if (checkVO.getBelongType() == 0){
                billCode = billCodeApi.getCodeBatchByRuleCode(CRG_PRO_CHECK,tenantId);
            }
            if (checkVO.getBelongType() == 1){
                billCode = billCodeApi.getCodeBatchByRuleCode(CRG_ORG_CHECK,tenantId);
            }
            if(billCode.isSuccess()) {
                checkVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        CheckEntity entity = BeanMapper.map(checkVO, CheckEntity.class);
        //汇总物资明细名称
        List<CheckDetailEntity> checkDetail = entity.getCheckDetail();
        String materialName = "";
        int count = 0;
        List<String> materialNameList = new ArrayList<>();
        if(checkDetail != null && checkDetail.size() > 0){
            for (CheckDetailEntity checkDetailEntity : checkDetail){
                if (null == checkDetailEntity.getAssetCode()){
                    ++count;
                }

                if (!materialNameList.contains(checkDetailEntity.getMaterialName())){
                    materialNameList.add(checkDetailEntity.getMaterialName());
                }
            }
        }
        if (count > 0){
            CommonResponse<List<String>> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(ASSET_CODE, tenantId, count);
            List<String> assetCodeList = codeBatchByRuleCode.getData();
            for (String code : assetCodeList){
                for (CheckDetailEntity checkDetailEntity : checkDetail){
                    if(null == checkDetailEntity.getAssetCode()){
                        checkDetailEntity.setAssetCode(code);
                        checkDetailEntity.setAssetId(IdWorker.getId());
                        break;
                    }
                }
            }

        }

        if(materialNameList != null && materialNameList.size() > 0){
            for(String materialNames : materialNameList){
                materialName = materialName + materialNames + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        checkService.saveOrUpdate(entity, false);
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
