package com.ejianc.business.asset.service.impl;

import com.ejianc.business.asset.bean.*;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.IMaterialDealService;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("materialDeal")
public class MaterialDealBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IMaterialDealService service;

    @Autowired
    private ITurnoverRecordService turnoverRecordService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //处置完成 不能弃审
        MaterialDealEntity materialDealEntity = service.getById(billId);
        if (materialDealEntity != null && materialDealEntity.getFinishState() == 1) {
            return CommonResponse.error("该单据已处置完成,不可弃审!");
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MaterialDealEntity materialDealEntity = service.selectById(billId);
        List<MaterialDealDetailEntity> materialDealDetail = materialDealEntity.getMaterialDealDetail();
        List<TurnoverRecordEntity> turnoverRecordEntitList = new ArrayList<>();
        TurnoverRecordEntity turnoverRecordEntity = null;
        for (MaterialDealDetailEntity materialDealDetailEntity : materialDealDetail) {
            if (materialDealEntity.getBelongType() == 0) {
                turnoverRecordEntity = TurnoverRecordEntity.instance(TurnoverTypeEnum.项目资产处置);
            } else {
                turnoverRecordEntity = TurnoverRecordEntity.instance(TurnoverTypeEnum.公司资产处置);
            }

            turnoverRecordEntity.setMaterialTypeName(materialDealDetailEntity.getMaterialTypeName());
            turnoverRecordEntity.setMaterialTypeCode(materialDealDetailEntity.getMaterialTypeCode());
            turnoverRecordEntity.setMaterialTypeId(materialDealDetailEntity.getMaterialTypeId());
            turnoverRecordEntity.setMaterialCode(materialDealDetailEntity.getMaterialCode());
            turnoverRecordEntity.setMaterialId(materialDealDetailEntity.getMaterialId());
            turnoverRecordEntity.setMaterialName(materialDealDetailEntity.getMaterialName());
            turnoverRecordEntity.setSpec(materialDealDetailEntity.getSpec());
            turnoverRecordEntity.setUnit(materialDealDetailEntity.getUnit());
            turnoverRecordEntity.setAssetId(materialDealDetailEntity.getAssetId());
            turnoverRecordEntity.setAssetCode(materialDealDetailEntity.getAssetCode());
            turnoverRecordEntity.setAssetType(materialDealDetailEntity.getAssetType());
            turnoverRecordEntity.setOrgId(materialDealEntity.getOrgId());
            turnoverRecordEntity.setOrgName(materialDealEntity.getOrgName());
            turnoverRecordEntity.setProjectId(materialDealEntity.getProjectId());
            turnoverRecordEntity.setProjectName(materialDealEntity.getProjectName());
            turnoverRecordEntity.setSourceDate(materialDealEntity.getBillDate());
            turnoverRecordEntity.setSourceId(materialDealEntity.getId());
            turnoverRecordEntity.setSourceDetailId(materialDealDetailEntity.getId());
            turnoverRecordEntity.setBelongType(materialDealEntity.getBelongType());
            turnoverRecordEntity.setAssetBelongType(materialDealDetailEntity.getAssetBelongType());
            turnoverRecordEntity.setBelongOrgId(materialDealDetailEntity.getBelongOrgId());
            turnoverRecordEntity.setBelongOrgName(materialDealDetailEntity.getBelongOrgName());
            turnoverRecordEntity.setNum(materialDealDetailEntity.getDealNum());
            turnoverRecordEntitList.add(turnoverRecordEntity);
        }
        turnoverRecordService.saveBatch(turnoverRecordEntitList);
        return CommonResponse.success();
    }

}
