package com.ejianc.business.panhuo.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 调拨单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_panhuo_allot")
public class AllotEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="belong_type")
    private Integer belongType; // 调出类型 0=项目，1=公司
    @TableField(value="asset_belong_type")
    private Integer assetBelongType; // 资产归属 0-项目，1-公司
    @TableField(value="belong_org_id")
    private Long belongOrgId; // 归属公司主键
    @TableField(value="belong_org_name")
    private String belongOrgName; // 归属公司名称
    @TableField(value="asset_code")
    private String assetCode; // 资产编码
    @TableField(value="asset_id")
    private Long assetId; // 物资主键
    @TableField(value="goods_id")
    private Long goodsId; // 资产主键
    @TableField(value="order_id")
    private Long orderId; // 订单主键
    @TableField(value="material_id")
    private Long materialId; // 物资主键
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_code")
    private String materialCode; // 物资编号
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资类别
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物资类别编号
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资类别名称
    @TableField(value="asset_type")
    private Integer assetType; // 物资类型 0-周转材，1-台车
    @TableField(value="capacity")
    private java.math.BigDecimal capacity; // 承载量
    @TableField(value="source_id")
    private String sourceId; // 物资来源ID
    @TableField(value="system_id")
    private Long systemId; // 所属系统ID
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="mainimg_path")
    private String mainimgPath; // 资产主图URL
    @TableField(value="unit")
    private String unit; // 单位
    @TableField(value="price")
    private java.math.BigDecimal price; // 成交单价
    @TableField(value="nums")
    private java.math.BigDecimal nums; // 成交数量
    @TableField(value="amount")
    private java.math.BigDecimal amount; // 成交金额
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="dealr_time")
    private java.util.Date dealrTime; // 成交时间
    @TableField(value="confirmer")
    private Long confirmer; // 调出负责人
    @TableField(value="confirmer_name")
    private String confirmerName; // 调出负责人名称
    @TableField(value="sell_org")
    private Long sellOrg; // 调出组织主键
    @TableField(value="sell_org_name")
    private String sellOrgName; // 调出组织名称
    @TableField(value="sell_project")
    private Long sellProject; // 调出项目
    @TableField(value="sell_project_name")
    private String sellProjectName; // 调出项目名称
    @TableField(value="order_user_id")
    private Long orderUserId; // 调入负责人
    @TableField(value="order_user_name")
    private String orderUserName; // 调入负责人名称
    @TableField(value="buy_org")
    private Long buyOrg; // 调入组织主键
    @TableField(value="buy_org_name")
    private String buyOrgName; // 调入组织名称
    @TableField(value="buy_project")
    private Long buyProject; // 调入项目主键
    @TableField(value="buy_project_name")
    private String buyProjectName; // 调入项目名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_code")
    private String billCode; // 调拨单编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    

    /**
     * 调出类型 0=项目，1=公司
     */
    public Integer getBelongType() {
        return belongType;
    }

    /**
     * 调出类型 0=项目，1=公司
     */
    public void setBelongType(Integer belongType) {
        this.belongType = belongType;
    }
    /**
     * 资产归属 0-项目，1-公司
     */
    public Integer getAssetBelongType() {
        return assetBelongType;
    }

    /**
     * 资产归属 0-项目，1-公司
     */
    public void setAssetBelongType(Integer assetBelongType) {
        this.assetBelongType = assetBelongType;
    }
    /**
     * 归属公司主键
     */
    public Long getBelongOrgId() {
        return belongOrgId;
    }

    /**
     * 归属公司主键
     */
    public void setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
    }
    /**
     * 归属公司名称
     */
    public String getBelongOrgName() {
        return belongOrgName;
    }

    /**
     * 归属公司名称
     */
    public void setBelongOrgName(String belongOrgName) {
        this.belongOrgName = belongOrgName;
    }
    /**
     * 资产编码
     */
    public String getAssetCode() {
        return assetCode;
    }

    /**
     * 资产编码
     */
    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }
    /**
     * 物资主键
     */
    public Long getAssetId() {
        return assetId;
    }

    /**
     * 物资主键
     */
    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }
    /**
     * 资产主键
     */
    public Long getGoodsId() {
        return goodsId;
    }

    /**
     * 资产主键
     */
    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }
    /**
     * 订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资编号
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编号
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别编号
     */
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    /**
     * 物资类别编号
     */
    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资类型 0-周转材，1-台车
     */
    public Integer getAssetType() {
        return assetType;
    }

    /**
     * 物资类型 0-周转材，1-台车
     */
    public void setAssetType(Integer assetType) {
        this.assetType = assetType;
    }
    /**
     * 承载量
     */
    public java.math.BigDecimal getCapacity() {
        return capacity;
    }

    /**
     * 承载量
     */
    public void setCapacity(java.math.BigDecimal capacity) {
        this.capacity = capacity;
    }
    /**
     * 物资来源ID
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 物资来源ID
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 所属系统ID
     */
    public Long getSystemId() {
        return systemId;
    }

    /**
     * 所属系统ID
     */
    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 资产主图URL
     */
    public String getMainimgPath() {
        return mainimgPath;
    }

    /**
     * 资产主图URL
     */
    public void setMainimgPath(String mainimgPath) {
        this.mainimgPath = mainimgPath;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 成交单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 成交单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 成交数量
     */
    public java.math.BigDecimal getNums() {
        return nums;
    }

    /**
     * 成交数量
     */
    public void setNums(java.math.BigDecimal nums) {
        this.nums = nums;
    }
    /**
     * 成交金额
     */
    public java.math.BigDecimal getAmount() {
        return amount;
    }

    /**
     * 成交金额
     */
    public void setAmount(java.math.BigDecimal amount) {
        this.amount = amount;
    }
    /**
     * 成交时间
     */
    public java.util.Date getDealrTime() {
        return dealrTime;
    }

    /**
     * 成交时间
     */
    public void setDealrTime(java.util.Date dealrTime) {
        this.dealrTime = dealrTime;
    }
    /**
     * 调出负责人
     */
    public Long getConfirmer() {
        return confirmer;
    }

    /**
     * 调出负责人
     */
    public void setConfirmer(Long confirmer) {
        this.confirmer = confirmer;
    }
    /**
     * 调出负责人名称
     */
    public String getConfirmerName() {
        return confirmerName;
    }

    /**
     * 调出负责人名称
     */
    public void setConfirmerName(String confirmerName) {
        this.confirmerName = confirmerName;
    }
    /**
     * 调出组织主键
     */
    public Long getSellOrg() {
        return sellOrg;
    }

    /**
     * 调出组织主键
     */
    public void setSellOrg(Long sellOrg) {
        this.sellOrg = sellOrg;
    }
    /**
     * 调出组织名称
     */
    public String getSellOrgName() {
        return sellOrgName;
    }

    /**
     * 调出组织名称
     */
    public void setSellOrgName(String sellOrgName) {
        this.sellOrgName = sellOrgName;
    }
    /**
     * 调出项目
     */
    public Long getSellProject() {
        return sellProject;
    }

    /**
     * 调出项目
     */
    public void setSellProject(Long sellProject) {
        this.sellProject = sellProject;
    }
    /**
     * 调出项目名称
     */
    public String getSellProjectName() {
        return sellProjectName;
    }

    /**
     * 调出项目名称
     */
    public void setSellProjectName(String sellProjectName) {
        this.sellProjectName = sellProjectName;
    }
    /**
     * 调入负责人
     */
    public Long getOrderUserId() {
        return orderUserId;
    }

    /**
     * 调入负责人
     */
    public void setOrderUserId(Long orderUserId) {
        this.orderUserId = orderUserId;
    }
    /**
     * 调入负责人名称
     */
    public String getOrderUserName() {
        return orderUserName;
    }

    /**
     * 调入负责人名称
     */
    public void setOrderUserName(String orderUserName) {
        this.orderUserName = orderUserName;
    }
    /**
     * 调入组织主键
     */
    public Long getBuyOrg() {
        return buyOrg;
    }

    /**
     * 调入组织主键
     */
    public void setBuyOrg(Long buyOrg) {
        this.buyOrg = buyOrg;
    }
    /**
     * 调入组织名称
     */
    public String getBuyOrgName() {
        return buyOrgName;
    }

    /**
     * 调入组织名称
     */
    public void setBuyOrgName(String buyOrgName) {
        this.buyOrgName = buyOrgName;
    }
    /**
     * 调入项目主键
     */
    public Long getBuyProject() {
        return buyProject;
    }

    /**
     * 调入项目主键
     */
    public void setBuyProject(Long buyProject) {
        this.buyProject = buyProject;
    }
    /**
     * 调入项目名称
     */
    public String getBuyProjectName() {
        return buyProjectName;
    }

    /**
     * 调入项目名称
     */
    public void setBuyProjectName(String buyProjectName) {
        this.buyProjectName = buyProjectName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 调拨单编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 调拨单编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
