package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.LabeldetailEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.GoodsMapper;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsToolVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 资产表
 * 
 * @author generator
 * 
 */
@Service("goodsService")
public class GoodsServiceImpl extends BaseServiceImpl<GoodsMapper, GoodsEntity> implements IGoodsService{

    private static final String PANHUO_ZC = "ASSET_ZC";

    private static final String ASSET_CODE = "ASSET_CODE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrderService orderService;

//    @Autowired
//    private IImgdetailService imgdetailService;

    @Autowired
    private ITurnoverRecordService turnoverRecordService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ILabeldetailService labeldetailService;

    @Autowired
    private ICollectService collectService;

    @Override
    public CommonResponse<GoodsVO> saveGoods(GoodsVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity entity = BeanMapper.map(vo, GoodsEntity.class);
        if(StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        BigDecimal siteNums = vo.getSiteNums()==null?BigDecimal.ZERO:vo.getSiteNums();
        //根据资产主键asset_id 取在售可周转数量

        LambdaQueryWrapper<GoodsEntity> lambdachange = Wrappers.<GoodsEntity>lambdaQuery();
        lambdachange.eq(GoodsEntity::getTenantId, tenantId);
        lambdachange.eq(GoodsEntity::getAssetId,vo.getAssetId());
        lambdachange.in(GoodsEntity::getStatus,0,3);//0-在售，3-待回收 需将这两种状态的可周转数量取到
        List<GoodsEntity> goodsEntities = super.list(lambdachange);
        BigDecimal rotatableNums = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(goodsEntities)){
            rotatableNums =  goodsEntities.stream().map(e->e.getRotatableNums()==null?BigDecimal.ZERO:e.getRotatableNums()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        // todo 获取未生效的报废单数量

        if(BigDecimal.ZERO.compareTo(siteNums.subtract(rotatableNums))>=0){
            return CommonResponse.error("该资产编码对应的材料实际在场数量已小于0，不可上架(请检查在售和未生效报废单)");
        }

        if(1==entity.getType()&& 1==entity.getAssetType()) {
            //生成资产B的资产编码和主键
            CommonResponse<String> assetCode = billCodeApi.getCodeBatchByRuleCode(ASSET_CODE, tenantId);
            if (assetCode.isSuccess()) {
                entity.setAssetCode(assetCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setAssetId(IdWorker.getId());
        }
        //如果 项目 手工上架，并且该资产归属于公司，则上架后立即成为待公司回收
        if(0==entity.getType()&& 0==entity.getBelongType() && 1==entity.getAssetBelongType()){
            entity.setStatus(3);//待回收
            entity.setRecoveryType(2);//待公司回收
        }
        entity.setShelfTime(DateFormater.getCurrentDate());
        entity.setNums(vo.getRotatableNums());
        entity.setRemainingNums(vo.getRotatableNums());
        super.saveOrUpdate(entity, false);

        if(1==entity.getType()&& 1==entity.getAssetType()){
             //台车 加工上架A->B
            // ZCLJ 资产利旧 插入一条资产利旧(负)的数据 编码为A
            TurnoverRecordEntity turnoverRecordEntity = turnoverRecordService.getById(vo.getTurnoverRecordId());
            turnoverRecordEntity.setId(null);
            turnoverRecordEntity.setSourceId(entity.getId());
            turnoverRecordEntity.setSourceDetailId(entity.getId());
            turnoverRecordEntity.setOrgId(entity.getOrgId());
            turnoverRecordEntity.setOrgName(entity.getOrgName());
            turnoverRecordEntity.setProjectName(null);
            turnoverRecordEntity.setProjectId(null);
            turnoverRecordEntity.setCreateTime(entity.getCreateTime());
            turnoverRecordEntity.setCreateUserCode(entity.getCreateUserCode());
            turnoverRecordEntity.setSourceType(TurnoverTypeEnum.资产利旧.getCode());
            turnoverRecordEntity.setSourceTypeName(TurnoverTypeEnum.资产利旧.getName());
            turnoverRecordEntity.setSourceDate(entity.getCreateTime());
            turnoverRecordEntity.setNum(BigDecimal.ZERO.subtract(turnoverRecordEntity.getNum()==null?BigDecimal.ZERO:turnoverRecordEntity.getNum()));
            turnoverRecordService.save(turnoverRecordEntity);




            //加工上架  JGSJ加工上架 ，插入一条数据 编码为B，并且插入一条资产利旧(负)的数据 编码为A
            TurnoverRecordEntity saveEntity = BeanMapper.map(entity, TurnoverRecordEntity.class);
            //生成资产B的资产编码和主键
            saveEntity.setAssetCode(entity.getAssetCode());
            saveEntity.setAssetId(entity.getAssetId());
            saveEntity.setSourceId(entity.getId());
            saveEntity.setSourceDetailId(entity.getId());
            saveEntity.setSourceType(TurnoverTypeEnum.加工上架.getCode());
            saveEntity.setSourceTypeName(TurnoverTypeEnum.加工上架.getName());
            saveEntity.setSourceDate(entity.getCreateTime());
            saveEntity.setSourceId(entity.getId());
            saveEntity.setSourceDetailId(entity.getId());//目前放商品主键
            saveEntity.setNum(entity.getNums());
            saveEntity.setUseAssetId(vo.getUseAssetId());
            saveEntity.setUseAssetCode(vo.getUseAssetCode());
            saveEntity.setUseTon(vo.getUseTon());
            saveEntity.setAddTon(vo.getAddTon());
            turnoverRecordService.save(saveEntity);
        }

        GoodsVO resvo = BeanMapper.map(entity, GoodsVO.class);
        return CommonResponse.success("操作成功！",resvo);
    }


    @Override
    public CommonResponse<GoodsVO> saveGoodsTemp(GoodsVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity entity = BeanMapper.map(vo, GoodsEntity.class);
        if(StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(vo.getId() != null && vo.getId() > 0){
            //修改
            List<LabeldetailEntity> listlb = entity.getLabels();
            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq("source_id",vo.getId());
            labeldetailService.remove(labekWrapper);

            if(CollectionUtils.isNotEmpty(listlb)){
                listlb.forEach(e -> {
                    e.setId(null);
                });
            }
        }
        if(1==entity.getType()&& 1==entity.getAssetType()) {
            //生成资产B的资产编码和主键
            CommonResponse<String> assetCode = billCodeApi.getCodeBatchByRuleCode(ASSET_CODE, tenantId);
            if (assetCode.isSuccess()) {
                entity.setAssetCode(assetCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setAssetId(IdWorker.getId());
        }
        entity.setShelfTime(DateFormater.getCurrentDate());
        entity.setNums(vo.getRotatableNums());
        entity.setRemainingNums(vo.getRotatableNums());
        super.saveOrUpdate(entity, false);
        GoodsVO resvo = BeanMapper.map(entity, GoodsVO.class);
        return CommonResponse.success("操作成功！",resvo);
    }

    @Override
    public GoodsDetailsVO queryGoodsDetail(Long id) {
        GoodsEntity entity = super.selectById(id);
        GoodsDetailsVO vo = BeanMapper.map(entity, GoodsDetailsVO.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        //获取项目其他在售
        LambdaQueryWrapper<GoodsEntity> lambdachange = Wrappers.<GoodsEntity>lambdaQuery();
        lambdachange.eq(GoodsEntity::getTenantId, tenantId);
        lambdachange.eq(GoodsEntity::getOrgId,entity.getOrgId());
        lambdachange.eq(GoodsEntity::getStatus,0);
        lambdachange.gt(GoodsEntity::getRotatableNums,0);
        int nums = super.count(lambdachange);
        vo.setOtherNums(nums);
        LambdaQueryWrapper<GoodsEntity> lambdachange2 = Wrappers.<GoodsEntity>lambdaQuery();
        lambdachange2.eq(GoodsEntity::getTenantId, tenantId);
        lambdachange2.eq(GoodsEntity::getOrgId,entity.getOrgId());
        lambdachange2.eq(GoodsEntity::getStatus,0);
        lambdachange2.ne(GoodsEntity::getId,id);
        lambdachange2.gt(GoodsEntity::getRotatableNums,0);
        lambdachange2.last("limit 3");
        List<GoodsEntity> list = super.list(lambdachange2);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setOthersGoods(BeanMapper.mapList(list,GoodsVO.class));
        }
        if(0==entity.getAssetType()){
            // todo 获取周转材材料记录
        }else if(1==entity.getAssetType()){
            // todo 获取台车记录
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter(QueryParam.EQ,id));
        queryParam.getParams().put("user_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter(QueryParam.EQ,0));
        List<CollectEntity> listc= collectService.queryList(queryParam,false);
        if(CollectionUtils.isNotEmpty(listc)){
            vo.setIsCollect(1);
            vo.setCollectId(listc.get(0).getId());
        }else{
            vo.setIsCollect(0);
        }
        return vo;
    }

    @Override
    public List<GoodsEntity> queryGoods(Page pages, QueryWrapper queryWrapper,String lon,String lat) {
        return baseMapper.getGoods(pages,queryWrapper,lon,lat);
    }

    @Override
    public ReportVO orgStatistics(Long orgId) {
        List<Long> commonOrgIds = new ArrayList<>();
        if(null==orgId||orgId<=0){
            orgId = InvocationInfoProxy.getOrgId();
        }

        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        ReportVO resVO = new ReportVO();

        ReportVO pronumsVo = baseMapper.getPronums(InvocationInfoProxy.getTenantid(),commonOrgIds);
        if(null!=pronumsVo){
            resVO.setProNums(pronumsVo.getProNums()==null?BigDecimal.ZERO:pronumsVo.getProNums());
        }else{
            resVO.setProNums(BigDecimal.ZERO);
        }

        ReportVO goodsNumsVo = baseMapper.getGoodsnums(InvocationInfoProxy.getTenantid(),commonOrgIds);
        if(null!=goodsNumsVo){
            resVO.setGoodsNums(goodsNumsVo.getGoodsNums()==null?BigDecimal.ZERO:goodsNumsVo.getGoodsNums());
            resVO.setGoodsAmount(goodsNumsVo.getGoodsAmount()==null?BigDecimal.ZERO:goodsNumsVo.getGoodsAmount());
            if(null!=goodsNumsVo.getShelfTime()){
                int days = (int) ((new Date().getTime() - goodsNumsVo.getShelfTime().getTime()) / (1000*3600*24));
                resVO.setDays(days);
            }
        }else{
            resVO.setGoodsNums(BigDecimal.ZERO);
            resVO.setGoodsAmount(BigDecimal.ZERO);
            resVO.setDays(0);
        }

        ReportVO goodsNumsIngVo = baseMapper.getGoodsnumsIng(InvocationInfoProxy.getTenantid(),commonOrgIds);
        if(null!=goodsNumsIngVo){
            resVO.setShelfNums(goodsNumsIngVo.getShelfNums()==null?BigDecimal.ZERO:goodsNumsIngVo.getShelfNums());
            resVO.setShelfAmount(goodsNumsIngVo.getShelfAmount()==null?BigDecimal.ZERO:goodsNumsIngVo.getShelfAmount());
        }else{
            resVO.setShelfNums(BigDecimal.ZERO);
            resVO.setShelfAmount(BigDecimal.ZERO);
        }

        ReportVO OrdernumsVo = baseMapper.getOrdernums(InvocationInfoProxy.getTenantid(),commonOrgIds);
        if(null!=OrdernumsVo){
            resVO.setOrderNums(OrdernumsVo.getOrderNums()==null?BigDecimal.ZERO:OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount()==null?BigDecimal.ZERO:OrdernumsVo.getOrderAmount());
        }else{
            resVO.setOrderNums(OrdernumsVo.getOrderNums()==null?BigDecimal.ZERO:OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount()==null?BigDecimal.ZERO:OrdernumsVo.getOrderAmount());
        }

        return resVO;
    }

    @Override
    public List<ReportVO> periodStatistics(List<Long> commonOrgIds) {
        return baseMapper.getPeriodStatistics(InvocationInfoProxy.getTenantid(),commonOrgIds);
    }

    @Override
    public List<ReportVO> proportion(List<Long> commonOrgIds,int type) {
        if(type==0){//上架
            return baseMapper.getGoodsProportion(InvocationInfoProxy.getTenantid(),commonOrgIds);
        }else if(1==type){//在售
            return baseMapper.getGoodsIngProportion(InvocationInfoProxy.getTenantid(),commonOrgIds);
        }else{//成交
            return baseMapper.getProportion(InvocationInfoProxy.getTenantid(),commonOrgIds);
        }
    }
}
