package com.ejianc.business.asset.controller;

import java.io.Serializable;

import com.ejianc.business.asset.service.IPricePublishDetailService;
import com.ejianc.business.asset.service.IPricePublishService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.asset.bean.MaterialDealEntity;
import com.ejianc.business.asset.service.IMaterialDealService;
import com.ejianc.business.asset.vo.MaterialDealVO;

/**
 * 报废处置主表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("materialDeal")
public class MaterialDealController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IMaterialDealService service;

    @Autowired
    private IBillCodeApi billCodeApi;


    //项目单据编码规则
    public static final String EJC_MATERIAL_DEAL_XM = "EJC_MATERIAL_DEAL_XM";

    //公司单据编码规则
    public static final String EJC_MATERIAL_DEAL_GS = "EJC_MATERIAL_DEAL_GS";



    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialDealVO> saveOrUpdate(@RequestBody MaterialDealVO saveorUpdateVO) {
        if (null == saveorUpdateVO.getId()) {
            String billCodeRule = saveorUpdateVO.getBelongType() == 0 ? EJC_MATERIAL_DEAL_XM : EJC_MATERIAL_DEAL_GS;
            CommonResponse<String> codeResp = billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error("保存失败，获取自动编码失败！");
            }
            saveorUpdateVO.setBillCode(codeResp.getData());
            saveorUpdateVO.setBillDate(new Date());
            saveorUpdateVO.setFinishState(0);
        }
    	MaterialDealEntity entity = BeanMapper.map(saveorUpdateVO, MaterialDealEntity.class);
    	service.saveOrUpdate(entity, false);
    	MaterialDealVO vo = BeanMapper.map(entity, MaterialDealVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialDealVO> queryDetail(Long id) {
    	MaterialDealEntity entity = service.selectById(id);
    	MaterialDealVO vo = BeanMapper.map(entity, MaterialDealVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialDealVO> vos) {
        service.removeByIds(vos.stream().map(MaterialDealVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 项目周转材处置查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialDealVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("dealUserName", "orgName"));
        //项目
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 0));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<MaterialDealEntity> page = service.queryPage(param,false);
        IPage<MaterialDealVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialDealVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList4Org  公司周转材处置查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList4Org", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialDealVO>> queryList4Org(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("dealUserName", "orgName"));
        //公司
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 1));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MaterialDealEntity> page = service.queryPage(param,false);
        IPage<MaterialDealVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialDealVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
