package com.ejianc.business.asset.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.PricePublishDetailEntity;
import com.ejianc.business.asset.bean.PricePublishEntity;
import com.ejianc.business.asset.service.IPricePublishDetailService;
import com.ejianc.business.asset.service.IPricePublishService;
import com.ejianc.business.asset.vo.PricePublishDetailVO;
import com.ejianc.business.asset.vo.PricePublishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 价格发布主表
 *
 * @author generator
 */
@Controller
@RequestMapping("pricePublish")
public class PricePublishController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IBillCodeApi billCodeApi;


    @Autowired
    private IPricePublishService service;

    @Autowired
    private IPricePublishDetailService pricePublishDetailService;


    public static final String EJC_PRICE_PUBLISH = "EJC_PRICE_PUBLISH";


    /**
     * @param saveorUpdateVO id enabled
     * @description: 启用/停用
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.asset.vo.PricePublishVO>
     * @author songlx
     * @date: 2021-05-08
     */
    @RequestMapping(value = "/enabled", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> enabled(@RequestBody PricePublishVO saveorUpdateVO) {
        Long id = saveorUpdateVO.getId();
        PricePublishEntity publishEntity = service.getById(id);
        //原本是未启用, 如果是启用,判断当前是有已有启用的单据
        if (0 == publishEntity.getEnabled()) {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
            param.getParams().put("id", new Parameter(QueryParam.NE, publishEntity.getId()));
            List<PricePublishEntity> pricePublishEntities = service.queryList(param);
            if (CollectionUtil.isNotEmpty(pricePublishEntities)) {
                return CommonResponse.error("当前已存在启用状态的单据!");
            }
            publishEntity.setEnabled(1);
        } else {
            publishEntity.setEnabled(0);
        }
        PricePublishEntity entity = BeanMapper.map(publishEntity, PricePublishEntity.class);
        service.saveOrUpdate(entity, false);
        PricePublishVO vo = BeanMapper.map(entity, PricePublishVO.class);
        return CommonResponse.success("操作成功！");
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PricePublishVO> saveOrUpdate(@RequestBody PricePublishVO saveorUpdateVO) {
        if (null == saveorUpdateVO.getId()) {
            CommonResponse<String> codeResp = billCodeApi.getCodeBatchByRuleCode(EJC_PRICE_PUBLISH, InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error("保存失败，获取自动编码失败！");
            }
            saveorUpdateVO.setBillCode(codeResp.getData());
            saveorUpdateVO.setBillDate(new Date());
            saveorUpdateVO.setEnabled(0);
        }
        PricePublishEntity entity = BeanMapper.map(saveorUpdateVO, PricePublishEntity.class);
        service.saveOrUpdate(entity, false);
        PricePublishVO vo = BeanMapper.map(entity, PricePublishVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PricePublishVO> queryDetail(Long id) {
        PricePublishEntity entity = service.selectById(id);
        PricePublishVO vo = BeanMapper.map(entity, PricePublishVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PricePublishVO> vos) {
        service.removeByIds(vos.stream().map(PricePublishVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PricePublishVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("employeeName", "billCode"));

        //机构权限过滤
        /*CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("当前用户没有组织权限,查询失败！");
        }
        param.getParams().put("org_id", new Parameter(QueryParam.IN, childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        */
        param.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //启用状态
        param.getOrderMap().put("enabled", QueryParam.DESC);
        param.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<PricePublishEntity> page = service.queryPage(param, false);
        IPage<PricePublishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PricePublishVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param vos 入参List[materialTypeId, // 物资分类Id materialId; // 物资id]
     * @description: 查询物资指导价格
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.business.asset.vo.PricePublishVO>>
     * @author songlx
     * @date: 2021-05-08
     */
    @RequestMapping(value = "/queryGuidePrice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<PricePublishDetailVO>> queryGuidePrice(@RequestBody List<PricePublishDetailVO> vos) {

        Map param = new HashMap<String, Object>();
        param.put("enabled", 1);
        param.put("tenantId", InvocationInfoProxy.getTenantid());

        Map<String, Object> beans = new HashMap<String, Object>();
        List<PricePublishDetailEntity> pricePublishDetailEntities = service.queryDetail(param);
        if (CollectionUtil.isNotEmpty(pricePublishDetailEntities)) {
            HashMap<Long, BigDecimal> priceMap = new HashMap<>();
            for (PricePublishDetailEntity e : pricePublishDetailEntities) {
                Long mid = e.getMaterialId() != null ? e.getMaterialId() : e.getMaterialTypeId();
                priceMap.put(mid, e.getGuidePrice());
            }

            for (PricePublishDetailVO v : vos) {
                Long materialId = v.getMaterialId();
                Long materialTypeId = v.getMaterialTypeId();
                BigDecimal price = priceMap.get(materialId) != null ? priceMap.get(materialId) : priceMap.get(materialTypeId);
                v.setGuidePrice(price);
            }

        }

        return CommonResponse.success("操作成功！", vos);
    }


    /**
     * @param param
     * @description: 往期价格发布参照
     * @return: com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.asset.vo.PricePublishVO>>
     * @author songlx
     * @date: 2021-05-10
     */
    @RequestMapping(value = "/pricePublishRef", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PricePublishVO>> pricePublishRef(@RequestBody QueryParam param) {

        param.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //启用状态
        param.getOrderMap().put("enabled", QueryParam.DESC);
        param.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<PricePublishEntity> page = service.queryPage(param, false);
        IPage<PricePublishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PricePublishVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param id
     * @Description queryDetailRef 查询详情
     */
    @RequestMapping(value = "/queryDetailRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PricePublishVO> queryDetailRef(Long id) {
        PricePublishEntity entity = service.selectById(id);
        entity.setId(null);
        entity.setEnabled(0);
        entity.setCreateUserCode(null);
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setVersion(null);
        entity.setTenantId(null);
        entity.setBillDate(new Date());
        entity.setPublishDate(new Date());
        entity.setBillState(null);
        List<PricePublishDetailEntity> pricePublishDetail = entity.getPricePublishDetail();
        for(PricePublishDetailEntity p : pricePublishDetail){
            p.setRowState("add");
            p.setPId(null);
            p.setCreateUserCode(null);
            p.setCreateTime(null);
            p.setUpdateTime(null);
            p.setUpdateUserCode(null);
            p.setVersion(null);
            p.setTenantId(null);
        }
        PricePublishVO vo = BeanMapper.map(entity, PricePublishVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


}
