package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.TurnoverRecordEntity;
import com.ejianc.business.asset.consts.TurnoverTypeEnum;
import com.ejianc.business.asset.service.ITurnoverRecordService;
import com.ejianc.business.asset.vo.RecordVO;
import com.ejianc.business.asset.vo.TurnoverRecordVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 周转记录
 *
 * @author generator
 */
@Controller
@RequestMapping("turnoverRecord")
public class TurnoverRecordController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITurnoverRecordService service;


    @Autowired
    IMaterialApi materialApi;


    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @description: 在场物资参照树结构
     * @return: java.util.List<java.util.Map < java.lang.String, java.lang.Object>>
     * @author songlx
     * @date: 2021-05-11
     */
    @RequestMapping(value = "/treeMaterial", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> treeMaterialList(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                      @RequestParam(defaultValue = "10") Integer pageSize,
                                                      @RequestParam(value = "condition", required = false) String condition,
                                                      @RequestParam(value = "searchText", required = false) String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.setFuzzyFields(Arrays.asList("materialTypeName"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("assetCode")) {
                String assetCode = conditionMap.get("assetCode").toString();
                param.getParams().put("assetCode", new Parameter(QueryParam.EQ, assetCode));
            }
            if (null != conditionMap.get("assetType")) {
                Integer assetType = Integer.valueOf(conditionMap.get("assetType").toString());
                param.getParams().put("assetType", new Parameter(QueryParam.EQ, assetType));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            }
            if (null != conditionMap.get("belongType")) {
                Integer belongType = Integer.valueOf(conditionMap.get("belongType").toString());
                param.getParams().put("belongType", new Parameter(QueryParam.EQ, belongType));
            }
            if (null != conditionMap.get("assetBelongType")) {
                Integer assetBelongType = Integer.valueOf(conditionMap.get("assetBelongType").toString());
                param.getParams().put("assetBelongType", new Parameter(QueryParam.EQ, assetBelongType));
            }
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<TurnoverRecordVO> list = service.queryMaterialTreeRef(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            List<Long> materialTypeIds = list.stream().map(TurnoverRecordVO::getMaterialTypeId).collect(Collectors.toList());
            CommonResponse<List<MaterialCategoryVO>> categoryList = materialApi.queryCategoryListByChildren(materialTypeIds);
            List<MaterialCategoryVO> data = categoryList.getData();
            List<Map> resultMapList = BeanMapper.mapList(data, Map.class);
            return ResultAsTree.createTreeData(resultMapList);
        }
        return null;
    }


    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param relyCondition
     * @param searchText
     * @description: 在场物资参照 表
     * @return: com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.asset.vo.TurnoverRecordVO>>
     * @author songlx
     * @date: 2021-05-11
     */
    @RequestMapping(value = "/onMaterialList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TurnoverRecordVO>> onMaterialList(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                  @RequestParam(defaultValue = "10") Integer pageSize,
                                                                  @RequestParam(value = "condition", required = false) String condition,
                                                                  @RequestParam(value = "relyCondition", required = false) String relyCondition,
                                                                  @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.setFuzzyFields(Arrays.asList("assetCode", "materialCode", "materialName"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("assetCode")) {
                String assetCode = conditionMap.get("assetCode").toString();
                param.getParams().put("assetCode", new Parameter(QueryParam.EQ, assetCode));
            }
            if (null != conditionMap.get("assetType")) {
                Integer assetType = Integer.valueOf(conditionMap.get("assetType").toString());
                param.getParams().put("assetType", new Parameter(QueryParam.EQ, assetType));
            }
            if (null != conditionMap.get("orgId")) {
                Long orgId = Long.valueOf(conditionMap.get("orgId").toString());
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            }

            if (null != conditionMap.get("belongType")) {
                Integer belongType = Integer.valueOf(conditionMap.get("belongType").toString());
                param.getParams().put("belongType", new Parameter(QueryParam.EQ, belongType));
            }
            if (null != conditionMap.get("assetBelongType")) {
                Integer assetBelongType = Integer.valueOf(conditionMap.get("assetBelongType").toString());
                param.getParams().put("assetBelongType", new Parameter(QueryParam.EQ, assetBelongType));
            }
            if (null != conditionMap.get("materialTypeId")) {
                Long materialTypeId = Long.valueOf(conditionMap.get("materialTypeId").toString());

            }
        }
        if (StringUtils.isNotBlank(relyCondition)) {
            Long materialTypeId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("materialTypeId", new Parameter(QueryParam.EQ, materialTypeId));
        }

        Page<TurnoverRecordVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<TurnoverRecordVO> list = service.queryMaterialRef(page, wrapper);
        IPage<TurnoverRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param param
     * @description: 查询周转记录
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.asset.vo.RecordVO>
     * @author songlx
     * @date: 2021-05-11
     */
    @RequestMapping(value = "/queryRecord", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RecordVO> queryRecord(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", QueryParam.ASC);
        List<TurnoverRecordEntity> turnoverRecordEntities = service.queryList(param, false);
        List<TurnoverRecordVO> turnoverRecordVOS = BeanMapper.mapList(turnoverRecordEntities, TurnoverRecordVO.class);
        RecordVO recordVO = new RecordVO();
        if (CollectionUtil.isNotEmpty(turnoverRecordVOS)) {
            recordVO.setAssetCode(turnoverRecordVOS.get(0).getAssetCode());
            recordVO.setAssetType(turnoverRecordVOS.get(0).getAssetType());
            //1台车 0周转材
            if (1 == recordVO.getAssetType()) {
                for (TurnoverRecordVO t : turnoverRecordVOS) {
                    if (t.getTon() != null) {
                        recordVO.setTon(t.getTon());
                    }
                    if (t.getUseTon() != null) {
                        recordVO.setUseTon(t.getUseTon());
                    }
                    if (t.getUseAssetCode() != null) {
                        recordVO.setUseAssetCode(t.getUseAssetCode());
                    }
                    if (t.getUseAssetId() != null) {
                        recordVO.setUseAssetId(t.getUseAssetId());
                    }

                }
            } else {
                BigDecimal onNum = BigDecimal.ZERO;
                BigDecimal dealNum = BigDecimal.ZERO;
                BigDecimal buyNum = BigDecimal.ZERO;
                for (TurnoverRecordVO t : turnoverRecordVOS) {
                    if (t.getSourceType() != null && (TurnoverTypeEnum.公司自采验收.getCode().equalsIgnoreCase(t.getSourceType()) || (TurnoverTypeEnum.项目自采验收.getCode().equalsIgnoreCase(t.getSourceType())))) {
                        buyNum = buyNum.add(t.getNum() != null ? t.getNum() : BigDecimal.ZERO);
                    }
                    onNum = onNum.add(t.getNum() != null ? t.getNum() : BigDecimal.ZERO);
                    if (t.getSourceType() != null && (TurnoverTypeEnum.公司资产处置.getCode().equalsIgnoreCase(t.getSourceType()) || (TurnoverTypeEnum.项目资产处置.getCode().equalsIgnoreCase(t.getSourceType())))) {
                        dealNum = dealNum.add(t.getNum() != null ? t.getNum() : BigDecimal.ZERO);
                    }
                }
                recordVO.setBuyNum(buyNum);
                recordVO.setOnNum(onNum);
                recordVO.setDealNum(dealNum);
            }
            recordVO.setTurnoverRecords(turnoverRecordVOS);
        }


        return CommonResponse.success("查询周转记录成功！", recordVO);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TurnoverRecordVO> saveOrUpdate(@RequestBody TurnoverRecordVO saveorUpdateVO) {
        TurnoverRecordEntity entity = BeanMapper.map(saveorUpdateVO, TurnoverRecordEntity.class);
        service.saveOrUpdate(entity, false);
        TurnoverRecordVO vo = BeanMapper.map(entity, TurnoverRecordVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TurnoverRecordVO> queryDetail(Long id) {
        TurnoverRecordEntity entity = service.selectById(id);
        TurnoverRecordVO vo = BeanMapper.map(entity, TurnoverRecordVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TurnoverRecordVO> vos) {
        service.removeByIds(vos.stream().map(TurnoverRecordVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TurnoverRecordVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<TurnoverRecordEntity> page = service.queryPage(param, false);
        IPage<TurnoverRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TurnoverRecordVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
