package com.ejianc.business.panhuo.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 调拨单
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("allot")
public class AllotController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IAllotService service;

    @Autowired
    private IOrgApi orgApi;

    static SimpleDateFormat sdf = new SimpleDateFormat(
            "yyyy-MM-dd");
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AllotVO> saveOrUpdate(@RequestBody AllotVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveAllot(saveorUpdateVO));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AllotVO> queryDetail(Long id) {
    	AllotEntity entity = service.selectById(id);
    	AllotVO vo = BeanMapper.map(entity, AllotVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllotVO> vos) {
        service.removeByIds(vos.stream().map(AllotVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AllotVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("confirmerName");
        fuzzyFields.add("orderUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Parameter dealrTime = param.getParams().get("dealrTime");
        if(dealrTime != null && dealrTime.getValue() != null){
            String value = String.valueOf(dealrTime.getValue());
            String[] split = value.split(",");
            if(null != split && split.length == 2){
                try {

                    Calendar c = Calendar.getInstance();
                    c.setTime(sdf.parse(split[1]));
                    // 设置当前日期
                    c.add(Calendar.DATE, 1); // 日期加1
                    Date date = c.getTime(); // 结果
                    String format = sdf.format(date);
                    String newValue = split[0] + "," + format;
                    dealrTime.setValue(newValue);
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        param.getComplexParams().add(getPageQueryParam());

        IPage<AllotEntity> page = service.queryPage(param,false);
        IPage<AllotVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllotVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    public ComplexParam getPageQueryParam() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        List<Long> childIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0) {
            childIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        } else {
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        }
        if(CollectionUtils.isNotEmpty(childIds)){
            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
            c2.getParams().put("sellOrg", new Parameter(QueryParam.IN, childIds));
            c1.getComplexParams().add(c2);

            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("buyOrg", new Parameter(QueryParam.IN, childIds));
            c1.getComplexParams().add(c3);
        }

        return c1;
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("confirmerName");
        fuzzyFields.add("orderUserName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 0));
        param.getComplexParams().add(getPageQueryParam());

        IPage<AllotEntity> page = service.queryPage(param,false);
        IPage<AllotVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllotVO.class));

        List<AllotVO> listExport = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(e->{
                if(0==e.getAssetType()){
                    e.setAssetTypeName("周转材");
                }else{
                    e.setAssetTypeName("台车");
                }
            });
            listExport = pageData.getRecords();
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("allotExport.xlsx", beans, response);
    }


    @RequestMapping(value = "/orgExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void OrgexcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("confirmerName");
        fuzzyFields.add("orderUserName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("belongType", new Parameter(QueryParam.EQ, 1));
        param.getComplexParams().add(getPageQueryParam());

        IPage<AllotEntity> page = service.queryPage(param,false);
        IPage<AllotVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllotVO.class));

        List<AllotVO> listExport = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(e->{
                if(0==e.getAssetType()){
                    e.setAssetTypeName("周转材");
                }else{
                    e.setAssetTypeName("台车");
                }
            });
            listExport = pageData.getRecords();
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("allotExport.xlsx", beans, response);
    }
    /**
     * 调拨单参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/allotRef")
    @ResponseBody
    public CommonResponse<IPage<AllotVO>> allotRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                              @RequestParam(defaultValue = "10") Integer pageSize,
                                              @RequestParam(value = "condition", required = false) String condition,
                                              @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("sellOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("assetCode");
        fuzzyFields.add("spec");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("state", new Parameter("eq", 0));
        Long orgId = InvocationInfoProxy.getOrgId();
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        queryParam.getParams().put("buy_org",new Parameter("in",orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<AllotEntity> pageData = service.queryPage(queryParam,false);
        IPage<AllotVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), AllotVO.class));
        return CommonResponse.success("调拨单列表查询成功！", result);
    }

}
